/***************************************************************************
                          kdialogsetupjoueur.cpp  -  description
                             -------------------
    begin                : Thu Jul 19 2001
    copyright            : (C) 2001 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define KDE_NO_COMPAT
#include "kplayersetupdialog.h"
#include "GameLogic/gameautomaton.h"
#include "GameLogic/player.h"
#include "GameLogic/gameautomaton.h"
#include "GameLogic/nationality.h"
#include "GameLogic/onu.h"
#include "Sprites/skinSpritesData.h"

#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>

#include <klocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kpassdlg.h>
#include <kmessagebox.h>

#define _XOPEN_SOURCE_
#include <unistd.h>

namespace Ksirk
{

KPlayerSetupDialog::KPlayerSetupDialog( GameLogic::ONU* onu,
                                        unsigned int playerNumber, QString &playerName,
                                        bool network, QString& password,
                                        bool &computerPlayer,
                                        std::map< QString, QString >& nations, 
                                        QString& nationName,
                                        QWidget *parent, const char */*name*/) :
  QPlayerSetupDialog(parent, playerName, true), name(playerName),
    computer(computerPlayer), m_nationName(nationName), 
  m_nations(nations), m_nationsNames(), number(playerNumber), 
  m_password(password), m_onu(onu)
{
//   kdDebug() << "KPlayerSetupDialog constructor" << endl;
  QString labelString = "";
  labelString.sprintf(i18n("Player Number %d, please type in your name<BR>and choose your nation:"), number);
  TextLabel1-> setText(labelString);
  fillNationsCombo();
  if (network)
    passwordEdit->setEnabled(true);
  QObject::connect((const QObject *)PushButton1, SIGNAL(clicked()), this, SLOT(slotOK()) );
  
//   kdDebug() << "KPlayerSetupDialog connecting to playerJoinedGame" << endl;
  connect(&GameLogic::GameAutomaton::changeable(),SIGNAL(signalPlayerJoinedGame(KPlayer*)),
          this,SLOT(slotPlayerJoinedGame(KPlayer*)));
  
  LineEdit2->setFocus();
  
  connect(nationCombo, SIGNAL(activated(int)), this, SLOT(slotNationChanged()));
}

KPlayerSetupDialog::~KPlayerSetupDialog(){
}

void KPlayerSetupDialog::slotOK()
{
//   kdDebug() << "slotOk" << endl;

  if (!testEmptyUserName(LineEdit2->text().stripWhiteSpace())) {
    // Empty name, but required, do not close dialog
    KMessageBox::error(this,
      "<html><center><b>" + i18n("Error") + "</b><br>" +
      i18n("Player %1, you have to choose a name!").arg(number) +
          "</center></html>", i18n("Error"));
  }
  else if (!testUniqueUserName(LineEdit2->text().stripWhiteSpace())) {
    // Name is not unique
    KMessageBox::error(this,
      "<html><center><b>" + i18n("Error") + "</b><br>" +
      i18n("Player %1, you have to choose another name!<br>%2 is not unique.")
              .arg(number)
              .arg(LineEdit2->text()) +
          "</center></html>", i18n("Error"));
  }
  else {
    name = LineEdit2-> text();
//     kdDebug() << "Got name " << name << endl;
    computer = CheckBox1-> isOn();
//     kdDebug() << "computer? : " << computer << endl;
    m_nationName = m_nationsNames[nationCombo->currentText()];
    m_password = QString(crypt(passwordEdit->password(),"T6"));

    accept();
  }
}

void KPlayerSetupDialog::reject() {
//   kdDebug() << "I not allow to close the dialog!" << endl;
}

void KPlayerSetupDialog::fillNationsCombo()
{
//   kdDebug() << "Filling nations combo" << endl;
  KStandardDirs *m_dirs = KGlobal::dirs();

  std::map< QString, QString >::const_iterator nationsIt, nationsIt_end;
  nationsIt = m_nations.begin(); nationsIt_end = m_nations.end();
  
  GameLogic::Nationality* nation = m_onu->nationNamed((*nationsIt).first);
  LineEdit2-> setText(nation->leaderName());

  for (; nationsIt != nationsIt_end; nationsIt++)
  {
//     kdDebug() << "Adding nation " << i18n((*nationsIt).first) << " / " << (*nationsIt).second << endl;
    QString imgName = m_dirs-> findResource("appdata", GameLogic::GameAutomaton::single().skin() + "/Images/sprites/" + (*nationsIt).second);
    if (imgName.isNull())
    {
      KMessageBox::error(this, i18n("Flag image resource not found\nProgram cannot continue"), i18n("Error !"));
        exit(2);
    }
//     load image
    QPixmap flag(imgName);
    flag.resize(flag.width()/Sprites::SkinSpritesData::single().intData("flag-frames"),flag.height());
//     get name
    QString name(i18n((*nationsIt).first));
    m_nationsNames.insert(std::make_pair(i18n((*nationsIt).first),(*nationsIt).first)); 
//     fill a combo entry
    nationCombo->insertItem(flag,name);
  }
  
  
}

void KPlayerSetupDialog::slotPlayerJoinedGame(KPlayer* player)
{
//   kdDebug() << "KPlayerSetupDialog::slotPlayerJoinedGame: " << player->name() 
//       << " from " << ((GameLogic::Player*)player)->getNation()->name() << endl;
  for (int i = 0 ; i < nationCombo->count(); i++)
  {
    if (nationCombo->text(i) == m_nationsNames[((GameLogic::Player*)player)->getNation()->name()])
    {
      nationCombo->removeItem(i);
      break;
    }
  }
}

inline bool KPlayerSetupDialog::testEmptyUserName(const QString& name) const {
  return (name != "");
}

inline bool KPlayerSetupDialog::testUniqueUserName(const QString& name) const {
  GameLogic::PlayersArray::const_iterator it =
    GameLogic::GameAutomaton::changeable().playerList()->constBegin();
  const GameLogic::PlayersArray::const_iterator it_end =
    GameLogic::GameAutomaton::changeable().playerList()->constEnd();

  for (; it != it_end; it++) {
    if ((*it)->name() == name) {
      // Player with "name" already registered
      return false;
    }
  }

  return true;
}

void KPlayerSetupDialog::slotNationChanged()
{
//   kdDebug() << "KPlayerSetupDialog::slotNationChanged " << nationCombo->currentText() << endl;
  GameLogic::Nationality* nation = m_onu->nationNamed(m_nationsNames[nationCombo->currentText()]);
//   kdDebug() << "nation = " << nation << endl;
  LineEdit2-> setText(nation->leaderName());
}


}

#include "kplayersetupdialog.moc"
