#include "newGameDialogImpl.h"

#include "GameLogic/onu.h"

#include <klocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>

#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qbuttongroup.h>
#include <qbutton.h>
#include <qradiobutton.h>
#include <qlabel.h>

namespace Ksirk
{

NewGameDialogImpl::NewGameDialogImpl(
      bool& ok,
      unsigned int& nbPlayers, 
      unsigned int maxPlayers,
      QString &skin,
      bool& networkGame,
      bool& useGoals,
      QWidget *parent, const char *name) :
    NewGameDialog(parent, name, true), m_ok(ok), m_nbPlayers(nbPlayers),
  m_skin(skin), m_networkGame(networkGame), m_useGoals(useGoals)
{
  kdDebug() << "Skin got by NewGameDialog: " << m_skin << endl;
  playersNumberEntry->setMinValue(2);
  playersNumberEntry->setMaxValue(maxPlayers);
  fillSkinsCombo();
  QObject::connect((const QObject *)buttonCancel, SIGNAL(clicked()), this, SLOT(slotCancel()) );
  QObject::connect((const QObject *)buttonOk, SIGNAL(clicked()), this, SLOT(slotOK()) );
  QObject::connect((const QObject *)buttonHelp, SIGNAL(clicked()), this, SLOT(slotHelp()) );
  QObject::connect((const QObject *)skinCombo, SIGNAL(activated(int)), this, SLOT(slotSkinChanged(int)) );
}

NewGameDialogImpl::~NewGameDialogImpl()
{
  QMap<QString, GameLogic::ONU*>::iterator it, it_end;
  it = m_worlds.begin(); it_end = m_worlds.end();
  for (; it != it_end; it++)
  {
    delete(it.data());
  }
}

void NewGameDialogImpl::slotOK()
{
  kdDebug() << "KPlayerSetupDialog slotOk" << endl;
  m_nbPlayers = playersNumberEntry->value();
  m_skin = m_worlds[skinCombo->currentText()]->skin();
  kdDebug() << "  m_skin is " << m_skin << endl;
  m_networkGame  = networkGameCheckBox->isChecked();
  m_useGoals = (goalGroup->selected() == radioGoal);
  m_ok = true;
  close();
}

void NewGameDialogImpl::slotCancel()
{
  kdDebug() << "KPlayerSetupDialog slotCancel" << endl;
  m_ok = false;
  close();
}

/** @todo implements a help */
void NewGameDialogImpl::slotHelp()
{
  kdDebug() << "KPlayerSetupDialog slotHelp not already implemented" << endl;
  KMessageBox::sorry(this, i18n("Help currently unavailable."),i18n("KsirK - No help !"));
}

/** @todo Add a thumbnail of the skin map for example */
void NewGameDialogImpl::fillSkinsCombo()
{
  kdDebug() << "Filling skins combo" << endl;
  KStandardDirs *m_dirs = KGlobal::dirs();
  QString skinsDirName = m_dirs-> findResourceDir("appdata", "skins/skinsdir");
  if (skinsDirName.isEmpty())
  {
    KMessageBox::error(0,
                       i18n("Skins directory not found - Verify your installation\nProgram cannot continue"),
                       i18n("Fatal Error !"));
    exit(2);
  }
  skinsDirName += "skins/";
  kdDebug() << "Got skins dir name: " << skinsDirName << endl;
  QDir skinsDir(skinsDirName);
  QStringList skinsDirsNames = skinsDir.entryList("[a-zA-Z]*", QDir::Dirs);
  
  uint skinNum = 0;
  uint currentSkinNum;
  QStringList::iterator it, it_end;
  it = skinsDirsNames.begin(); it_end = skinsDirsNames.end();
  for (; it != it_end; it++, skinNum++)
  {
    kdDebug() << "Got skin dir name: " << *it << endl;
    QDir skinDir(skinsDirName + *it);
    if (skinDir.exists())
    {
      kdDebug() << "Got skin dir: " << skinDir.dirName() << endl;
      GameLogic::ONU* world = new GameLogic::ONU(skinsDirName + skinDir.dirName() + "/Data/onu.xml");
      skinCombo->insertItem(i18n(world->name()));
      m_worlds[i18n(world->name())] = world;
      if (QString("skins/")+skinDir.dirName() == m_skin)
      {
        kdDebug() << "Setting currentSkinNum to " << skinNum << endl;
        currentSkinNum = skinNum;
      }
    }
  }
  skinCombo->setCurrentItem(currentSkinNum);
  slotSkinChanged(currentSkinNum);
}

void NewGameDialogImpl::slotSkinChanged(int skinNum)
{
    kdDebug() << "NewGameDialogImpl::slotSkinChanged " 
              << skinNum << " ; " << skinCombo->currentText() 
              << " ; " << m_worlds[skinCombo->currentText()]->name() << " ; " 
              << m_worlds[skinCombo->currentText()]->description() << endl;
    skinDescLabel->setText(i18n(m_worlds[skinCombo->currentText()]->description()));
    skinSnapshotPixmap->setPixmap(m_worlds[skinCombo->currentText()]->snapshot());
}

}

#include "newGameDialogImpl.moc"
