/***************************************************************************
                          KsirkChatItem.cpp  -  description
                             -------------------
    begin                : Mon Sep 26 2006
    copyright            : (C) 2006 by Gaël de Chalendar (aka Kleag)
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>
#include <qapplication.h>
#include <qpainter.h>
#include <qcolordialog.h>
#include <qinputdialog.h>
#include <qmessagebox.h>
#include <qsimplerichtext.h>
#include "KsirkChatItem.h"
#include "player.h"

namespace Ksirk
{

namespace GameLogic
{

KsirkChatItem::KsirkChatItem (QListBox * listbox) : QListBoxItem(listbox)
{ 
}

KsirkChatItem::KsirkChatItem (const QString& text, Player* player, QListBox * listbox)
: QListBoxItem(listbox)
{ 
  *this << text << "";
  if (player != 0)
  {
    QPixmap pm(*player->getFlag()->image(0));
    *this << pm; 
  }
}

int KsirkChatItem::width(const QListBox* lb) const 
{ 
  return lb->clipper()->width() ; 
}

int KsirkChatItem::height(const QListBox*) const 
{ 
  return 20 ; 
}

void KsirkChatItem::paint(QPainter* p)
{ 
  unsigned int w = width(listBox()) ;
  unsigned int h = height(listBox()) ;
  unsigned int x = 0;
  for (unsigned int i = 0 ; i < m_order.size(); i++)
  {
    QSimpleRichText rt(m_strings[i], p->font());
    rt.adjustSize();
    rt.setWidth(p, w);
    switch (m_order[i])
    {
    case Text:
      rt.draw(p, x, 0, QRect(0,0,w,h), QColorGroup ()) ;
      x += rt.widthUsed();
    break;
    case Pixmap:
      if (! m_pixmaps[i].isNull())
      {
        QPixmap scaled;
        scaled.convertFromImage(m_pixmaps[i].convertToImage().scaleHeight(h), 0);
        p->drawPixmap(x,0,scaled);
        x += m_pixmaps[i].width();
      }
    break;
    default: ;
    }
  }
}

KsirkChatItem& KsirkChatItem::operator<<(const QString& text)
{
  m_strings.push_back(text);
  m_pixmaps.push_back(QPixmap ());
  m_order.push_back(Text);
  return *this;
}

KsirkChatItem& KsirkChatItem::operator<<(const QPixmap& pixmap)
{
  m_strings.push_back("");
  m_pixmaps.push_back(pixmap);
  m_order.push_back(Pixmap);
  return *this;
}

} // closing namespace GameLogic

} // closing namespace Ksirk

