/***************************************************************************
                          KsirkChatItem.h  -  description
                             -------------------
    begin                : Mon Sep 26 2006
    copyright            : (C) 2006 by Gaël de Chalendar (aka Kleag)
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KSIRKCHATITEM_H
#define KSIRKCHATITEM_H

#include <qwidget.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qcolor.h>

#include <vector>

namespace Ksirk
{

namespace GameLogic
{

class Player;

class KsirkChatItem : public QListBoxItem
{ 
  enum ElemType {Text,Pixmap};

public:
  KsirkChatItem (QListBox * listbox);
  KsirkChatItem (const QString& text, Player* player, QListBox * listbox);
  
  virtual ~KsirkChatItem() {}
  
  virtual int width(const QListBox* lb) const;
  
  virtual int height(const QListBox*) const;

  KsirkChatItem& operator<<(const QString& text);
  KsirkChatItem& operator<<(const QPixmap& pixmap);

protected:
  virtual void paint(QPainter* p) ;

private:
//   enum ElemType {Text,Pixmap};
  std::vector<QPixmap> m_pixmaps;
  std::vector<QString> m_strings;
  std::vector<ElemType> m_order;
} ; // class KsirkChatItem


} // closing namespace GameLogic

} // closing namespace Ksirk

#endif // KSIRKCHATITEM_H
