/***************************************************************************
                          aiplayer.h  -  description
                             -------------------
    begin                : sam sep 14 2002
    copyright            : (C) 2002 by Gael de Chalendar
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AIPLAYER_H
#define AIPLAYER_H

#include "GameLogic/gameautomaton.h"
#include "GameLogic/player.h"
#include "GameLogic/country.h"

#include <qthread.h>
#include <qptrqueue.h>

#include <utility>
/**
  * This class represents a computer player. It holds all strategic routines
  * @author Gael de Chalendar
  */

namespace Ksirk
{

namespace GameLogic
{

class Nationality;
class ONU;
class AIPlayerIO;
class GameAutomaton;

class AIPlayer : public Player, public QThread
{
Q_OBJECT

public: 
  virtual ~AIPlayer() {}

  /** 
    * Constructor with simple initializations
    */
  AIPlayer(
          const QString & nomPlayer, unsigned int nbArmies,
          Nationality * myNation,  PlayersArray& players, ONU* world,
          GameAutomaton* game );

  /**
    * The idendification of the player. Overwrite this in
    * classes inherting KPlayer to run time identify them.
    *
    * @return 0 for default KPlayer.
  */
  virtual int rtti() const {return 2;}
  
  /**
    * Returns true (an AIPlayer is an AI)
    */
  virtual bool isAI() const;

    /** set stopMe to true in order for the run method to return */
  void stop();
    
  virtual void saveXml(std::ostream& xmlStream);

protected:
  /** 
    * This function is called whenever the player should choose an action (
    * attack, defense, etc.). It has the responsability to choose the correct
    * action depending on the state of the game.
    */
  virtual void actionChoice(GameLogic::GameAutomaton::GameState state);

  /** Returns a pair of countries where the attacker have enough armies to attack and the defender is a ennemy neighbour of the attacker */
  virtual std::pair< const Country*, const Country* > chooseBelligerant();

  /**
    * Chooses the next action. In the current basic setting, chooses at random
    * between the three possibilities. For each, chooses randomly the
    * parameters.If the randomly choosen parameters end by an impossible 
    * action, continue with next player.
    */
  virtual void chooseAttackMoveArmiesOrNextPlayer();

  /**
    * Chooses a country to receive a new army in dotation
    */
  virtual Country* chooseReceivingCountry();
  
  /**
    * chooses to continue invasion with a certain amount of armies or to stop it
    */
  virtual void chooseInvasionAction();
  
  /**
    * make all what is necessary to prepare and launch an attack
    * @return true if was able to prepare an attack ; false otherwise
    */
  bool attackAction();
  
  /**
    * makes all what is necessary to prepare and start the moving of armies
    */
  virtual bool moveArmiesAction();
  
  /**
    * makes what is necessary to finish my turn
    */
  void nextPlayerAction();
  
protected: // Private attributes
  AIPlayerIO* aiPlayerIO();
  
/**
    * Pointer to the players. Informations about them is necessary decide of
    * a strategy
    */
  PlayersArray& allPlayers;

  /**
    * Pointer to the World to consult it in order to decide the actions
    */
  ONU* m_world;

  /**
    * a pointer to the game. Necessary to be able to access the number of
    * attackers, etc. This solution is not very pretty... but an important
    * architectural change should be done to avoid it (@todo).
    */
  GameAutomaton* m_game;

  /** indicates to the thread if the run method should return */
  bool stopMe;

  /** pointers to the source and target country of an attack */
  const Country* m_src;
  const Country* m_dest;

  /** number of armies to move during an invasion or an end of turn moving */
  unsigned int m_toMove;
    
  bool m_hasVoted;
private: // Private methods
  /**
    * chooses wether to defend with one or two armies. Always chooses the maximum possible
    */
  void chooseDefenseAction();
  
  /**
    * Takes the decision to recycle armies or not
    */
  void chooseWetherToRecycle();
  
  /**
    * chooses a country where to place a new army
    */
  void placeArmiesAction();
  
  /** Makes the choice of nb armies to move during an invasion or an end of turn moving */
  void chooseNbToMoveOrStop();
  
  void run();

};

} // closing namespace GameLogic
} // closing namespace Ksirk
#endif

