/***************************************************************************
                          continent.h  -  description
                             -------------------
    begin                : sam sep 7 2002
    copyright            : (C) 2002 by Gael de Chalendar
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTINENT_H
#define CONTINENT_H

#include "country.h"

namespace Ksirk
{

namespace GameLogic
{


/**This class represents the continents of the world. Each country belongs to a continent. When a player owns all the countries of a continent, he wins more armies. It is the basic object on which the strategies are funded.
  *@author Gael de Chalendar
  */

class Continent
{
public: 
  Continent();
  virtual ~Continent();

  /**
    * Read property of std::vector<Country*> members.
    */
  virtual const std::vector<Country*>& getMembers() const;

  /** The constructor-initializer */
  Continent (const QString &myName, const std::vector<Country*>& myCountries, const int myBonus, unsigned int id);

  /** Read property of QString name. */
  virtual const QString& name() const;

  /** Read property of int bonus. */
  virtual const int& getBonus() const;

  /** Returns the player that owns all the countries of this continent. 0 if none. */
  const Player* owner() const;

  void saveXml(std::ostream& xmlStream);
  
  inline unsigned int id() const {return m_id;}
  inline unsigned int id() {return m_id;}
  inline void id(unsigned int id) {m_id = id;}

  /** Returns the list of countries owned by @ref player */
  std::vector<Country*> countriesOwnedBy(const Player* player);

private: // Private attributes

  /** This is the list of the countries that forms this continent. This member
    * is constant as it will not change during the game.
    */
  std::vector<Country*> m_members;

  /** The name of the continent */
  const QString m_name;

  /** The bonus armies got by a user that owns all this continent */
  const int bonus;
  
  unsigned int m_id;
};

}
}
#endif
