//
// C++ Interface: goal
//
// Description: 
//
//
// Author: Gaël de Chalendar (akaKleag) <kleag@free.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KSIRK_GAMELOGICGOAL_H
#define KSIRK_GAMELOGICGOAL_H

#include<set>

#include <qdatastream.h>

namespace Ksirk {

namespace GameLogic {

class Player;

/**
@author Gaël de Chalendar
*/
class Goal
{
public:
  enum GoalType {
    NoGoal,
    GoalPlayer,
    Countries,
    Continents,
  };

  enum DisplayType {
    GoalDesc = 1,
    GoalAdvance = 2
  };
  
  Goal();
  
  Goal(const Goal& goal);
  
  ~Goal();

  inline GoalType type() const {return m_type;}
  inline GoalType type() {return m_type;}
  inline void type(GoalType type) {m_type = type;}
  
  inline const QString& description() const {return m_description;}
  inline QString& description() {return m_description;}
  inline void description(const QString& desc) {m_description = desc;}
  
  inline unsigned int nbCountries() const {return m_nbCountries;}
  inline unsigned int nbCountries() {return m_nbCountries;}
  inline void nbCountries(unsigned int nb) {m_nbCountries = nb;}
  
  inline unsigned int nbArmiesByCountry() const {return m_nbArmiesByCountry;}
  inline unsigned int nbArmiesByCountry() {return m_nbArmiesByCountry;}
  inline void nbArmiesByCountry(unsigned int nb) {m_nbArmiesByCountry = nb;}
  
  inline std::set<unsigned int>& continents() {return m_continents;}
  inline const std::set<unsigned int>& continents() const {return m_continents;}
  
  inline std::set<unsigned int>& players() {return m_players;}
  inline const std::set<unsigned int>& players() const {return m_players;}
  
  inline const Player* player() const {return m_player;}
  inline Player* player() {return m_player;}
  inline void player(Player*  p) {m_player = p;}
  
  bool checkFor(const Player* player) const;
  
  bool checkCountriesFor(const Player* player) const;

  bool checkContinentsFor(const Player* player) const;

  void show(int displayType = GoalDesc);
    
  void saveXml(std::ostream& xmlStream) const;
  
  QString message(int displayType = GoalDesc); 

private:
  GoalType m_type;
  QString m_description;
  unsigned int m_nbCountries;
  unsigned int m_nbArmiesByCountry;
  std::set<unsigned int> m_continents;
  std::set<unsigned int> m_players;
  Player* m_player;
};

QDataStream& operator<<(QDataStream& stream, const Goal& goal);
QDataStream& operator>>(QDataStream& stream, Goal& goal);

}

}

#endif
