//
// C++ Implementation: kstringvector
//
// Description: 
//
//
// Author: Gaël de Chalendar (aka Kleag) <kleag@free.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kstringvector.h"
#include "kdebug.h"

#include <stdexcept>

namespace Ksirk {

namespace GameLogic {

KStringVector::KStringVector()
{
}


KStringVector::~KStringVector()
{
}

KStringVector& KStringVector::operator<<(const QString& text)
{
  m_strings.push_back(text);
  m_pixmaps.push_back(QPixmap());
  m_order.push_back(Text);
  return *this;
}

KStringVector& KStringVector::operator<<(const QPixmap& pixmap)
{
  m_strings.push_back("");
  m_pixmaps.push_back(pixmap);
  m_order.push_back(Pixmap);
  return *this;
}

KStringVector& KStringVector::operator>>(QString& s)
{
  if (nextIsText())
  {
    s = m_strings.front();
    m_strings.pop_front();
    m_pixmaps.pop_front();
    m_order.pop_front();
    return *this;
  }
  else
  {
    throw std::runtime_error("Next is not text");
  }
}

KStringVector& KStringVector::operator>>(QPixmap& p)
{
  if (nextIsPixmap())
  {
    p = m_pixmaps.front();
    m_pixmaps.pop_front();
    m_strings.pop_front();
    m_order.pop_front();
    return *this;
  }
  else
  {
    throw std::runtime_error("Next is not pixmap");
  }
}

bool KStringVector::nextIsText()
{
  return (m_order.front() == Text);
}

bool KStringVector::nextIsPixmap()
{
  return (m_order.front() == Pixmap);
}

bool KStringVector::empty()
{
  return m_order.empty();
}

unsigned int KStringVector::size()
{
  return m_order.size();
}
  
void KStringVector::clear()
{
  m_strings.clear();
  m_pixmaps.clear();
  m_order.clear();
}

KStringVector::iterator KStringVector::begin()
{
  iterator it;
  it.m_pixmaps_it = m_pixmaps.begin();
  it.m_strings_it = m_strings.begin();
  it.m_order_it =  m_order.begin();
  return it;
}

KStringVector::iterator KStringVector::end()
{
  iterator it;
  it.m_pixmaps_it = m_pixmaps.end();
  it.m_strings_it = m_strings.end();
  it.m_order_it =  m_order.end();
  return it;
}


}

}
