//
// C++ Interface: kstringvector
//
// Description: 
//
//
// Author: Gaël de Chalendar (aka Kleag) <kleag@free.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KSIRK_GAMELOGICKSTRINGVECTOR_H
#define KSIRK_GAMELOGICKSTRINGVECTOR_H

#include <deque>
#include <qstring.h>
#include <qpixmap.h>

namespace Ksirk {

namespace GameLogic {

/**
@author Gaël de Chalendar
*/
class KStringVector
{
public:
  enum ElemType {Text,Pixmap};

  class iterator
  {
    friend class KStringVector;
  public:
    iterator& operator++(int)
    {
      m_pixmaps_it++;
      m_strings_it++;
      m_order_it++;
      return *this;
    }
    bool operator==(const iterator& it)
    {
      return ( (m_pixmaps_it == it.m_pixmaps_it)
              && (m_strings_it == it.m_strings_it)
              && (m_order_it == it.m_order_it) );
    }
    bool operator!=(const iterator& it)
    {
      return !((*this)==it);
    }
    iterator& operator=(const iterator& it)
    {
      m_pixmaps_it = it.m_pixmaps_it;
      m_strings_it = it.m_strings_it;
      m_order_it = it.m_order_it;
    }
    QPixmap& curPix() {return *m_pixmaps_it;}
    QString& curStr() {return *m_strings_it;}
    bool curIsPix() { return (*m_order_it == Pixmap);}
    bool curIsStr() { return (*m_order_it == Text);}
    
  private:
    std::deque<QPixmap>::iterator m_pixmaps_it;
    std::deque<QString>::iterator m_strings_it;
    std::deque<ElemType>::iterator m_order_it;
  };
  friend class iterator;

  KStringVector();

  ~KStringVector();

  KStringVector& operator<<(const QString& s);
  KStringVector& operator>>(QString& s);
  
  KStringVector& operator<<(const QPixmap& s);
  KStringVector& operator>>(QPixmap& s);
  
  bool nextIsText();
  bool nextIsPixmap();
  
  bool empty();
  unsigned int size();
  void clear();

  iterator begin();
  iterator end();

private:
  std::deque<QPixmap> m_pixmaps;
  std::deque<QString> m_strings;
  std::deque<ElemType> m_order;
};

}

}

#endif
