/***************************************************************************
                          nationality.h  -  description
                             -------------------
    begin                : sam ao 31 2002
    copyright            : (C) 2002 by Gael de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef  NATIONALITY_H
#define NATIONALITY_H

#include <qstring.h>


namespace Ksirk
{

namespace GameLogic
{

/**The Nationality class stores all what represents a country identity : name, flag, etc.
  *@author Gael de Chalendar
  */

class Nationality
{
public:
  Nationality(const QString &myName, const QString &myFlag, const QString& leaderName);

  virtual ~Nationality() {}
  
  /** Read property of QString m_flagFileName. */
  virtual const QString& flagFileName() const;

  /** Read property of QString m_name. */
  const QString& name() const;
  
  /** Read property of QString m_leaderName. */
  const QString& leaderName() const;
  
  void saveXml(std::ostream& xmlStream);

private: // Private attributes

  /** The nation's name. The name of its associated country in the real world. */
  QString m_name;

  /** The default name given to a player of the nationality */
  QString m_leaderName;

  /** The name of the file containing this nation's flag  */
  const QString m_flagFileName;
};

}
}

#endif // NATIONALITY_H
