/***************************************************************************
                          player.cpp  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2001 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define KDE_NO_COMPAT
#include "player.h"
#include "backgnd.h"
#include "Sprites/skinSpritesData.h"
#include "GameLogic/gameautomaton.h"
#include "GameLogic/goal.h"
#include "GameLogic/onu.h"
#include "kgamewin.h"

#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>

namespace Ksirk
{

namespace GameLogic
{

unsigned int Player::m_uid = 0;

Player::Player(
    const QString& playerName, 
    unsigned int nbArmies, 
    Nationality* nation) :
  KPlayer(),
  m_nation(nation),
  m_goal(new Goal()),
  m_flag(0),
  m_delayedInitNationName(""),
  m_waitedAck(0)
{
//   kdDebug() << "Player constructor" << endl;
  setAsyncInput(true);
  dataHandler()->setPolicy(KGamePropertyBase::PolicyClean,false);
  m_nbAttack.registerData(dataHandler(),KGamePropertyBase::PolicyClean,QString("m_nbAttack"));
  m_nbCountries.registerData(dataHandler(),KGamePropertyBase::PolicyClean,QString("m_nbCountries"));
  m_nbAvailArmies.registerData(dataHandler(),KGamePropertyBase::PolicyClean,QString("m_nbAvailArmies"));
  m_nbDefense.registerData(dataHandler(),KGamePropertyBase::PolicyClean,QString("m_nbDefense"));
  m_password.registerData(dataHandler(),KGamePropertyBase::PolicyClean,QString("m_password"));
  
  m_nbAttack = 0;
  m_nbDefense = 0;
  m_nbCountries = 0;
  m_nbAvailArmies = nbArmies;
  m_password = "";
  
  setName(playerName);
  setFlag();
//   kdDebug() << "Done creating player" << endl;
}

bool Player::operator==(const Player& player) const
{
  return (name() == player.name());
};


/**  */
unsigned int Player::getNbAvailArmies(){
    return (m_nbAvailArmies);
}

/**  */
void Player::setNbAvailArmies(unsigned int nb, bool transmit)
{
//   kdDebug() << name() << " setNbAvailArmies: " << nb << " transmit=" << transmit << endl;
  m_nbAvailArmies = nb;
/*  if (transmit)
  {
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    stream << name() << m_nbAvailArmies;
    GameAutomaton::changeable().sendMessage(buffer, PlayerAvailArmies);
  }*/
}

/**  */
unsigned int Player::getNbAttack()
{
    return (m_nbAttack);
}

/**  */
void Player::setNbAttack(unsigned int nb)
{
    m_nbAttack = nb;
}

/**  */
unsigned int Player::getNbDefense()
{
    return (m_nbDefense);
}

/**  */
void Player::setNbDefense(unsigned int nb)
{
    m_nbDefense = nb;
}

/** */
unsigned int Player::getNbCountries() const
{
    return (m_nbCountries);
}

/** add nb armies to the number of available armies */
void Player::incrNbAvailArmies(unsigned int nb)
{
  setNbAvailArmies(m_nbAvailArmies + nb);
}

/** remove nb armies to the number of available armies */
void Player::decrNbAvailArmies(unsigned int nb)
{
//   kdDebug() << "Player::decrNbAvailArmies " << name() << " " << nb << endl;
  if (nb > m_nbAvailArmies)
  {
    kdError() << "Removing " << nb << " armies while owning " << m_nbAvailArmies << endl;
    exit(1);
  }
  setNbAvailArmies(m_nbAvailArmies - nb);
}

/**  */
void Player::setNbCountries(unsigned int nb)
{
  m_nbCountries = nb;
}

/** add nb countries to the player */
void Player::incrNbCountries(unsigned int nb)
{
  setNbCountries(m_nbCountries + nb);
}

/** Enleve nb pays au player */
void Player::decrNbCountries(unsigned int nb)
{
    if (nb > m_nbCountries)
    {
      kdError() << "Removing " << nb << " countries to " << name() << " while owning " << m_nbCountries << endl;
      exit(1);
    }
  setNbCountries(m_nbCountries - nb);
}

/**
  * This function returns the flag associated to the nationality of the player
  */
const AnimSprite* Player::getFlag() const
{
//   kdDebug() << "Player::getFlag" << endl;
  return m_flag;
}

/**
  * This function returns the filename of the flag associated to the nationality of the player
  */
const QString& Player::flagFileName() const
{
    return m_nation-> flagFileName();
}

/**
  * Returns false (a Player is not an AI)
  */
bool Player::isAI() const
{
    return false;
}

void Player::saveXml(std::ostream& xmlStream)
{
  xmlStream << "<player ai=\"false\" ";
  innerSaveXml(xmlStream);
  xmlStream << " />" << std::endl;
}

void Player::innerSaveXml(std::ostream& xmlStream)
{
  QString theName = name().utf8();
  theName = theName.replace("&","&amp;");
  theName = theName.replace("<","&lt;");
  theName = theName.replace(">","&gt;");
  xmlStream << " name=\"" << theName << "\"";
  xmlStream << " nbCountries=\"" << m_nbCountries << "\"";
  xmlStream << " nbAvailArmies=\"" << m_nbAvailArmies << "\"";
  xmlStream << " nbAttack=\"" << m_nbAttack << "\"";
  xmlStream << " nbDefense=\"" << m_nbDefense << "\"";
  QString nationName = m_nation->name();
  nationName = nationName.replace("&","&amp;");
  nationName = nationName.replace("<","&lt;");
  nationName = nationName.replace(">","&gt;");
  xmlStream << " nation=\"" << nationName << "\"";
  xmlStream << " password=\"" << m_password.value() << "\"";
}

bool   Player::load (QDataStream &stream)
{
//   kdDebug() << "Player::load" << endl;
  if (!KPlayer::load(stream)) return false;
  QString nationName;
  stream >> nationName;
//   kdDebug() << "Player::load nationName=" << nationName << endl;
  setNation(nationName);
  stream >> *m_goal;
  return true;
}

bool Player::save (QDataStream &stream)
{
//   kdDebug() << "Player::save" << endl;
  if (!KPlayer::save(stream)) return false;
  stream << m_nation->name();
  stream << *m_goal;
  return true;
}

Nationality* Player::getNation() 
{
  kdDebug() << "Player::getNation for " << name() << endl;
  if (m_nation == 0 && m_delayedInitNationName != "")
  {
    kdError() << "  retrieving delayed nation " << m_delayedInitNationName << endl;
    setNation(m_delayedInitNationName);
  }
  return m_nation;
}

Nationality* Player::myNation() 
{
  kdDebug() << "Player::getNation for " << name() << endl;
  if (m_nation == 0 && m_delayedInitNationName != "")
  {
    kdError() << "  retrieving delayed nation " << m_delayedInitNationName << endl;
    setNation(m_delayedInitNationName);
  }
  return m_nation;
}

void Player::setNation(const QString& nationName)
{
  m_nation = GameLogic::GameAutomaton::changeable().game()->theWorld()-> nationNamed(nationName);
  if (m_nation == 0)
  {
//     kdDebug() << "Delaying nation initialization ("<<nationName<<") for " << name() << endl;
    m_delayedInitNationName = nationName;
  }
  setFlag();
}

void Player::setFlag()
{
/*  if (m_flag != 0)
    delete m_flag;*/
  m_flag = 0;
  if (m_nation != 0)
  {
    QCanvasPixmapArray pma;
    m_flag = new AnimSprite(&pma, 
                            m_nation->flagFileName(), 
                            GameLogic::GameAutomaton::changeable().game()->backGnd(), 
                            Sprites::SkinSpritesData::single().intData("flag-frames"), 
                            Sprites::SkinSpritesData::single().intData("flag-versions"));
    m_flag->hide();
  }
}

void Player::goal(Goal* goal) 
{
  if (m_goal)
  {
    delete m_goal;
  }
  m_goal = new Goal(*goal);
  m_goal->player(this);
  if (!isVirtual() && !isAI())
  {
    KMessageBox::information(
                              GameAutomaton::changeable().game(), 
                              i18n("%1, your goal will be displayed. Please make sure that no other player can see it !").arg(name()), i18n("KsirK - Displaying Goal"));
    m_goal->show();    
  }
}

bool Player::checkGoal()
{
  return m_goal->checkFor(this);
  
}

/**
  * Returns the list of the countries owned by this player
  */
std::vector<Country*> Player::countries() const
{
//   kdDebug() << name() << ": Player::countries()" << endl;
  std::vector<Country*> list;
  for ( unsigned int i = 0; i < GameAutomaton::changeable().game()->theWorld()->getCountries().size(); i++ )
  {
    Country* c = GameAutomaton::changeable().game()->theWorld()->getCountries().at(i);
    if (c-> owner() == static_cast< const Player * >(this))
    {
//            kdDebug() << "\t" << c-> name() << endl;
      
      list.push_back(c);
    }
  }
//    kdDebug() << name() << ": OUT AIPlayer::countries()" << endl;
  return list;
}

bool Player::acknowledge(unsigned int ack)
{
  if (ack == m_waitedAck)
  {
    m_waitedAck = 0;
    return true;
  }
  else
  {
    return false;
  }
}

QDataStream& operator<<(QDataStream& stream, PlayerMatrix& p)
{
  stream << p.name << Q_UINT32(p.nbAttack) << Q_UINT32(p.nbCountries) << Q_UINT32(p.nbAvailArmies)
    << Q_UINT32(p.nbDefense) << p.nation << Q_UINT32(p.isAI) << Q_UINT32(p.countries.size());
  std::set<QString>::iterator it, it_end;
  it = p.countries.begin(); it_end = p.countries.end();
  for (; it != it_end; it++)
  {
    stream << (*it);
  }
  stream << *p.goal;
  return stream;
}

QDataStream& operator>>(QDataStream& stream, PlayerMatrix& p)
{
  Q_UINT32 nbCountries;
  stream >> p.name >> p.nbAttack >> p.nbCountries >> p.nbAvailArmies >> p.nbDefense >> p.nation;
  Q_UINT32 isAI;
  stream >> isAI;
  p.isAI = (bool)isAI;
  stream >> nbCountries;
  for (Q_UINT32 i = 0 ; i < nbCountries; i++)
  {
    QString country;
    stream >> country;
    p.countries.insert(country);
  }
  Goal* goal = new Goal();
  stream >> *goal;
  p.goal = goal;
  return stream;
}

} // closing namespace GameLogic

} // closing namespace Ksirk

#include "player.moc"
