/***************************************************************************
                          player.h  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2001 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define KDE_NO_COMPAT

#ifndef PLAYER_H
#define PLAYER_H

#include "global.h"
#include "GameLogic/gameautomaton.h"
#include "nationality.h"
#include "Sprites/animsprite.h"

#include <kgame/kplayer.h>
#include <kgame/kgame.h>
#include <kgame/kgameproperty.h>

#include <qstring.h>
#include <qvaluevector.h>
#include <qptrqueue.h>

#include <set>

namespace Ksirk
{

class BackGnd;
class Goal;

namespace GameLogic
{

class Nationality;

/**
  * The class Player represents a player and its associated data
  */
class Player : public KPlayer
{
  Q_OBJECT
public:

  /**
    * Constructor with simple initializations
    */
  Player(const QString &nomPlayer, unsigned int nbArmies, Nationality* myNation);

  virtual ~Player() {}

  /**
    * The idendification of the player. Overwrite this in
    * classes inherting KPlayer to run time identify them.
    *
    * @return 0 for default KPlayer.
  */
  virtual int rtti() const {return 1;}
  
  /**
    * comparison on the players' names
    */
  virtual bool operator==(const Player& player) const;

  /**
    * Accessors to the variables
    */
  void setNbAvailArmies(unsigned int nb, bool transmit = true);
  unsigned int getNbAvailArmies();
  void setNbAttack(unsigned int nb);
  unsigned int getNbAttack();
  void setNbDefense(unsigned int nb);
  unsigned int getNbDefense();
  void setNbCountries(unsigned int nb);
  unsigned int getNbCountries() const;

  /**
    * Add/Remove nb armies to the number of available armies (defaults to 1)
    */
  void incrNbAvailArmies(unsigned int nb=1);
  void decrNbAvailArmies(unsigned int nb=1);

  /**
    * Add/Remove nb countries to the player (defaults to 1)
    */
  void incrNbCountries(unsigned int nb=1);
  void decrNbCountries(unsigned int nb=1);

  /** This function returns the flag associated to the nationality of the player */
  const AnimSprite* getFlag() const;
  const QString& flagFileName() const;

  /**
    * This function is called whenever the player should choose an action
    * (attack, defence, etc.). If the player is human, this method do nothing
    * and so is empty. Its inherited version, in AIPlayer will have an activity
    */
  virtual void actionChoice(GameLogic::GameAutomaton::GameState /*state*/) {}

  /**
    * Returns false (a Player is not an AI)
    */
  virtual bool isAI() const;

  virtual void saveXml(std::ostream& xmlStream);
  
  virtual bool   load (QDataStream &stream);
  virtual bool   save (QDataStream &stream);
  
  Nationality* getNation();
  /// @todo see why this method is necessary (cf. setupOnePlayer in kgamewin.cpp)
  Nationality* myNation(); 
  void setNation(const QString& nationName);
  
  void setFlag();
  
  inline void setPassword(const QString& password) {m_password = password;}
  inline const QString& getPassword() const {return m_password.value();}
  
  inline Goal* goal() const {return m_goal;}
  inline Goal* goal() {return m_goal;}
  void goal(Goal* goal);
  
  bool checkGoal();
  
  /**
    * @return The list of the countries owned by this player
    */
  std::vector<Country*> countries() const;
  
  #define AUTHOR "Gael de Chalendar"
  virtual QString author() {return AUTHOR;}

  /** 
    * Called once when all players are created/loaded/joined and when the
    * game can start. Allows to initialize AIs with public data about other
    * players.
    */
  virtual void finalize() {}

  /** 
    * Called by the game automaton to acknowledge the reception of a message
    * by the master
    * @return true if the ack received was the waited one; false otherwise.
    */
  bool acknowledge(unsigned int ack);

protected:
  void innerSaveXml(std::ostream& xmlStream);
  

  /**
    * Number of armies used for an attack
    * (  0 <> 3, < nbArmies of the country )
    */
  KGamePropertyUInt m_nbAttack;

  /**
    * Number of countries owned by the player
    */
  KGamePropertyUInt m_nbCountries;

  /**
    * Number of armies the player can distribute
    */
  KGamePropertyUInt m_nbAvailArmies;
//   unsigned int m_nbAvailArmies;

  /**
    * Number of armies used for defense
    * (  0 <> 2, <= nbArmies used for the attack, < nbArmies of the country )
    */
  KGamePropertyUInt m_nbDefense;

  /**
    * The nation choosen by the player
    */
  Nationality *m_nation;

  KGamePropertyQString m_password;

  Goal* m_goal;

  QString m_delayedInitNationName;

  /** Used to transmit uniq ids and request for an acknowledgement of 
    * of their reception. */
  static unsigned int m_uid;

  unsigned int m_waitedAck;

private:

  AnimSprite* m_flag;
};

typedef KGame::KGamePlayerList PlayersArray;


struct PlayerMatrix
{

  QString name;
  
  unsigned int nbAttack;
  
  unsigned int nbCountries;
  
  unsigned int nbAvailArmies;
  
  unsigned int nbDefense;
  
  QString nation;
  
  QString password;
  
  std::set<QString> countries;
  
  GameLogic::GameAutomaton::GameState state;
  
  bool isAI;
  
  Goal* goal;
};

QDataStream& operator<<(QDataStream& stream, PlayerMatrix& p);

QDataStream& operator>>(QDataStream& stream, PlayerMatrix& p);

} // closing namespace GameLogic

} // closing namespace Ksirk

#endif // PLAYER_H
