/***************************************************************************
                          ksirkgamexmlhandler.cpp  -  
                          SAX2 handler for game XML files
                             -------------------
    begin                : Mon Feb 07 2005
    copyright            : (C) 2001 by Gael de Chalendar
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "global.h"
#include "ksirkgamexmlhandler.h"
#include "GameLogic/country.h"
#include "GameLogic/onu.h"
#include "GameLogic/goal.h"
#include "GameLogic/kstringvector.h"

#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>

#include <sstream>
#include <map>

namespace Ksirk
{
using namespace GameLogic;

namespace SaveLoad
{

bool GameXmlHandler::startDocument()
{ 
//   kdDebug() << "startDocument" << endl;
  return true;
}

bool GameXmlHandler::startElement( const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts ) 
{
  kdDebug() << "startElement " << localName << " / " << qName << endl;
  if (localName == "ksirkSavedGame")
  {
    QString fv =atts.value("formatVersion");
    QString wfv =SAVE_GAME_FILE_FORMAT_VERSION;
    if (fv!=wfv)
    {
      KMessageBox::sorry(0, i18n("Wrong save game format. Waited %1 and got %2 !").arg(SAVE_GAME_FILE_FORMAT_VERSION).arg(atts.value("formatVersion")),i18n("KsirK - Cannot load !"));

      return false;
    }
  }
  else if (localName == "game")
  {
//     kdDebug() << "GameXmlHandler stored game state is: " << atts.value("state") << endl;
    
    std::istringstream issSkin(atts.value("skin"));
    std::string skin;
    issSkin >> skin;
    GameLogic::GameAutomaton::changeable().skin(skin);
    
    std::istringstream iss(atts.value("state"));
    int istate;
    iss >> istate;
    m_savedState = GameLogic::GameAutomaton::GameState(istate);
    GameLogic::GameAutomaton::changeable().savedState(m_savedState);
  }
  else if (localName == "players" && !m_inGoal)
  {
    std::istringstream iss(atts.value("nb"));
    int nb;
    iss >> nb;
    kdDebug() << "Setting min-max players to " << nb << endl;
    GameLogic::GameAutomaton::changeable().setMinPlayers(nb);
    GameLogic::GameAutomaton::changeable().setMaxPlayers(nb);
  }
  else if (localName == "player" && !m_inGoal)
  {
    m_playersNumber++;
    unsigned int nbAvailArmies;
    std::istringstream issNbAvailArmies(atts.value("nbAvailArmies"));
    issNbAvailArmies >> nbAvailArmies;
    
    unsigned int nbCountries;
    std::istringstream issNbCountries(atts.value("nbCountries"));
    issNbCountries >> nbCountries;
    
    QString name = atts.value("name");
    
    QString nationName = atts.value("nation");
    
    unsigned int nbAttack;
    std::istringstream issNbAttack(atts.value("nbAttack"));
    issNbAvailArmies >> nbAttack;
    
    unsigned int nbDefense;
    std::istringstream issNbDefense(atts.value("nbDefense"));
    issNbAvailArmies >> nbDefense;
    
    
    bool isAi = false;
    if (atts.value("ai") == "true") isAi = true;
    
    QString password = atts.value("password");
    
    if (password == "")
    {
      m_game.addPlayer(name, nbAvailArmies, nbCountries, nationName, isAi, password, nbAttack, nbDefense);
    }
    else
    {
      PlayerMatrix pm;
      pm.name = name;
      pm.nbAttack = nbAttack;
      pm.nbCountries = nbCountries;
      pm.nbAvailArmies = nbAvailArmies;
      pm.nbDefense = nbDefense;
      pm.nation = nationName;
      pm.password = password;
      pm.isAI = isAi;
      m_waitedPlayers.push_back(pm);
      std::map<QString,QString>::iterator it, it_end;
      it = m_ownersMap.begin(); it_end = m_ownersMap.end();
      for (; it != it_end; it++)
      {
        if ( (*it).second == name )
        {
          pm.countries.insert((*it).first);
        }
      }
    }
  }
  else if (localName == "currentPlayer")
  {
    Player* currentPlayer = GameLogic::GameAutomaton::changeable().playerNamed(atts.value("name"));
    if (currentPlayer)
    {
//       kdDebug() << "Setting current player to " << atts.value("name") << " / " << currentPlayer << endl;
      GameLogic::GameAutomaton::changeable().currentPlayer(currentPlayer);
      KStringVector messageParts;
      messageParts << I18N_NOOP("Current player is: %1") << currentPlayer->name();
      m_game.broadcastChangeItem(messageParts, ID_STATUS_MSG2);
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      stream << currentPlayer->name();
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,SetBarFlagButton);
    }
    GameLogic::GameAutomaton::changeable().savedPlayer(atts.value("name"));
  }
  else if (localName == "ONU")
  {
//     kdDebug() << "GameXmlHandler starts new game with ONU file: " << atts.value("file") << endl;
    if (!(GameLogic::GameAutomaton::changeable().playerList()->isEmpty()))
    {
      GameLogic::GameAutomaton::changeable().playerList()->clear();
      GameLogic::GameAutomaton::changeable().currentPlayer(0);
      kdDebug() << "  playerList size = " << GameLogic::GameAutomaton::changeable().playerList()->count() << endl;
    }
    GameLogic::GameAutomaton::changeable().game()->newSkin(atts.value("file"));
  }
  else if (localName == "country")
  {
//   kdDebug() << "GameXmlHandler loads country: " << atts.value("name") << endl;
    Country* country = m_game.theWorld()->countryNamed(atts.value("name"));
    unsigned int gotNbArmies;
    std::istringstream issNbArmies(atts.value("nbArmies"));
    issNbArmies >> gotNbArmies;
    country->nbArmies(gotNbArmies);
    
    unsigned int gotNbAddedArmies;
    std::istringstream issNbAddedArmies(atts.value("nbArmiesAdded"));
    issNbArmies >> gotNbAddedArmies;
    country->nbAddedArmies(gotNbAddedArmies);
    
    m_ownersMap[atts.value("name")] = atts.value("owner");
  }
  else if (localName == "goal")
  {
//     kdDebug() << "GameXmlHandler loads goal for: " << atts.value("player") << endl;
    m_goal = new GameLogic::Goal();
    m_goalPlayerName = atts.value("player");
    Player* player = GameLogic::GameAutomaton::changeable().playerNamed(atts.value("player"));
//     kdDebug() << "Got player pointer " << player << endl;
    m_goal->player(player);
    unsigned int type;
    std::istringstream issType(atts.value("type"));
    issType >> type;
    m_goal->type(GameLogic::Goal::GoalType(type));
    m_goal->description(atts.value("description"));
    unsigned int nbCountries;
    std::istringstream issNbCountries(atts.value("nbCountries"));
    issNbCountries >> nbCountries;
    m_goal->nbCountries(nbCountries);
    unsigned int nbArmiesByCountry;
    std::istringstream issNbArmiesByCountry(atts.value("nbArmiesByCountry"));
    issNbArmiesByCountry>> nbArmiesByCountry;
    m_goal->nbArmiesByCountry(nbArmiesByCountry);
    
    m_inGoal = true;
  }
  else if (localName == "player" && m_inGoal)
  {
    unsigned int id = GameLogic::GameAutomaton::changeable().playerNamed(atts.value("name"))->id();
    m_goal->players().insert(id);
  }
  else if (localName == "continent" && m_inGoal)
  {
    kdDebug() << "Getting id of continent named " << atts.value("name") << endl;
    unsigned int id = (atts.value("name")!="") ? 
        m_game.theWorld()->continentNamed(atts.value("name"))->id() :
        0;
    m_goal->continents().insert(id);
  }
  return true;
}

bool GameXmlHandler::endElement(const QString& namespaceURI, const QString& localName, const QString& qName)
{
  kdDebug() << "endElement " << localName << " / " << qName << endl;
  if (localName == "game")
  {
    std::map<QString, QString>::const_iterator it, it_end;
    it = m_ownersMap.begin(); it_end = m_ownersMap.end();
    for (; it != it_end; it++)
    {
      Country* country = m_game.theWorld()->countryNamed((*it).first);
      Player* owner = GameLogic::GameAutomaton::changeable().playerNamed((*it).second);
      if (owner)
      {
//         kdDebug() << "Setting owner of " << country->name() << " to " << owner->name() << endl;
        country-> owner(owner);
      }
      else
      {
        std::vector<GameLogic::PlayerMatrix>::iterator itw,itw_end;
        itw = m_waitedPlayers.begin(); itw_end = m_waitedPlayers.end();
        for (; itw != itw_end; itw++)
        {
          if ( (*itw).name == (*it).second )
          {
            (*itw).countries.insert((*it).first);
            break;
          }
        }
      }
    }
    if (!m_waitedPlayers.empty())
    {
      kdDebug() << "There is waited players: does not change state nor run game..." << endl;
      m_waitedPlayers[0].state = m_savedState;
    }
    else
    {
      kdDebug() << "GameXmlHandler set game state to: " << m_savedState << endl;
      GameLogic::GameAutomaton::changeable().state(m_savedState);
      GameLogic::GameAutomaton::changeable().setGameStatus(KGame::Run);
      m_game.initTimer();
    }
  }
  else if (localName == "goal")
  {
    m_inGoal = false;
    if (m_goal)
    {
      if (m_goal->player())
      {
        m_goal->player()->goal(m_goal);
      }
      else
      {
        std::vector<GameLogic::PlayerMatrix>::iterator itw,itw_end;
        itw = m_waitedPlayers.begin(); itw_end = m_waitedPlayers.end();
        for (; itw != itw_end; itw++)
        {
          if ( (*itw).name == m_goalPlayerName )
          {
            (*itw).goal = new GameLogic::Goal(*m_goal);
            break;
          }
        }
      }
      delete m_goal;
    }
    m_goal = 0;
  }
  return true;
}


} // closing namespace SaveLoad
} // closing namespace Ksirk


