/***************************************************************************
                          ksirkgamexmlhandler.h  -  
                          SAX2 handler for game XML files
                             -------------------
    begin                : Mon Feb 07 2005
    copyright            : (C) 2001 by Gael de Chalendar
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#define KDE_NO_COMPAT

#ifndef KSIRK_SAVELOAD_KSIRKGAMEXMLHANDLER_H
#define KSIRK_SAVELOAD_KSIRKGAMEXMLHANDLER_H

#include "global.h"
#include "kgamewin.h"
#include "GameLogic/gameautomaton.h"
#include "GameLogic/player.h"
#include "GameLogic/goal.h"

#include <qstring.h>
#include <qxml.h>

#include <map>
#include <vector>

namespace Ksirk
{

namespace SaveLoad
{

class GameXmlHandler : public QXmlDefaultHandler
{
public:
GameXmlHandler(KGameWindow& game, std::vector<GameLogic::PlayerMatrix>& waitedPlayers) : 
    m_game(game),
    m_waitedPlayers(waitedPlayers),
    m_playersNumber(0),
    m_inGoal(false),
    m_goal(0)
  {
    m_waitedPlayers.clear();
  }
  virtual ~GameXmlHandler() {}

  bool startDocument();
  bool startElement( const QString&, const QString&, const QString& ,
                      const QXmlAttributes& );
  bool endElement( const QString&, const QString&, const QString& );

private:
  KGameWindow& m_game;
  GameLogic::GameAutomaton::GameState m_savedState;
  std::map<QString,QString> m_ownersMap;
  std::vector<GameLogic::PlayerMatrix>& m_waitedPlayers;
  unsigned int m_playersNumber;
  bool m_inGoal;
  GameLogic::Goal* m_goal;
  QString m_goalPlayerName;
};


} // closing namespace SaveLoad
} // closing namespace Ksirk


#endif // KSIRK_SAVELOAD_KSIRKGAMEXMLHANDLER_H

