/***************************************************************************
                          ksirkgamexmlloader.cpp  -  
                          SAX2 parser for game XML files
                             -------------------
    begin                : Mon Feb 07 2005
    copyright            : (C) 2001 by Gael de Chalendar
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "global.h"
#include "ksirkgamexmlloader.h"
#include "ksirkgamexmlhandler.h"

#include <qxml.h>

namespace Ksirk
{
namespace SaveLoad
{

GameXmlLoader::GameXmlLoader(const QString& fileName, KGameWindow& game, std::vector<GameLogic::PlayerMatrix>& waitedPlayers)
{
  GameXmlHandler handler(game, waitedPlayers);
  
  QFile xmlFile( fileName );
  QXmlInputSource source( &xmlFile );
  
  QXmlSimpleReader reader;
  reader.setContentHandler( &handler );
  
  if (!reader.parse( source ))
  {
    exit(0);
  }
}

const QString& GameXmlLoader::onuFile()
{
  return m_onuFile;
}

} // closing namespace SaveLoad
} // closing namespace Ksirk

