/***************************************************************************
                          animsprite.cpp  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2001 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/* **************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define KDE_NO_COMPAT
#include "animsprite.h"
#include "backgnd.h"
#include "ksirksettings.h"
#include "GameLogic/nationality.h"
#include "GameLogic/country.h"
#include "GameLogic/gameautomaton.h"

#include <qpoint.h>
#include <qmessagebox.h>

#include <klocale.h>
#include <kstandarddirs.h>
#include <kdebug.h>

namespace Ksirk
{

using namespace GameLogic;

AnimSprite::AnimSprite(QCanvasPixmapArray* pma, const QString &imgPath, BackGnd* aBackGnd,
                        unsigned int nbFrames, unsigned int nbDirs, unsigned int visibility) :
    QCanvasSprite(pma, aBackGnd-> canvas()), look(right), nbVersions(nbDirs),
    backGnd(aBackGnd), destination(0), frames(nbFrames), actFrame(0),
    myState(NONE), 
    approachDestByLeft(false), approachDestByRight(false),
    approachDestByTop(false), approachDestByBottom(false)
{
  setNone();

  KStandardDirs *m_dirs = KGlobal::dirs();

//   kdDebug() << "Sprite file name: " << GameLogic::GameAutomaton::single().skin() + "/Images/sprites/" + imgPath << endl;
  QString imgName = m_dirs-> findResource("appdata", GameLogic::GameAutomaton::single().skin() + "/Images/sprites/" + imgPath);
//   kdDebug() << "imgName= " << imgName << endl;
  if (imgName.isNull())
  {
      QMessageBox::critical(0, i18n("Error !"), i18n("Sprite images resource not found\nProgram cannot continue"));
      exit(2);
  }
  if (!bitmapInfo.load(imgName))
  {
      QMessageBox::critical(0, i18n("Error !"), i18n("Cannot load sprite image\nProgram cannot continue"));
      exit(2);
  }

  spriteHeight = bitmapInfo.height() / nbVersions;
  spriteWidth = bitmapInfo.width() / frames;

  // Construction de la sequence
  sequenceConstruction();
  setZ(visibility);
  show();
}

void AnimSprite::repaint()
{
    hide(); show();
};

void AnimSprite::setLook(TDir newLook)
{
    if (newLook != look)
    {
//        qDebug("setLook : %d",newLook);
        hide();
        look=newLook;
        sequenceConstruction();
        show();
    }
}

/**
 * updates the sequence of images used by the underlying QCanvasSprite with
 * the ones taken from the image found at imgPath. It is function of the
 * direction of the look and the geometry of the sprite
 */
void AnimSprite::sequenceConstruction()
{
    QValueList<QPixmap> list;

    for (unsigned int i = 0; i<frames;i++)
    {
        QPixmap pm;
//        qDebug("constr s�. : %d %d %d %d % d %d ",spriteWidth,i,spriteHeight,(look-1));
        pm.convertFromImage(bitmapInfo.copy(spriteWidth*i, spriteHeight*(look-1) , spriteWidth, spriteHeight));
        list.push_back(pm);
    }
    setSequence(new QCanvasPixmapArray(list));

    setFrame(0);
}

void AnimSprite::nextFrame()
{
  actFrame++;    //Image suivante
  if (actFrame > (frames-1))
  {
    actFrame=0; //Revenir au d�art
  }
  setFrame(actFrame);
}

void AnimSprite::moveIt()
{
    moveIt(destinationPoint);
}

void AnimSprite::moveIt(const QPoint& destPoint)
{
  uint delta = 5;
  switch (KsirkSettings::spritesSpeed())
  {
    case 0:
      delta = 2;
      break;
    case 1:
      delta = 5;
      break;
    case 2:
      delta = 10;
      break;
    case 3:
      setPosition(destPoint);
      return;
      break;
    default:
      delta = 5;
  }
  if (getApproachDestByLeft())
  {
    setLook(right);
    if (x() < destPoint.x())
    {
      if (destPoint.x() - x() > delta) setX( x() + delta) ;
      if (destPoint.x() - x() <= delta) setX( x() + 1);
    }
    if (x() > destPoint.x())
    {
      if (getMaxX() - x() > delta) setX(x() + delta);
      if (getMaxX() - x() <= delta) setX(destPoint.x()<0?destPoint.x():0);
    }
  }
  else if (getApproachDestByRight())
  {
    setLook(left);
    if (x() < destPoint.x())
    {
      if (x() > delta) setX(x() - delta);
      if (x() <= delta) setX( getMaxX() );
    }
    if (x() > destPoint.x())
    {
      if ( x() - destPoint.x() > delta) setX(x() - delta);
      if ( x() - destPoint.x() <= delta) setX(x() - 1);
    }
  }
  else
  {
    if (x() < destPoint.x())
    {
      setLook(right);
      if (destPoint.x() - x() > delta) setX(x() + delta);
      if (destPoint.x() - x() <= delta) setX( x()+1);
    }
    if (x() > destPoint.x())
    {
      setLook(left);
      if (x() - destPoint.x() > delta) setX(x() - delta);
      if (x() - destPoint.x() <= delta) setX(x()-1);
    }
  }
  if (getApproachDestByTop())
  {
    if (y() < destPoint.y())
    {
      if (destPoint.y() - y() > delta) setY(y() + delta);
      if (destPoint.y() - y() <= delta) setY( y()+1);
    }
    if (y() > destPoint.y())
    {
      if (getMaxY() - y() > delta) setY(y() + delta);
      if (getMaxY() - y() <= delta) setY(destPoint.y()<0?destPoint.y():0);
    }
  }
  else if (getApproachDestByBottom())
  {
    if (y() < destPoint.y())
    {
      if (y() > delta) setY(y() - delta);
      if (y() <= delta) setY( getMaxY() );
    }
    if (y() > destPoint.y())
    {
      if ( y() - destPoint.y() > delta) setY(y() - delta);
      if ( y() - destPoint.y() <= delta) setY(y() - 1);
    }
  }
  else
  {
    if (y() < destPoint.y())
    {
      if (destPoint.y() - y() > delta) setY(y() + delta);
      if (destPoint.y() - y() <= delta) setY(y()+1);
    }
    if (y() > destPoint.y())
    {
      if (y() - destPoint.y() > delta) setY(y() - delta);
      if (y() - destPoint.y() <= delta) setY(y()-1);
    }
  }
  nextFrame();
}

bool AnimSprite::atDestination() const
{
    return  (getPosition() ==  destinationPoint);
}

bool AnimSprite::isLastFrame() const
{
//    qDebug("AnimSprite::isLastFrame actFrame = %d frames = %d", actFrame, frames-1);
    return (actFrame == (frames - 1));
}

void AnimSprite::setPosition(const QPoint &point)
{
    position = point;
    setX(point.x());
    setY(point.y());
}

void AnimSprite::setDestinationPoint(const QPoint &point)
{
    
    destinationPoint = point;
}

const QPoint& AnimSprite::getPosition() const
{
    const_cast< AnimSprite* >(this)-> position = QPoint((int)x(), (int)y());
    return  position;
}

const QPoint& AnimSprite::getDestinationPoint() const
{
    return  destinationPoint;
}

int AnimSprite::operator ==(AnimSprite Arg) const 
{
    return (memcmp(this,&Arg,sizeof(AnimSprite)));
}

void AnimSprite::setDestination(Country::Country *country)
{
    destination = country;
}

Country *AnimSprite::getDestination() 
{
    return destination;
}

/** execute setLook vers left ou right selon les abscisses relatives
du point position actuel et du pointDestination */
void AnimSprite::turnTowardDestination()
{
    if (x() <= destinationPoint.x())
        setLook(right);
    else setLook(left);
}

bool AnimSprite::isAttacker() const
{
    return (isMyState( ATTACKER ));
}

void AnimSprite::setAttacker()
{
    setState ( ATTACKER );
}

bool AnimSprite::isDefendant() const
{
    return (isMyState(DEFENDANT));
}

void AnimSprite::setDefendant()
{
    setState (DEFENDANT);
}

bool AnimSprite::isNone() const
{
    return (isMyState(NONE));
}

void AnimSprite::setNone()
{
    setState (NONE );
}

/** No descriptions */
void AnimSprite::changeSequence(const QString &imgPath, unsigned int newNbFrames, unsigned int nbDirs)
{
//    qDebug("AnimSprite::changeSequence");
  hide();
  frames = newNbFrames;
  actFrame = 0;
  nbVersions = nbDirs;

  KStandardDirs *m_dirs = KGlobal::dirs();

//   kdDebug() << "Sprite file name: " << GameLogic::GameAutomaton::single().skin() + "/Images/sprites/" + imgPath << endl;
  QString imgName = m_dirs-> findResource("appdata", GameLogic::GameAutomaton::single().skin() + "/Images/sprites/" + imgPath);
//   kdDebug() << "imgName= " << imgName << endl;
    
//    QString imgName = m_dirs-> findResource("appdata", "Images/sprites/" + imgPath);
  if (imgName.isNull())
  {
      QMessageBox::critical(0, i18n("Error !"), i18n("Sprite images resource not found\nProgram cannot continue"));
      exit(2);
  }
  if (!bitmapInfo.load(imgName))
  {
      QMessageBox::critical(0, i18n("Error !"), i18n("Cannot load sprite image\nProgram cannot continue"));
      exit(2);
  }

  spriteHeight = bitmapInfo.height() / nbVersions;
  spriteWidth = bitmapInfo.width() / frames;

  sequenceConstruction();
  show();
//    qDebug("OUT AnimSprite::changeSequence");
}

/** turn the sprite towards left */
void AnimSprite::setLookLeft()
{
    setLook(left);
}

/** tourne le sprite vers la droite */
void AnimSprite::setLookRight()
{
    setLook(right);
}
/** No descriptions */
bool AnimSprite::looksToLeft() const
{
    return (look == left);
}
/** No descriptions */
bool AnimSprite::looksToRight() const
{
    return (look == right);
}

/** Read property of bool approachDestByRight. */
bool AnimSprite::getApproachDestByRight() const
{
    return approachDestByRight;
}

/** Write property of bool approachDestByRight. */
void AnimSprite::setApproachDestByRight( const bool& _newVal)
{
//    qDebug("AnimSprite::setApproachDestByRight");
    approachDestByRight = _newVal;
    if (_newVal) setApproachDestByLeft(false);
}

/** Read property of bool approachDestByLeft . */
bool AnimSprite::getApproachDestByLeft () const
{
    return approachDestByLeft ;
}

/** Write property of bool approachDestByLeft . */
void AnimSprite::setApproachDestByLeft ( const bool& _newVal)
{
//    qDebug("AnimSprite::setApproachDestByLeft");
    approachDestByLeft  = _newVal;
    if (_newVal) setApproachDestByRight(false);
}

/** Read property of bool approachDestByTop. */
bool AnimSprite::getApproachDestByTop() const
{
    return approachDestByTop;
}

/** Write property of bool approachDestByTop. */
void AnimSprite::setApproachDestByTop( const bool& _newVal)
{
    approachDestByTop = _newVal;
    if (_newVal) setApproachDestByBottom(false);
}

/** Read property of bool approachDestByBottom . */
bool AnimSprite::getApproachDestByBottom () const
{
    return approachDestByBottom ;
}

/** Write property of bool approachDestByBottom . */
void AnimSprite::setApproachDestByBottom ( const bool& _newVal)
{
    approachDestByBottom  = _newVal;
    if (_newVal) setApproachDestByTop(false);
}

/** Return the maximum value for x for this sprite by looking to its including
  * background. Necessary for directed approaches.
  * Quit with error if there is no background
  */
const int AnimSprite::getMaxX() const
{
    if (backGnd)
        return backGnd-> width();
    else
    {
        QMessageBox::critical(0, I18N_NOOP("Error !"), I18N_NOOP("Cannot find Max X  for sprite: no background !"));
        exit(2);
    }
}

/** Return the maximum value for y for this sprite by looking to its including
  * background. Necessary for directed approaches.
  * Quit with error if there is no background
  */
const int AnimSprite::getMaxY() const
{
    if (backGnd)
        return backGnd-> height();
    else
    {
        QMessageBox::critical(0, I18N_NOOP("Error !"), I18N_NOOP("Cannot find Max Y  for sprite: no background !"));
        exit(2);
    }
}

/**
  * This function chooses the approach mode of a sprite towards its destination:
  * if the distance between the origin and the destination is higher than half
  * the size of the map and if the origin and destination countries comunicate,
  * then the sprite should choose an approach by left or right, through the
  * edge of the map.
  * This protected method will be called by three public functions specialized
  * using as source point, respectivly, the infantryman point, the cavalryman
  * point and the cannon point.
  */
void AnimSprite::setupTravel(Country* src, Country* dest, const QPoint& srcPoint, const QPoint *destPoint)
{
    QString msg;
//    QTextOStream(&msg) << "AnimSprite::setupTravel (" << srcPoint->x() << ") (" << destPoint->x() << ")";
//    kdDebug() << msg << endl;

    setDestination(dest);
    setDestinationPoint(*destPoint);
    setPosition(srcPoint);

/*    QTextOStream(&msg) << "AnimSprite::setupTravel 2"
                    " (" << abs(srcPoint-> x() - destPoint->x()) << ")"
                    " (" << ((backGnd-> width())/2) << ")"
                    << (src-> communicateWith(dest));*/
//    kdDebug() << msg << endl;

    if (!src-> communicateWith(dest))
    {
        kdError() << "Error in AnimSprite::setupTravel: " << src-> name() << "  and " 
                << dest-> name() << " do not communicate!\n";
        exit(2);
    }
    
    if ( (abs(srcPoint.x() - destPoint->x())) > ((backGnd-> width())/2) ) 
    {
        // src is at the right of dest, approch dest by left
        if (srcPoint.x() > destPoint-> x()) setApproachDestByLeft(true);
        // src is at the left of dest, approch dest by right
        if (srcPoint.x() < destPoint-> x()) setApproachDestByRight(true);
    }
    else
    {
        // src is at the right of dest, approch dest by left
        if (srcPoint.x() > destPoint-> x()) setApproachDestByRight(true);
        // src is at the left of dest, approch dest by right
        if (srcPoint.x() < destPoint-> x()) setApproachDestByLeft(true);
    }

    if ( ((abs(srcPoint.y() - destPoint->y())) > ((backGnd-> height())/2)) )
    {
        // src is under the dest, approch dest by top
        if (srcPoint.y() > destPoint-> y()) setApproachDestByTop(true);
        // src is up to the dest, approch dest by botto
        if (srcPoint. y() < destPoint-> y()) setApproachDestByBottom(true);
    }
    else
    {
        // src is under the dest, approch dest by bottom
        if (srcPoint.y() > destPoint-> y()) setApproachDestByBottom(true);
        // src is up to the dest, approch dest by top
        if (srcPoint. y() < destPoint-> y()) setApproachDestByTop(true);
    }
}

void AnimSprite::setupTravel(Country* src, Country* dest, const QPoint* dpi)
{
    if (dpi ==0) setupTravel(src, dest, src->centralPoint(), &(dest-> centralPoint()));
    else setupTravel(src, dest, src->centralPoint(), dpi);
}

/** Return true if the state of the sprite is the argument; false otherwise */
bool AnimSprite::isMyState(State state) const
{
    return myState == state;
}

/**
  * returns the current state of the sprite
  */
AnimSprite::State AnimSprite::getState() const
{
//    kdDebug() << "I'm a sprite; my state is : " << myState << endl;
    return myState;
}

/** sets the new state of the game */
void AnimSprite::setState(AnimSprite::State newState)
{
//    kdDebug() << "Setting sprite's state to : " << newState << " (was : " << myState << ")" << endl;
    myState = newState;
}

void AnimSprite::saveXml(std::ostream& /*xmlStream*/)
{
}


} // closing namespace Ksirk

