/***************************************************************************
                          animspriteslist.h  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2001 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define KDE_NO_COMPAT

#ifndef  ANIMSPRITESLIST_H
#define ANIMSPRITESLIST_H

#include <iostream>

#include <qvaluelist.h>
#include <qpoint.h>

namespace Ksirk
{


/**
 * the AnimSpritesList is a list of AnimSprite-s with useful methods to
 * do some actions on each the elements
 */
 template < typename SpriteType >
class AnimSpritesList : public QValueList< SpriteType* >
{
//    Q_OBJECT
public:
    AnimSpritesList();
    virtual ~AnimSpritesList();

    bool isLastFrame( SpriteType &);

    /**
     * repaint each sprite of the list
     */
    void repaint();

    /**
     * use next frame for each sprite of the list
     */
    void forEachNextFrame();

    /**
     * hide the sprites of the list, remove them from the list  and call their
     * destructors iff the liste is in auto-delete mode
     */
    void hideAndRemoveAll();

    /**
     * return the first AnimSprite of the list that currently displays its last
     * frame
     */
    const SpriteType* firstThatIsLastFrame();

    void setAutoDelete(bool autoDelete);

    void moveAll();

    void moveAllToDestinationNow(bool clear = false);

    void saveXmlAll(std::ostream& xmlStream);
    
 private:
    bool m_autoDelete;
} ;

template < typename SpriteType >
AnimSpritesList< SpriteType >::AnimSpritesList() : QValueList< SpriteType* >(),
        m_autoDelete(true)
{
}

template < typename SpriteType > 
  AnimSpritesList< SpriteType >::~AnimSpritesList< SpriteType >()
{
}

template < typename SpriteType >
void AnimSpritesList< SpriteType >::setAutoDelete(bool autoDelete)
{
    m_autoDelete = autoDelete;
}

template < typename SpriteType >
bool AnimSpritesList< SpriteType >::isLastFrame(SpriteType &sprite)
{
    return sprite.isLastFrame();
}

template < typename SpriteType >
void AnimSpritesList< SpriteType >::repaint()
{
        typename AnimSpritesList< SpriteType >::iterator it;
        typename AnimSpritesList< SpriteType >::iterator it_end = QValueList< SpriteType* >::end();
        for ( it = QValueList< SpriteType* >::begin(); it != it_end; it++ ) (*it)-> hide();        //Supprimer les sprites
        for ( it = QValueList< SpriteType* >::begin(); it != it_end; it++ ) (*it)-> show();    //Redessiner les sprites
}

template < typename SpriteType >
void AnimSpritesList< SpriteType >::forEachNextFrame()
{
        typename AnimSpritesList< SpriteType >::iterator it;
        typename AnimSpritesList< SpriteType >::iterator it_end = QValueList< SpriteType* >::end();
        for ( it = QValueList< SpriteType* >::begin(); it != it_end; it++ ) (*it)-> nextFrame();
}

template < typename SpriteType >
void AnimSpritesList< SpriteType >::hideAndRemoveAll()
{    // cache tous les sprites du tableau, puis les enleve et les
    // detruit si le tableau n'etait pas en auto delete
//    qDebug("AnimSpritesList< SpriteType >::hideAndRemoveAll");

    typename AnimSpritesList< SpriteType >::iterator it= QValueList< SpriteType* >::begin();
    typename AnimSpritesList< SpriteType >::iterator it_end = QValueList< SpriteType* >::end();
    while ( it != it_end )
    {
        SpriteType* sprite = (*it);
        sprite-> hide();
        typename AnimSpritesList< SpriteType >::iterator  toRemove = it;
        it++;
        QValueList< SpriteType* >::remove(toRemove);
        if (!m_autoDelete) 
        {
          delete sprite;
        }
    }
}

template < typename SpriteType >
const SpriteType* AnimSpritesList< SpriteType >::firstThatIsLastFrame()
{
//    qDebug("AnimSpritesList< SpriteType >::firstThatIsLastFrame");
        typename AnimSpritesList< SpriteType >::iterator it;
        typename AnimSpritesList< SpriteType >::iterator it_end = QValueList< SpriteType* >::end();
        for ( it = QValueList< SpriteType* >::begin(); it != it_end; it++ )
        {
            if ((*it)-> isLastFrame()) return (*it);
        }
        return 0;
}

template < typename SpriteType >
void AnimSpritesList< SpriteType >::moveAll()
{
    typename AnimSpritesList< SpriteType >::iterator it, it_end;
    it = QValueList< SpriteType* >::begin();
    it_end = QValueList< SpriteType* >::end();
    while (it != it_end)
    {
        SpriteType* sp = (*it);

        const QPoint& destinationPoint = sp-> getDestination()-> pointFor(sp);

        sp-> moveIt(destinationPoint);
        if (((sp->x()) == (destinationPoint.x())) && ((sp-> y()) == (destinationPoint.y())))
        {
            typename AnimSpritesList< SpriteType >::iterator itToRemove = it;
            sp-> getDestination()-> incrNbArmies((*it)-> nbArmies());
            sp-> hide();
            it++;
            QValueList< SpriteType* >::remove(itToRemove);
            sp-> getDestination()-> createArmiesSprites(sp-> getBackGnd());
        }
        else it++;
    }
}

template < typename SpriteType >
void AnimSpritesList< SpriteType >::moveAllToDestinationNow(bool clear)
{
  typename AnimSpritesList< SpriteType >::iterator it, it_end;
  it = QValueList< SpriteType* >::begin();
  it_end = QValueList< SpriteType* >::end();
  while (it != it_end)
  {
    SpriteType* sp = (*it);

    const QPoint& destinationPoint = sp-> getDestinationPoint();
    sp->setPosition(destinationPoint);

    if (clear)
    {
      typename AnimSpritesList< SpriteType >::iterator itToRemove = it;
      sp-> getDestination()-> incrNbArmies((*it)-> nbArmies());
      sp-> hide();
      it++;
      QValueList< SpriteType* >::remove(itToRemove);
      sp-> getDestination()-> createArmiesSprites(sp-> getBackGnd());
    }
    else
    {
      it++;
    }
  }
}

template < typename SpriteType >
void AnimSpritesList< SpriteType >::saveXmlAll(std::ostream& xmlStream)
{
    typename AnimSpritesList< SpriteType >::iterator it, it_end;
    it = QValueList< SpriteType* >::begin();
    it_end = QValueList< SpriteType* >::end();
    while (it != it_end)
    {
        SpriteType* sp = (*it);
        sp-> saveXml(xmlStream);
        it++;
    }
}

} // closing namespace Ksirk

#endif // ANIMSPRITESLIST_H

