//
// C++ Implementation: armysprite
//
// Description: 
//
//
// Author: Gaël de Chalendar <kleag@free.fr>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "cannonsprite.h"

#include "GameLogic/country.h"

namespace Ksirk {


CannonSprite::CannonSprite(QCanvasPixmapArray* pma, const QString &imgPath,
        BackGnd* aBackGnd, unsigned int nbFrames, unsigned int nbDirs, 
        unsigned int visibility) :
    ArmySprite(pma, imgPath, aBackGnd, nbFrames, nbDirs, visibility)
{
}

void CannonSprite::setupTravel(
  GameLogic::Country* src, 
  GameLogic::Country* dest, 
  const QPoint* dpi)
{
  if (dpi == 0) 
  {
    AnimSprite::setupTravel(src, dest, 
      src->pointCannon(), &(dest-> pointCannon()));
  }
  else 
  {
    AnimSprite::setupTravel(src, dest, src->pointCannon(), dpi);
  }
}

void CannonSprite::setupTravel(GameLogic::Country* src, GameLogic::Country* dest, 
    const QPoint& srcPoint, const QPoint *destPoint)
{
  AnimSprite::setupTravel(src,dest,srcPoint,destPoint);
}

};
