//
// C++ Interface: armysprite
//
// Description: 
//
//
// Author: Gaël de Chalendar <kleag@free.fr>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KSIRKCANNONSPRITE_H
#define KSIRKCANNONSPRITE_H

#include "armysprite.h"

namespace Ksirk {

namespace GameLogic
{
  class Country;
}

/**
  * A CannonSprite is an army sprite that represents ten armies
  * @author Gaël de Chalendar
  */
class CannonSprite : public ArmySprite
{
public:
  CannonSprite(QCanvasPixmapArray* pma, const QString &imgPath, 
      BackGnd* aBackGnd, unsigned int nbFrames, unsigned int nbDirs, 
      unsigned int visibility = 200);

  virtual ~CannonSprite() {}

  inline virtual size_t nbArmies() const {return m_nbArmies;}

  /**
    * Overloads the AnimSprite method. This virtual function chooses the 
    * approach mode of a sprite towards its destination:
    * if the distance between the origin and the destination is higher than half
    * the size of the map and if the origin and destination countries 
    * comunicate, then the sprite should choose an approach by left or right,
    * through the edge of the map.
    * @param src The source country of the journey
    * @param dest The destination country of the journey
    * @param dpi The point where the army should go. 0 if should use the 
    * default (cannon point)
    */
  void setupTravel(GameLogic::Country* src, GameLogic::Country* dest, 
    const QPoint* dpi=0);

  void setupTravel(GameLogic::Country* src, GameLogic::Country* dest, 
    const QPoint& srcPoint, const QPoint *destPoint);

private:
  static const size_t m_nbArmies = 10;
};

}

#endif
