//
// C++ Implementation: armysprite
//
// Description: 
//
//
// Author: Gaël de Chalendar <kleag@free.fr>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "cavalrysprite.h"

#include "GameLogic/country.h"

namespace Ksirk {

CavalrySprite::CavalrySprite(QCanvasPixmapArray* pma, const QString &imgPath,
        BackGnd* aBackGnd, unsigned int nbFrames, unsigned int nbDirs, unsigned int visibility) :
    ArmySprite(pma, imgPath, aBackGnd, nbFrames, nbDirs, visibility)
{
}

/**
  * This function chooses the approach mode of a cavalry sprite towards its
  * destination:
  * if the distance between the origin and the destination is higher than half
  * the size of the map and if the origin and destination countries comunicate,
  * then the sprite should choose an approach by left or right, through the
  * edge of the map.
  */
void CavalrySprite::setupTravel(
    GameLogic::Country* src, 
    GameLogic::Country* dest, 
    const QPoint *dpcav)
{
  if (dpcav==0) 
  {
    setupTravel(src, dest, src->pointCavalry(), &(dest-> pointCavalry()));
  }
  else 
  {
    setupTravel(src, dest, src->pointCavalry(), dpcav);
  }
}

void CavalrySprite::setupTravel(GameLogic::Country* src, GameLogic::Country* dest, 
    const QPoint& srcPoint, const QPoint *destPoint)
{
  AnimSprite::setupTravel(src,dest,srcPoint,destPoint);
}



};
