//
// C++ Interface: CannonSprite
//
// Description: 
//
//
// Author: Gaël de Chalendar <kleag@free.fr>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KSIRKCAVALRYSPRITE_H
#define KSIRKCAVALRYSPRITE_H

#include "armysprite.h"

namespace Ksirk {

namespace GameLogic
{
  class Country;
}

/**
A CavalrySpritei is an army sprite that represents 5 armies

@author Gaël de Chalendar
*/
class CavalrySprite : public ArmySprite
{
public:
    CavalrySprite(QCanvasPixmapArray* pma, const QString &imgPath, BackGnd* aBackGnd,
            unsigned int nbFrames, unsigned int nbDirs, unsigned int visibility = 200);

    virtual ~CavalrySprite() {}

/**
  * This function chooses the approach mode of a cavalry sprite towards its
  * destination:
  * if the distance between the origin and the destination is higher than half
  * the size of the map and if the origin and destination countries comunicate,
  * then the sprite should choose an approach by left or right, through the
  * edge of the map.
  */
  virtual void setupTravel(GameLogic::Country* src, GameLogic::Country* dest, const QPoint* dpcav=0);

  virtual void setupTravel(GameLogic::Country* src, GameLogic::Country* dest, 
    const QPoint& srcPoint, const QPoint *destPoint);

   inline virtual size_t nbArmies() const {return m_nbArmies;}

private:
    static const size_t m_nbArmies = 5;
};

};

#endif
