//
// C++ Interface: CannonSprite
//
// Description: 
//
//
// Author: Gaël de Chalendar <kleag@free.fr>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KSIRKINFANTRYSPRITE_H
#define KSIRKINFANTRYSPRITE_H

#include "armysprite.h"

namespace Ksirk {

namespace GameLogic
{
  class Country;
}

/**
A InfantrySprite is an army sprite that represents 1 army

@author Gaël de Chalendar
*/
class InfantrySprite : public ArmySprite
{
public:
  InfantrySprite(QCanvasPixmapArray* pma, const QString &imgPath, 
    BackGnd* aBackGnd, unsigned int nbFrames, unsigned int nbDirs, 
    unsigned int visibility = 200);

  virtual ~InfantrySprite() {}

  /**
    * This function chooses the approach mode of an infantry sprite towards its
    * destination:
    * if the distance between the origin and the destination is higher than half
    * the size of the map and if the origin and destination countries comunicate,
    * then the sprite should choose an approach by left or right, through the
    * edge of the map.
    */
  void setupTravel(GameLogic::Country* src, GameLogic::Country* dest, 
    const QPoint* dpi=0);

  void setupTravel(GameLogic::Country* src, GameLogic::Country* dest, 
    const QPoint& srcPoint, const QPoint *destPoint);

  inline virtual size_t nbArmies() const {return m_nbArmies;}

private:
  static const size_t m_nbArmies = 1;
};

};

#endif
