//
// C++ Interface: SkinSpritesData
//
// Description:
//
//
// Author: Gaël de Chalendar <kleag@free.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KSIRK_SPRITES_SKINSPRITESDATA_H
#define KSIRK_SPRITES_SKINSPRITESDATA_H

#include <qpoint.h>
#include <qstring.h>
#include <qstringlist.h>
#include <map>

namespace Ksirk {
namespace Sprites {

/**
 * @todo This class is currently a singleton. That poses problems as the values 
 * are in fact dependent on the currently used skin. This should be changed to 
 * a standard class and attached the ONU objects
 * @author Gaël de Chalendar
 */
class SkinSpritesData
{
public:

    void init();
    
    static const SkinSpritesData& single();

    static SkinSpritesData& changeable();

    const QString& skin() const;
    
    void skin(const QString& newSkin);
    
    int intData(const QString& name) const;
    const QString& strData(const QString& name) const;
        
    void strData(const QString& name, const QString& data);
    void intData(const QString& name, int data);
        
private:
    SkinSpritesData();
    
  SkinSpritesData(const SkinSpritesData& /*ga*/) {};

    virtual ~SkinSpritesData();

    static SkinSpritesData* m_singleton ;
    
    QString m_skin;
    
    std::map<QString, int> m_intDatas;
    std::map<QString, QString> m_strDatas;
};

}; // closing namespace Sprites
}; // closing namespace Ksirk

#endif // KSIRK_SPRITES_SKINSPRITESDATA_H
