/***************************************************************************
                          backgnd.cpp  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2001-2006 by Gaël de Chalendar (aka Kleag)
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#define KDE_NO_COMPAT
#include "backgnd.h"
#include "GameLogic/onu.h"

#include <qcanvas.h>

#include <kdebug.h>

namespace Ksirk
{

using namespace GameLogic;

int BackGnd::DefaultScrollStep = 16;

BackGnd::BackGnd(QCanvas *canvas, DecoratedGameFrame* aFrame, const GameLogic::ONU* theWorld) :
    QCanvasSprite(new QCanvasPixmapArray, canvas), m_frame(aFrame)
{
  kdDebug() << "BackGnd constructor" << endl;
  QValueList<QPixmap> list;
  list.push_back(theWorld->map());
  QCanvasPixmapArray *maSequence = new QCanvasPixmapArray(list);
  setSequence(maSequence);
  setZ(1);
  show();
};

BackGnd::~BackGnd()
{
    m_frame = 0;
};


void BackGnd::scroll(TDir dir, int step)
{
    switch (dir)
    {
        case left :
            m_frame-> scrollBy(step, 0);
        break;
        case right:
            m_frame-> scrollBy(-step, 0);
        break;
        case up     :
            m_frame-> scrollBy(0, step);
        break;
        case down :
            m_frame-> scrollBy(0, -step);
        break;
        default:
            kdError() << "Non supported scroll direction." << endl;
    }
};

void BackGnd::scrollUp(const int step)
{
    scroll(up, step);
}

void BackGnd::scrollDown(const int step)
{
    scroll(down, step);
}

void BackGnd::scrollLeft(const int step)
{
    scroll(left, step);
}

void BackGnd::scrollRight(const int step)
{
    scroll(right, step);
}

}
