/***************************************************************************
                          backgnd.h  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2001-2006 by Gaël de Chalendar (aka Kleag)
    email                : kleag@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define KDE_NO_COMPAT

#ifndef BACKGND_H
#define BACKGND_H

#include "decoratedgameframe.h"

namespace Ksirk
{
namespace GameLogic
{
  class ONU;
}
class DecoratedGameFrame;

/**
 * BackGnd is the sprite used to display the background map image
 * Using a sprite allow to move it quickly on the fixed canvas.
 *
 * The background can be scrolled in the four directions with specialized
 * methods
 */
class BackGnd : public QCanvasSprite
{
public:
    /**
     * The QCanvas is the canvas where all the sprites are set up.
     * aFrame is the view used to display the background.
     */
  BackGnd(QCanvas *canvas, DecoratedGameFrame *aFrame, const GameLogic::ONU* theWorld);
    ~BackGnd();
    
    /**
     * These four scroll methods allow to easilly scroll the background on its
     * canvas in a simple and transparent manner
     */
    void scrollUp(const int step = DefaultScrollStep);
    void scrollDown(const int step = DefaultScrollStep);
    void scrollLeft(const int step = DefaultScrollStep);
    void scrollRight(const int step = DefaultScrollStep);

private:
    enum TDir {state, right, left, up, down, N, S, E, O, NO, SO, SE, NE};
    
    /**
     * This static member allow to simplify the call to scroll functions
     */
    static int DefaultScrollStep;

    /**
     * The frame is the view on which the background and the animated sprites
     * are painted.
     */
    DecoratedGameFrame *m_frame;

    /**
     * The scroll method is used by the scrollX public methods to call the
     * native scrollBy methods in the good direction. Its arguments are a
     * named direction and a number of pixels step
     */
    void scroll(TDir dir, int step);
};
}
#endif //  BACKGND_H

