/***************************************************************************
                          decoratedgameframe.cpp  -  description
                             -------------------
    begin                : Thu Jul 19 2001
    copyright            : (C) 2001 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define KDE_NO_COMPAT
#include <qmessagebox.h>
#include <qcursor.h>
#include <qsize.h>

#include <klocale.h>
#include <kdebug.h>
#include <kgame/kgameio.h>
#include <kgame/kplayer.h>

#include "decoratedgameframe.h"
#include "GameLogic/player.h"

namespace Ksirk
{
using namespace GameLogic;

DecoratedGameFrame::DecoratedGameFrame(QWidget* parent, const char  *nom, unsigned int mapW, unsigned int mapH)
    : QCanvasView(parent,nom), m_mapW(mapW), m_mapH(mapH)
{
	setHScrollBarMode(AlwaysOff);
	setVScrollBarMode(AlwaysOff);
	timer = new QTimer(this);
    connect( timer, SIGNAL(timeout()), parent, SLOT(slotTimerEvent()) );
    setMinimumSize(200,100);
	setMaximumSize(mapW,mapH);
	updateGeometry(); 
}

DecoratedGameFrame::~DecoratedGameFrame()
{
    if (timer)
    {
        haltTimer();
        delete timer;
    }
}

/**
 * Start the timer. Quit if error
 */
void DecoratedGameFrame::initTimer()
{
//   kdDebug() << "DecoratedGameFrame::initTimer" << endl;

  if (!timer->isActive())
  {
    if (! (timer-> start(200)))
    {
      QMessageBox::critical(0,
      i18n("Error !"),
      i18n("Cannot allocate timer\nCannot continue program"));
      exit(2);
    }
  }
  //  kdDebug() << "DecoratedGameFrame::initTimer finished" << endl;
}

/**
 * Halt the timer. Quit if error
 */
void DecoratedGameFrame::haltTimer()
{
//   kdDebug() << "DecoratedGameFrame::haltTimer" << endl;

    if (timer) {timer-> stop();}
    else
    {
        QMessageBox::critical(0, i18n("Error !"),
            i18n("Timer removing impossible.\nCannot continue !"));
        exit(2);
    }
}


QSize DecoratedGameFrame::sizeHint() const
{
  return QSize(m_mapW, m_mapH);
}

// void DecoratedGameFrame::contentsMousePressEvent ( QMouseEvent * e)
// {
//     QPoint newPoint = mapFromGlobal(QCursor::pos()) + QPoint(contentsX(), contentsY());
//     if (e->button() == LeftButton)
//         emit slotLeftButtonDown(newPoint);
//     else emit slotRightButtonDown(newPoint);
// }
// 
// void DecoratedGameFrame::contentsMouseReleaseEvent ( QMouseEvent * e)
// {
//     QPoint newPoint = mapFromGlobal(QCursor::pos()) + QPoint(contentsX(), contentsY());
//     if (e->button() == LeftButton)
//         emit slotLeftButtonUp(newPoint);
// }

/**
 * This slot is called when a mouse key is pressed. As the mouse is used as
 * input for all players
 * this slot is called to generate a player move out of a mouse input, i.e.
 * it converts a QMouseEvent into a move for the game. We do here some
 * simple nonsense and use the position of the mouse to generate
 * moves containing the keycodes
 */
void DecoratedGameFrame::slotMouseInput(KGameIO *input,QDataStream &stream,QMouseEvent *e,bool *eatevent)
{
  kdDebug() << "DecoratedGameFrame::slotMouseInput()" << endl;
  
  KPlayer *player=input->player();
  if (!player->myTurn())
  {
    kdDebug() << "Player " << dynamic_cast<Player*>(player)->name() << ": not my turn!" << endl;
    *eatevent=false;
    return;
  }
  
  if (e->type() == QEvent::MouseButtonPress)
  {
    kdDebug() << "\tQEvent::MouseButtonPress" << endl;
    if (e->button() == LeftButton)
    {
      kdDebug() << "\tLeft" << endl;
      stream << QString("actionLButtonDown");
    }
    else if (e->button() == RightButton)
    {
      kdDebug() << "\tRight" << endl;
      stream << QString("actionRButtonDown");
    }
    else
    {
      *eatevent=false;
      return;
    }
  }
  else if (e->type() == QEvent::MouseButtonRelease)
  {
    kdDebug() << "\tQEvent::MouseButtonRelease" << endl;
    if (e->button() == LeftButton)
    {
      kdDebug() << "\tLeft" << endl;
      stream << QString("actionLButtonUp");
    }
    else if (e->button() == RightButton)
    {
      kdDebug() << "\tRight" << endl;
      stream << QString("actionRButtonUp");
    }
    else
    {
      *eatevent=false;
      return;
    }
  }
  else
  {
    *eatevent=false;
    return;
  }
  QPoint newPoint = mapFromGlobal(QCursor::pos()) + QPoint(contentsX(), contentsY());
  stream << newPoint;
  *eatevent=true;
  kdDebug() << "Mouse input done... eatevent=true" << endl;
}

}

#include "decoratedgameframe.moc"
