/***************************************************************************
                          decoratedgameframe.h  -  description
                             -------------------
    begin                : Thu Jul 19 2001
    copyright            : (C) 2001 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define KDE_NO_COMPAT

#ifndef  DECORATEDGAMEFRAME_H
#define DECORATEDGAMEFRAME_H

#include "global.h"

#include <stdlib.h>
#include <qcanvas.h>
#include <qtimer.h>

class KGameIO;

namespace Ksirk
{


/**
 * The DecoratedGameFrame class is the central widget of the application where
 * all the sprites are displayed. It is linked to its parent widget (the main window)
 * and to its logical model, the graphics pool which is a QCanvas
 */
class DecoratedGameFrame: public QCanvasView
{
    Q_OBJECT
public:
    /**
     * Creates the frame, its timer and set some parameters
     */
    DecoratedGameFrame(QWidget* parent, const char *nom, unsigned int mapW, unsigned int mapH);

    /**
     * Destroy the frame : stops and deletes the timer
     */
    virtual ~DecoratedGameFrame();

    /**
     * Start the timer. Quit if error
     */
    void initTimer();

    /**
     * Halt the timer. Quit if error
     */
    void haltTimer();

    QSize sizeHint () const;

public slots:
  /** Slot connected in the game/document object to catch and
    * process mouse events. This is a KGame function which
    * ends up generating the move for the game.
    * @param input is the KGameIO input object
    * @param stream is the output command stream
    * @param mouse is a mouse event
    * @param eatevent is to be set to true if you processed the event
    *
    */
  void slotMouseInput(KGameIO *input,QDataStream &stream,QMouseEvent *mouse,bool *eatevent);
  
signals:

  /**
    * These signals are connected to slots of the window. They are emitted
    * for the mouse buttons events with corrected coordinates
    */
/*  void signalLeftButtonDown(const QPoint &);
  void signalLeftButtonUp(const QPoint &);
  void signalRightButtonDown(const QPoint &);
  void signalRightButtonUp(const QPoint &);*/
  
protected:

    /**
     * The timer that will cause the updates of the display and so allow for
     * movements
     */
    QTimer *timer;

    /**
     * These methods override the inherited ones by converting the coordinates
     * from screen ones to game ones. After this conversion, they emit the
     * adequate signal
     */
//     virtual void contentsMousePressEvent ( QMouseEvent * );
//     virtual void contentsMouseReleaseEvent ( QMouseEvent * );

private:
    unsigned int m_mapW;
    unsigned int m_mapH;
};

}

#endif // DECORATEDGAMEFRAME_H

