/***************************************************************************
                          gestionSprites.cpp  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * KGameWindow methods for sprites handling function of the state
 */

// include files for QT
#include <qmetaobject.h>
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qsound.h>
#include <qinputdialog.h>
#include <qtextstream.h>
#include <qglobal.h> // pour pouvoir utiliser qDebug()

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kaboutapplication.h>
#include <kaudioplayer.h>
#include <kstandarddirs.h>
#include <kdebug.h>

// application specific includes
#include "kgamewin.h"
#include "backgnd.h"
#include "ksirksettings.h"
#include "Sprites/cannonsprite.h"
#include "Sprites/cavalrysprite.h"
#include "Sprites/infantrysprite.h"
#include "Sprites/skinSpritesData.h"
#include "GameLogic/kstringvector.h"

namespace Ksirk
{
using namespace GameLogic;

/**
 * Prepares the sprites to be moved : removes the nb necessary sprites from
 * source, creates the moving sprites and gives them their destination, etc
 */
bool KGameWindow::initArmiesMovement(unsigned int nbABouger, Country *m_firstCountry, Country *m_secondCountry)
{
//   kdDebug() << "KGameWindow::initArmiesMovement -> " << nbABouger  << endl;
  KStringVector messageParts;

  if (m_firstCountry-> nbArmies() <= nbABouger)
  {
    messageParts << I18N_NOOP("Cannot move %1 armies from %2 to %3") << QString::number(nbABouger)
      << m_firstCountry->name() << m_secondCountry->name();
    broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
    return false;
  }
  else
  {
    messageParts << I18N_NOOP("Moving %1 armies from %2 to %3") << QString::number(nbABouger) << m_firstCountry->name() << m_secondCountry->name();
    broadcastChangeItem(messageParts, ID_STATUS_MSG2);
  }
  
  QCanvasPixmapArray pma;
  if ((m_firstCountry-> nbArmies() > 10) && (nbABouger == 10)
          && (nbABouger < m_firstCountry-> nbArmies()))
  {
      CannonSprite* sprite = new CannonSprite(&pma, Sprites::SkinSpritesData::single().strData("cannon-file"), m_backGnd, Sprites::SkinSpritesData::single().intData("cannon-frames"), Sprites::SkinSpritesData::single().intData("cannon-versions"), 200);
      sprite-> setupTravel(m_firstCountry, m_secondCountry);
      m_movingCannons.push_back(sprite);
      m_firstCountry-> decrNbArmies(10);
      (m_firstCountry->pointFlag().x() < m_secondCountry-> pointFlag().x()) ? sprite-> setLookRight() : sprite-> setLookLeft();
  }
  else if ((m_firstCountry-> nbArmies() > 5) && (nbABouger == 5)
          && (nbABouger < m_firstCountry-> nbArmies()))
  {
      CavalrySprite* sprite = new CavalrySprite(&pma, Sprites::SkinSpritesData::single().strData("cavalry-file"), m_backGnd, 
          Sprites::SkinSpritesData::single().intData("cavalry-frames"), 
          Sprites::SkinSpritesData::single().intData("cavalry-versions"), 200);
      sprite-> setupTravel(m_firstCountry, m_secondCountry);
      m_movingCavalrymen.push_back(sprite);
      m_firstCountry-> decrNbArmies(5);
      (m_firstCountry->pointFlag().x() < m_secondCountry-> pointFlag().x()) ? sprite-> setLookRight() : sprite-> setLookLeft();
  }
  else if ((m_firstCountry-> nbArmies() > 1) && (nbABouger == 1)
          && (nbABouger < m_firstCountry-> nbArmies()))
  {
      InfantrySprite* sprite = new InfantrySprite(&pma, Sprites::SkinSpritesData::single().strData("infantry-file"), m_backGnd, 
          Sprites::SkinSpritesData::single().intData("infantry-frames"), 
          Sprites::SkinSpritesData::single().intData("infantry-versions"), 200);
      sprite-> setupTravel(m_firstCountry, m_secondCountry);
      m_movingInfantrymen.push_back(sprite);
      m_firstCountry->  decrNbArmies();
      (m_firstCountry->pointFlag().x() < m_secondCountry-> pointFlag().x()) ? sprite-> setLookRight() : sprite-> setLookLeft();
  }
  else 
  {
    messageParts << I18N_NOOP("Cannot move %1 armies from %2 to %3") 
      << QString::number(nbABouger) 
      << m_firstCountry->name() 
      << m_secondCountry->name();
    broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
    return false;
  }
  m_firstCountry-> createArmiesSprites(this-> m_backGnd);
//   kdDebug() << "initArmiesMovement returns true" << endl;
  return true;
}

void KGameWindow::moveCannons()
{
//    qDebug("KGameWindow::moveCannons");
    QString sndRoulePath;

    sndRoulePath = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Sounds/roule.wav");
    if (sndRoulePath.isNull())
    {
        QMessageBox::critical(0, i18n("Error !"), i18n("Sound roule not found - Verify your installation\nProgram cannot continue"));
        exit(2);
    }
//    KAudioPlayer::play(sndRoulePath);

        m_movingCannons.moveAll();
}

void KGameWindow::moveCavalrymen()
{
  m_movingCavalrymen.moveAll();
}

void KGameWindow::moveInfantrymen()
{
  m_movingInfantrymen.moveAll();
}

void KGameWindow::initCombatMovement(Country *paysAttaquant, Country *paysDefenseur)
{
//   kdDebug() << "KGameWindow::initCombatMovement" << endl;

  toolBar("gameActionsToolBar")-> hide();
  
  // cleaning of possibly non empty lists (should be empty)
  m_movingFighters.clear();
  m_animFighters.clear();
  m_animExplodings.clear();
  m_fighters.clear();
  
  // On doit connaitre
  //  - point de d�art de l'attaquant (pointCanonn)
  int pointDepartAttaquantX = paysAttaquant-> pointCannon().x();
  //  - point de d�art du d�enseur (pointCannon)
  int pointDepartDefenseurX = paysDefenseur-> pointCannon().x();
  
  //  - point drapeau de l'attaquant
  int pointFlagAttaquantX = paysAttaquant-> pointFlag().x();
  //  - point drapeau du defenseur
  int pointFlagDefenseurX = paysDefenseur-> pointFlag().x();
  
  //  - point d'arriv� de l'attaquant (resp. du defenseur) (gauche ou droite de point drapeau d�enseur
  //    selon position point drapeau attaquant)
  int pointArriveeAttaquantX;
  int pointArriveeAttaquantY;
  int pointArriveeDefenseurX;
  int pointArriveeDefenseurY;
  
  pointArriveeAttaquantY = pointArriveeDefenseurY = (paysDefenseur-> pointFlag().y() + Sprites::SkinSpritesData::single().intData("fighters-flag-y-diff"));
  
  if (!paysAttaquant->communicateWith(paysDefenseur))
  {
      kdError() << "Error in KGameWindow::initCombatMovement: " << paysAttaquant-> name() << "  and "
              << paysDefenseur-> name() << " do not communicate!" << endl;
      exit(2);
  }
  // If the flag of the attacker is to the left of the flag of the defender,
  // then the arriving point of the attacker is to the left, else it is to
  // the right
  // The situation is reversed if the one of the attacker will need to go
  // through the world limit

  int leftRelativePos = - (Sprites::SkinSpritesData::single().intData("width-between-flag-and-fighter") + Sprites::SkinSpritesData::single().intData("cannon-width"));
  int rightRelativePos = Sprites::SkinSpritesData::single().intData("width-between-flag-and-fighter") + Sprites::SkinSpritesData::single().intData("flag-width");
  if (!((abs(pointFlagAttaquantX-pointFlagDefenseurX) > (m_backGnd-> width() / 2))))
  {
      if ( pointFlagAttaquantX <= pointFlagDefenseurX )
      {
          pointArriveeAttaquantX = pointFlagDefenseurX + leftRelativePos;
          pointArriveeDefenseurX = pointFlagDefenseurX + rightRelativePos;
      }
      else
      {
          pointArriveeAttaquantX = pointFlagDefenseurX + rightRelativePos;
          pointArriveeDefenseurX = pointFlagDefenseurX + leftRelativePos;
      }
  }
  else
  {
      if ( pointFlagAttaquantX <= pointFlagDefenseurX )
      {
          pointArriveeAttaquantX = pointFlagDefenseurX + rightRelativePos;
          pointArriveeDefenseurX = pointFlagDefenseurX + leftRelativePos;
      }
      else
      {
          pointArriveeAttaquantX = pointFlagDefenseurX +leftRelativePos;
          pointArriveeDefenseurX = pointFlagDefenseurX + rightRelativePos;
      }
  }
  QPoint *pointArriveeAttaquant = new QPoint(pointArriveeAttaquantX,pointArriveeAttaquantY);
  QPoint *pointArriveeDefenseur = new QPoint(pointArriveeDefenseurX,pointArriveeDefenseurY);
  
  QCanvasPixmapArray pma;
  CannonSprite* spriteAttaquant = new CannonSprite(&pma, Sprites::SkinSpritesData::single().strData("cannon-file"), m_backGnd, Sprites::SkinSpritesData::single().intData("cannon-frames"), Sprites::SkinSpritesData::single().intData("cannon-versions"), 200);
  spriteAttaquant-> setAttacker();
  spriteAttaquant->setupTravel(paysAttaquant, paysDefenseur, pointArriveeAttaquant);
  (pointDepartAttaquantX <= pointArriveeAttaquantX) ? spriteAttaquant-> setLookRight() : spriteAttaquant-> setLookLeft();
  m_movingFighters.push_back(spriteAttaquant);
  QString sndRoulePath = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Sounds/roule.wav");
  if (sndRoulePath.isNull())
  {
      QMessageBox::critical(0, i18n("Error !"), i18n("Sound roule not found - Verify your installation\nProgram cannot continue"));
      exit(2);
  }
  //KAudioPlayer::play(sndRoulePath);
  
  CannonSprite* spriteDefenseur = new CannonSprite(&pma, Sprites::SkinSpritesData::single().strData("cannon-file"), m_backGnd, Sprites::SkinSpritesData::single().intData("cannon-frames"), Sprites::SkinSpritesData::single().intData("cannon-versions"), 200);
  spriteDefenseur-> setDefendant();
  spriteDefenseur-> setupTravel(paysDefenseur, paysDefenseur, pointArriveeDefenseur);
  (pointDepartDefenseurX <= pointArriveeDefenseurX) ? spriteDefenseur-> setLookRight() : spriteDefenseur-> setLookLeft();
  m_movingFighters.push_back(spriteDefenseur);
  sndRoulePath = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Sounds/roule.wav");
  if (sndRoulePath.isNull())
  {
      QMessageBox::critical(0, i18n("Error !"), i18n("Sound roule not found - Verify your installation\nProgram cannot continue"));
      exit(2);
  }
  //KAudioPlayer::play(sndRoulePath);
}

void KGameWindow::moveMovingCombatants()
{
//   kdDebug() << "KGameWindow::moveMovingCombatants" << endl;

  AnimSpritesList< CannonSprite >::iterator it, it_end;
  it = m_movingFighters.begin();
  it_end = m_movingFighters.end();
  while (it != it_end)
  {
    CannonSprite* combatant = (*it);
    combatant-> moveIt();
    if (combatant->atDestination())
      combatantArrival(it);
    else
      it++;
  }
}

void KGameWindow::combatantArrival(AnimSpritesList< CannonSprite >::iterator& combatantIt)
{
//   kdDebug()<< "KGameWindow::combatantArrival" << endl;
  AnimSpritesList< CannonSprite >::iterator combatantItNext;
  combatantItNext = m_movingFighters.remove(combatantIt);
  CannonSprite* combatant = (*combatantIt);
  m_fighters.push_back(combatant);
  if (combatant-> x() < combatant-> getDestination()-> pointFlag().x())
        combatant-> setLookRight();
  else combatant-> setLookLeft();
  combatant-> repaint();
  combatantIt = combatantItNext;
}

void KGameWindow::animCombat()
{
//   kdDebug()<<"KGameWindow::animCombat"<< endl;
  m_frame-> haltTimer();
  m_animFighters. hideAndRemoveAll();

  AnimSpritesList< CannonSprite >::iterator it = m_fighters.begin();
  AnimSpritesList< CannonSprite >::iterator it_end = m_fighters.end();
  while (it != it_end)
  {
    CannonSprite* sprite = (*it);
    it = m_fighters.remove(it);
    sprite-> changeSequence(
        Sprites::SkinSpritesData::single().strData("firing-file"),
        Sprites::SkinSpritesData::single().intData("firing-frames"), 
        Sprites::SkinSpritesData::single().intData("firing-versions"));
    int firingRelativePos = Sprites::SkinSpritesData::single().intData("cannon-width") - Sprites::SkinSpritesData::single().intData("firing-width");
    if (sprite-> looksToLeft()) 
    {
      sprite-> setX(sprite-> x() + firingRelativePos);
      // @todo the Y change shoud not be necessary. Could not find the bug...
      sprite-> setY(sprite-> y() - Sprites::SkinSpritesData::single().intData("fighters-flag-y-diff"));
    }
    m_animFighters.push_back(sprite);
  }
  QString sndCanonPath = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Sounds/canon.wav");
  if (sndCanonPath.isNull())
  {
    QMessageBox::critical(0, i18n("Error !"),
        i18n("Sound canon not found - Verify your installation\nProgram cannot continue"));
    exit(2);
  }
  if (KsirkSettings::soundEnabled())
  {
    KAudioPlayer::play(sndCanonPath);
  }
  m_frame-> initTimer();
}

void KGameWindow::stopCombat()
{
//   kdDebug()<<"KGameWindow::stopCombat"<< endl;
  // va utiliser m_fighters pour stocker les images de canon simples, apres le tir.
  // devrait deja etre vide, mais bon, au cas ou
  m_fighters.hideAndRemoveAll();
  AnimSpritesList< CannonSprite >::iterator it = m_animFighters.begin();
  AnimSpritesList< CannonSprite >::iterator it_end = m_animFighters.end();
  while (it != it_end)
  {
    CannonSprite* sprite = (*it);
    it = m_animFighters.remove(it);
    sprite-> changeSequence(
        Sprites::SkinSpritesData::single().strData("cannon-file"),
        Sprites::SkinSpritesData::single().intData("cannon-frames"), 
        Sprites::SkinSpritesData::single().intData("cannon-versions"));
    if (sprite-> looksToLeft()) 
    {
      sprite-> setX(sprite->x() + Sprites::SkinSpritesData::single().intData("cannon-width"));
      sprite-> setY(sprite-> y() + Sprites::SkinSpritesData::single().intData("fighters-flag-y-diff"));
    }
    else 
    {
      sprite-> setX(sprite-> x());
    }
    m_fighters.push_back(sprite);
  }
}

void KGameWindow::animExplosion(int who)
{
//   kdDebug() << "KGameWindow::animExplosion" <<  who << endl;

  m_frame-> haltTimer();
  // va utiliser m_animExplodings pour stocker les images de canon en train d'exploser
  m_animExplodings.hideAndRemoveAll();

  AnimSpritesList< CannonSprite >::iterator it = m_fighters.begin();
  AnimSpritesList< CannonSprite >::iterator it_end = m_fighters.end();
  while (it != it_end)
  {
      CannonSprite* sprite = (*it);
      if ( (who == 2) // les 2 tues
          || ((who == 0) && (sprite-> isAttacker()))  // Attaquant tu
          || ((who == 1) && (sprite-> isDefendant())) ) // Defenseur tu
      {
          it = m_fighters.remove(it); // enleve l'element courant. On se retrouve sur le suivant
          sprite-> changeSequence(
              Sprites::SkinSpritesData::single().strData("exploding-file"),
              Sprites::SkinSpritesData::single().intData("exploding-frames"), 
              Sprites::SkinSpritesData::single().intData("exploding-versions"));
          
          m_animExplodings.push_back(sprite);
      }
      else  // le sprite n'est pa le (ou un des 2) tue(s)
      {
          sprite-> changeSequence(
      Sprites::SkinSpritesData::single().strData("cannon-file"),
      Sprites::SkinSpritesData::single().intData("cannon-frames"), 
      Sprites::SkinSpritesData::single().intData("cannon-versions"));
          it++; //on passe au sprite suivant
      }
  }
  QString sndCrashPath = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Sounds/crash.wav");
  if (sndCrashPath.isNull())
  {
    KMessageBox::information(this, i18n("Sound crash not found - Verify your installation\nProgram cannot continue"), i18n("KsirK - Error !"));
    exit(2);
  }
  if (KsirkSettings::soundEnabled())
  {
    KAudioPlayer::play(sndCrashPath);
  }
  m_frame-> initTimer();
//    qDebug("OUT KGameWindow::animExplosion");
}

void KGameWindow::stopExplosion()
{
//     kdDebug()<<"KGameWindow::stopExplosion"<<endl;
    m_fighters.hideAndRemoveAll();
    m_animExplodings.hideAndRemoveAll();
}

void KGameWindow::initCombatBringBack(Country *paysAttaquant, Country *paysDefenseur)
{
//     kdDebug()<<"KGameWindow::initCombatBringBack"<<endl;
    int who = 0;
    if ((NKD != 0)&&(NKA != 0)) who = 2;
    else if (NKA != 0) who = 0;
    else if (NKD != 0) who = 1;
    else QMessageBox::warning(0, i18n("Problem : no one destroyed"), "", 0);
    
    CannonSprite *newSprite;

    m_movingFighters.hideAndRemoveAll();
    QCanvasPixmapArray pma;
    int flagYDiff = Sprites::SkinSpritesData::single().intData("fighters-flag-y-diff");
    int leftRelativePos = - (Sprites::SkinSpritesData::single().intData("width-between-flag-and-fighter") + Sprites::SkinSpritesData::single().intData("cannon-width"));
    int rightRelativePos = Sprites::SkinSpritesData::single().intData("width-between-flag-and-fighter") + Sprites::SkinSpritesData::single().intData("flag-width");
    if (who == 0) //Attaquant d�ruit, ram�e d�enseur
    {
        newSprite = new CannonSprite(&pma, Sprites::SkinSpritesData::single().strData("cannon-file"), m_backGnd, Sprites::SkinSpritesData::single().intData("cannon-frames"), Sprites::SkinSpritesData::single().intData("cannon-versions"), 200);
        if ((paysAttaquant-> pointFlag().x() <= paysDefenseur-> pointFlag().x())
        && !(
        (abs(paysAttaquant-> pointFlag().x()-paysDefenseur-> pointFlag().x()) > (m_backGnd-> width() / 2))
            && (paysAttaquant->communicateWith(paysDefenseur))
        ))
        {
            newSprite-> setPosition(  (paysDefenseur-> pointFlag())+QPoint(rightRelativePos, flagYDiff));
        }
        else
        {
            newSprite-> setPosition(  (paysDefenseur-> pointFlag())+QPoint(leftRelativePos, flagYDiff));
        }
        newSprite-> setupTravel(paysDefenseur, paysDefenseur, newSprite-> getPosition(), &(paysDefenseur-> pointCannon()));
        newSprite-> turnTowardDestination();
        m_movingFighters.push_back(newSprite);
        QString sndRoulePath = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Sounds/roule.wav");
        if (sndRoulePath.isNull())
        {
            QMessageBox::critical(0, i18n("Error !"), i18n("Sound roule not found - Verify your installation\nProgram cannot continue"));
            exit(2);
        }
//            KAudioPlayer::play(sndRoulePath);
    }
    else if (who == 1) //D�enseur d�ruit, ram�e Attaquant
    {
        newSprite = new CannonSprite(&pma, Sprites::SkinSpritesData::single().strData("cannon-file"), m_backGnd, Sprites::SkinSpritesData::single().intData("cannon-frames"), Sprites::SkinSpritesData::single().intData("cannon-versions"), 200);
        if ((paysAttaquant-> pointFlag().x() <= paysDefenseur-> pointFlag().x())
        && !(
        (abs(paysAttaquant-> pointFlag().x()-paysDefenseur-> pointFlag().x()) > (m_backGnd-> width() / 2))
            && (paysAttaquant->communicateWith(paysDefenseur))
        ))
        {
            newSprite-> setPosition( (paysDefenseur-> pointFlag())+QPoint(leftRelativePos,flagYDiff));
        }
        else
        {
            newSprite-> setPosition( (paysDefenseur-> pointFlag())+QPoint(rightRelativePos,flagYDiff));
        }
        newSprite-> setupTravel(paysDefenseur, paysAttaquant, newSprite-> getPosition(), &(paysAttaquant-> pointCannon()));
        newSprite-> turnTowardDestination();
        m_movingFighters.push_back(newSprite);
        QString sndRoulePath = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Sounds/roule.wav");
        if (sndRoulePath.isNull())
        {
            QMessageBox::critical(0, i18n("Error !"), i18n("Sound roule not found - Verify your installation\nProgram cannot continue"));
            exit(2);
        }
//            KAudioPlayer::play(sndRoulePath);
    }
    else if (who == 2) 
    {
    } //Attaquant ET D�enseur d�ruits
    else  // error
    {
      QMessageBox::critical(0, i18n("Error !"), i18n("who should be 0, 1 or 2."));
      exit(1);
    }
}

/**
  * Disconnects the mouse events signals from their slots to avoid human
  * player actions when it is the turn of the AI
  */
void KGameWindow::disconnectMouse()
{
/*  if ( ! disconnect(m_frame, SIGNAL(signalLeftButtonDown(const QPoint &)),
                    this, SLOT(slotLeftButtonDown(const QPoint&))))
    kdError() << "cannot connect slotLeftButtonDown !" << endl;
  if ( ! disconnect(m_frame, SIGNAL(signalLeftButtonUp(const QPoint &)),
                    this, SLOT(slotLeftButtonUp(const QPoint &))))
    kdError() << "cannot connect slotLeftButtonUp !" << endl;
  if ( ! disconnect(m_frame, SIGNAL(signalRightButtonDown(const QPoint &)),
                    this, SLOT(slotRightButtonDown(const QPoint &))))
    kdError() << "cannot connect slotRightButtonDown !" << endl;*/
}

/**
  * Reconnect the mouse events signals to their slots to allow human players to
  * play
  */
void KGameWindow::reconnectMouse()
{
/*  if ( ! connect(m_frame, SIGNAL(signalLeftButtonDown(const QPoint &)),
                    this, SLOT(slotLeftButtonDown(const QPoint&))))
  kdError() << "cannot connect slotLeftButtonDown !" << endl;
  if ( ! connect(m_frame, SIGNAL(signalLeftButtonUp(const QPoint &)),
                    this, SLOT(slotLeftButtonUp(const QPoint &))))
  kdError() << "cannot connect slotLeftButtonUp !" << endl;
  if ( ! connect(m_frame, SIGNAL(signalRightButtonDown(const QPoint &)),
                    this, SLOT(slotRightButtonDown(const QPoint &))))
  kdError() << "cannot connect slotRightButtonDown !" << endl;*/
}


/**
returns a pointer to the country that is currently attacked
@return the attacked country ; 0 if none
*/
const Country* KGameWindow::getAttackedCountry() const
{
    return m_secondCountry;
}

/**
returns a pointer to the currently attacking  country
@return the attacking country ; 0 if none
*/
const Country* KGameWindow::getAttackingCountry() const
{
    return m_firstCountry;
}

bool KGameWindow::haveMovingFighters() const
{
    return !m_movingFighters.empty();
}

bool KGameWindow::haveAnimFighters() const
{
    return !m_animFighters.empty();
}

bool KGameWindow::haveAnimExplodings() const
{
    return !m_animExplodings.empty();
}

bool KGameWindow::haveMovingArmies() const
{
  return (!m_movingInfantrymen.empty() 
        || !m_movingCavalrymen.empty()
        || !m_movingCannons.empty()
        || !m_movingFighters.empty());
}

} // closing namespace KsirK
