/*************************************************************************************
                          kgamewin.cpp  -  description
                             -------------------
    begin                : mer jui 11 22:27:28 EDT 2001
    copyright            : (C) 2001-2005 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 *************************************************************************************/

/*************************************************************************************
 *                                                                                   *
 *   This program is free software; you can redistribute it and/or modify            *
 *   it under the terms of the GNU General Public License as published by            *
 *   the Free Software Foundation; either version 2 of the License, or               *
 *   (at your option) any later version.                                             *
 *                                                                                   *
 *************************************************************************************/
#define KDE_NO_COMPAT

// application specific includes
#include "kgamewin.h"
#include "ksirkConfigDialog.h"
#include "ksirksettings.h"
#include "GameLogic/aiplayer.h"
#include "GameLogic/aiColsonPlayer.h"
#include "GameLogic/aiplayerio.h"
#include "GameLogic/country.h"
#include "GameLogic/onu.h"
#include "GameLogic/dice.h"
#include "GameLogic/kstringvector.h"
#include "GameLogic/goal.h"
#include "GameLogic/gameautomaton.h"
#include "GameLogic/KsirkChatItem.h"
#include "SaveLoad/ksirkgamexmlloader.h"
#include "backgnd.h"
#include "Dialogs/newGameDialogImpl.h"
#include "Dialogs/kplayersetupdialog.h"
#include "Dialogs/kwaitedplayersetupdialog.h"
#include "Dialogs/restartOrExitDialogImpl.h"


// STL include files
#include <iostream>
#include <fstream>
#include <sstream>
#include <list>
#include <vector>

// include files for QT
#include <qmetaobject.h>
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qregexp.h>
#include <qtextstream.h>
#include <qcursor.h>
#include <qevent.h>
#include <qlayout.h>
#include <qhgroupbox.h>
#include <qpushbutton.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdgameaction.h>
#include <kaboutapplication.h>
#include <kaudioplayer.h>
#include <kstandarddirs.h>
#include <kmenubar.h>
#include <kdebug.h>
#include <ktextedit.h>

#include <kchatdialog.h>
#include <kgame/kgamechat.h>

namespace Ksirk
{
using namespace GameLogic;

KGameWindow::KGameWindow(QWidget* parent, const char* name) :
    KDockMainWindow(parent, name), NKD(0), NKA(0), 
    m_theWorld(0), m_canvas(0), m_backGnd(0),
  m_movingCannons(),
  m_movingCavalrymen(),
  m_movingInfantrymen(),
  m_movingFighters(),
  m_animFighters(),
  m_animExplodings(),
  m_fighters(), 
  m_firstCountry(0), m_secondCountry(0),
  m_frame(0),
  m_barFlagButton(new KToolBarButton(statusBar(), "BarFlagButton")),
  m_accels(this), 
//   m_chat(0), 
  m_chatDlg(0)
{
  kdDebug() << "KGameWindow constructor begin" << endl;
  m_config=kapp->config();
  m_dirs = KGlobal::dirs();
  
  m_accels.setEnabled(true);
  
  kdDebug() << "Setting up std game actions" << endl;
  KStdGameAction::gameNew( this, SLOT( slotNewGame() ), actionCollection() );
  KStdGameAction::save( this, SLOT( slotSaveGame() ), actionCollection() );
  KStdGameAction::load( this, SLOT( slotOpenGame() ), actionCollection() );
  KStdGameAction::quit( this, SLOT( close() ), actionCollection() );
  
  QString iconFileName = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Images/SoldatAGenoux1.png");
  if (iconFileName.isNull())
  {
      QMessageBox::critical(0, i18n("Error !"), i18n("Cannot load icon\nProgram cannot continue"));
      exit(2);
  }
  QPixmap icon(iconFileName);

  m_mainDock = createDockWidget( "main_dock_widget", icon);
  // allow others to dock to the 4 sides
  m_mainDock->setDockSite(KDockWidget::DockCorner);
  // forbid docking abilities of mainDock itself
  m_mainDock->setEnableDocking(KDockWidget::DockNone);
  setView(m_mainDock); // central widget in a KDE mainwindow
  setMainDockWidget(m_mainDock); // master dockwidget
  
  m_bottomDock = createDockWidget( "bottom_dock_widget", icon);
  m_chatDlg = new KGameChat(&GameAutomaton::changeable(), 10000, this);
  connect(m_chatDlg,
          SIGNAL(signalReturnPressed(const QString&)),
          this,
          SLOT(slotChatMessage()));
  m_bottomDock->setWidget(m_chatDlg);
  m_bottomDock->manualDock( m_mainDock,              // dock target
                         KDockWidget::DockBottom,// dock site
                         85 );                   // relation target/this (in percent)

  kdDebug() << "Creating automaton" << endl;
  GameAutomaton::changeable().init(this);
  
  kdDebug() << "Setting skin" << endl;
  GameLogic::GameAutomaton::changeable().skin(m_config->readEntry("skin", "skins/default"));
//    kdDebug() << "Before initActions" << endl;
//   initActions();
//    kdDebug() << "Before initStatusBar" << endl;
  initStatusBar();
//    kdDebug() << "Before initSprites" << endl;
  initSprites();
  
  menuBar()-> hide();
  
  displayOpenGameButton();
  
  toolBar("mainToolBar")-> setBarPos(KToolBar::Bottom);
  toolBar("gameActionsToolBar")-> setBarPos(KToolBar::Bottom);

  connect(m_barFlagButton, SIGNAL(clicked()), this, SLOT(slotShowGoal()));
  explain();
}

KGameWindow::~KGameWindow()
{
    m_dirs = 0;
    m_config = 0;
    delete m_backGnd; m_backGnd = 0;
    delete m_canvas; m_canvas = 0;
    if (m_barFlagButton) {delete m_barFlagButton; m_barFlagButton = 0;}
    delete m_frame; m_frame = 0;
}

void KGameWindow::initActions()
{
  kdDebug() << "Adding exit toolBar button" << endl;
  addAButton(CM_EXITGAME, IDB_EXIT, SLOT(close()), i18n("Exit"), ALT+Key_F4, false, "mainToolBar");
  kdDebug() << "Adding new game toolBar button" << endl;
  addAButton(CM_NEWGAME, IDB_NEWGAME, SLOT(slotNewGame()), i18n("New game"), CTRL+Key_N, false, "mainToolBar");
  kdDebug() << "Adding new net game toolBar button" << endl;
  addAButton(CM_NEWNETGAME, IDB_NEWNETGAME, SLOT(slotJoinNetworkGame()), i18n("Join network game"), CTRL+Key_J, false, "mainToolBar");
  kdDebug() << "Adding info toolBar button" << endl;
  addAButton(CM_INFO, IDB_QUESTION, SLOT(slotShowAboutApplication()), i18n("About"), "", false, "mainToolBar");
  addAButton(CM_PREFERENCES, IDB_PREFERENCES, SLOT(optionsConfigure()), i18n("Preferences"), "", false, "mainToolBar");

  m_accels.insert( "Scroll Up", i18n("Scroll up"),
                        i18n("Scrolls up the map."),
                        Qt::Key_Down, this, SLOT(slotScrollUp()) );
  m_accels.insert( "Scroll Down", i18n("Scroll Down"),
                        i18n("Scrolls down the map."),
                        Qt::Key_Up, this, SLOT(slotScrollDown()) );
  m_accels.insert( "Scroll Left", i18n("Scroll left"),
                        i18n("Scrolls left the map."),
                        Qt::Key_Right, this, SLOT(slotScrollLeft()) );
  m_accels.insert( "Scroll Right", i18n("Scroll right"),
                        i18n("Scrolls right the map."),
                        Qt::Key_Left, this, SLOT(slotScrollRight()) );
  m_accels.insert( "Finish move", i18n("Finish move"), 
      i18n("This action causes all moving sprites to immediatly go to their destination."), 
      Qt::Key_Space,
      this, SLOT(slotFinishMoves()) );
}

void KGameWindow::initStatusBar()
{
  
  setDockWindowsMovable(true);
  statusBar()-> setSizeGripEnabled(true);
  statusBar()->insertItem("", ID_STATUS_MSG, 2);
  statusBar()-> setItemAlignment(ID_STATUS_MSG, AlignLeft | AlignVCenter);
  statusBar()->insertItem("", ID_STATUS_MSG2, 3);
  statusBar()-> setItemAlignment(ID_STATUS_MSG2, AlignLeft | AlignVCenter);
  statusBar()->addWidget(m_barFlagButton, 1, true);
}

void KGameWindow::initSprites()
{
  m_movingCannons.setAutoDelete(true);
  m_movingCavalrymen.setAutoDelete(true);
  m_movingInfantrymen.setAutoDelete(true);
  m_movingFighters.setAutoDelete(false);
  m_animFighters.setAutoDelete(false);
  m_animExplodings.setAutoDelete(false);
  m_fighters.setAutoDelete(false);
}

Country* KGameWindow::clickIn(const QPoint &point)
{
//    kdDebug() << "KGameWindow::clickIn (" << point.x() << "," << point.y() << ") ..." << endl;
  return m_theWorld-> countryAt( point.x(), point.y() );
}

Player* KGameWindow::currentPlayer()
{
//   kdDebug() << "KGameWindow::currentPlayer" << endl;
  Player* current = GameLogic::GameAutomaton::changeable().currentPlayer();

  return current;
}

void KGameWindow::loadDices()
{
//   kdDebug() << "KGameWindow::loadDices" << endl;
  
  m_dices[Blue] = std::vector<QPixmap>(6);
  m_dices[Red] = std::vector<QPixmap>(6);
  QString dicesDir = m_dirs->findResourceDir("appdata", GameAutomaton::changeable().skin() + "/Images/reddice1.png") + GameAutomaton::changeable().skin() + "/Images/";
  
  m_dices[Blue][0] = QPixmap(dicesDir+"/bluedice1.png");
  m_dices[Blue][1] = QPixmap(dicesDir+"/bluedice2.png");
  m_dices[Blue][2] = QPixmap(dicesDir+"/bluedice3.png");
  m_dices[Blue][3] = QPixmap(dicesDir+"/bluedice4.png");
  m_dices[Blue][4] = QPixmap(dicesDir+"/bluedice5.png");
  m_dices[Blue][5] = QPixmap(dicesDir+"/bluedice6.png");
  m_dices[Red][0] = QPixmap(dicesDir+"/reddice1.png");
  m_dices[Red][1] = QPixmap(dicesDir+"/reddice2.png");
  m_dices[Red][2] = QPixmap(dicesDir+"/reddice3.png");
  m_dices[Red][3] = QPixmap(dicesDir+"/reddice4.png");
  m_dices[Red][4] = QPixmap(dicesDir+"/reddice5.png");
  m_dices[Red][5] = QPixmap(dicesDir+"/reddice6.png");
}

void KGameWindow::newSkin(const QString& onuFileName)
{
  kdDebug() << "KGameWindow::newSkin " << onuFileName << endl;
//   clear();
  if (m_theWorld != 0)
  {
    m_theWorld-> reset();
    delete m_theWorld;
    m_theWorld = 0;
  }

  QString onuDefinitionFileName = onuFileName;
  if (onuDefinitionFileName.isEmpty())
  {
    onuDefinitionFileName = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Data/onu.xml");
  }
  if (onuDefinitionFileName.isEmpty())
  {
      QMessageBox::critical(0, i18n("Error !"),
          i18n("UNO definition XML file not found - Verify your installation\nProgram cannot continue"));
      exit(2);
  }
  kdDebug() << "Got ONU definition file name: " <<  onuDefinitionFileName << endl;
  m_theWorld = new ONU(onuDefinitionFileName);
  if (m_frame != 0)
  {
    haltTimer();
    m_frame->hide();
    delete m_frame;
  }
  loadDices();

  m_frame = new DecoratedGameFrame(this, (char *)"KsirK", m_theWorld->width(), m_theWorld->height());
  m_mainDock->setWidget(m_frame);


  kdDebug() << "ONU backgnd file name: " <<  m_theWorld->mapFileName() << endl;
  
  if (m_canvas != 0)
  {
    delete m_canvas;
  }

  m_canvas = new QCanvas(m_theWorld->width(), m_theWorld->height());
  m_canvas->setDoubleBuffering(true);
  kdDebug() << "Before initView" << endl;
  initView();
  kdDebug() <<"Before m_backGnd" << endl;
  m_backGnd = new BackGnd(m_canvas, m_frame, m_theWorld); //Creation of the background
  kdDebug() <<"Before paint" << endl;
  paint();
  PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
  PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
  for (; it != it_end; it++)
  {
    ((Player*)(*it))->setFlag();
  }
  
  kdDebug() << "Setting up GUI" << endl;
  setupGUI();

  initTimer();
  kdDebug() <<"End new skin" << endl;

  initActions();
  toolBar("mainToolBar")-> hide();
  toolBar("gameActionsToolBar")-> hide();
  toolBar("mainToolBar")-> show();
  toolBar("gameActionsToolBar")-> show();
  toolBar("mainToolBar")-> setBarPos(KToolBar::Bottom);
  toolBar("gameActionsToolBar")-> setBarPos(KToolBar::Bottom);
  m_frame->setFocus();
};

void KGameWindow::initView()
{
  QString iconFileName = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/Images/SoldatAGenoux1.png");
  if (iconFileName.isNull())
  {
      QMessageBox::critical(0, i18n("Error !"), i18n("Cannot load icon\nProgram cannot continue"));
      exit(2);
  }
  m_frame->setIcon(QPixmap(iconFileName));

  disconnectMouse();
  reconnectMouse();
  setCaption("KsirK",false);
  m_canvas-> update();
  m_frame->setCanvas(m_canvas);
  m_frame-> show();
  adjustSize();
  m_frame->setFocus();
}

void KGameWindow::paint()
{
//   kdDebug() << "KGameWindow::paint" << endl;
//    kdDebug() << "Painting countries..." << endl;
  for (unsigned int i = 0; i < m_theWorld-> getCountries().size(); i++)
  {
        (m_theWorld-> getCountries().at(i))->paint();
  }
//    kdDebug() << "End painting countries" << endl;
  if (!m_movingCannons.isEmpty())
  {
    m_movingCannons.repaint();    //Dessiner les sprites
  }
  if (!m_movingCavalrymen.isEmpty())
  {
    m_movingCavalrymen.repaint();    //Dessiner les sprites
  }
  if (!m_movingInfantrymen.isEmpty())
  {
    m_movingInfantrymen.repaint();    //Dessiner les sprites
  }
  if (!m_movingFighters.isEmpty())
  {
    m_movingFighters.repaint();    //Dessiner les sprites
  }
  if (!m_animFighters.isEmpty())
  {
//        kdDebug() << "Test arret combat" << endl;
    m_animFighters.repaint();    //Dessiner les sprites
    if (m_animFighters.firstThatIsLastFrame()) stopCombat();
  }
  if (!m_animExplodings.isEmpty())
  {
//        kdDebug() << "m_animExplodings.repaint" << endl;
    m_animExplodings.repaint();    //Dessiner les sprites
    haltTimer();
    if (m_animExplodings.firstThatIsLastFrame()) stopExplosion();
    initTimer();
  }
  if (!m_fighters.isEmpty())
  {
      m_fighters.repaint();    //Dessiner les sprites
  }
//    kdDebug() << "OUT KGameWindow::paint" << endl;
}

void KGameWindow::evenementTimer()
{        //Appel du Timer toutes les 50 ms
  QPoint mousePosition;

//    kdDebug() << "KGameWindow::evenementTimer" << endl;
  mousePosition = QCursor::pos();
  mousePosition = m_frame-> mapFromGlobal(mousePosition);
//    mousePosition += QPoint(m_frame-> contentsX(), m_frame-> contentsY());
//    kdDebug() << "mousePosition = ( " << mousePosition.x() << " , " << mousePosition.y() << " )" << endl;
//    kdDebug() << "m_frame = ( " << m_frame-> visibleWidth() << " , " << m_frame-> visibleHeight() << " )" << endl;
  if ((mousePosition.x() < 5) && (mousePosition.x() >= 0)
      && (mousePosition.y() >= 0) && (mousePosition.y() <= m_frame-> visibleHeight()))
  {
    m_backGnd-> scrollRight();
  }

  if ((mousePosition.x() > m_frame-> visibleWidth() -10) &&
      (mousePosition.x() <= m_frame-> visibleWidth())
      && (mousePosition.y() >= 0) && (mousePosition.y() <= m_frame-> visibleHeight()))
  {
    m_backGnd-> scrollLeft();
  }
  if ((mousePosition.y() < 5) && (mousePosition.y() >= 0)
      && (mousePosition.x() >= 0) && (mousePosition.x() <= m_frame-> visibleWidth()))
  {
    m_backGnd-> scrollDown();
  }
  if ((mousePosition.y() >  m_frame-> visibleHeight() -10) &&
      (mousePosition.y() <=  m_frame-> visibleHeight())
      && (mousePosition.x() >= 0) && (mousePosition.x() <= m_frame-> visibleWidth()))
  {
    m_backGnd-> scrollUp();
  }
  if (!m_movingCannons.isEmpty()) moveCannons();
  if (!m_movingCavalrymen.isEmpty()) moveCavalrymen();
  if (!m_movingInfantrymen.isEmpty()) moveInfantrymen();
  if (!m_movingFighters.isEmpty()) moveMovingCombatants();
  if (!m_animFighters.isEmpty())
  {
//        kdDebug() << "m_animFighters next frame !" << endl;
    m_animFighters.forEachNextFrame();
  }
  if (!m_animExplodings.isEmpty())
  {
    m_animExplodings.forEachNextFrame();
  }

  if ( m_movingCannons.isEmpty() && m_movingCavalrymen.isEmpty() &&
      m_movingInfantrymen.isEmpty() && m_movingFighters.isEmpty() &&
      m_animFighters.isEmpty() && m_animExplodings.isEmpty() )
  {
    if ( m_secondCountry && !( m_secondCountry-> owner() ) )
      kdError() << m_secondCountry-> name() << " does not belong to anybody !" << endl;
    // handling of the AI player actions
    if ( !( ( ( currentPlayer() && currentPlayer()-> isAI() )
            || ( ( isMyState(GameLogic::GameAutomaton::WAITDEFENSE)  ) && ( m_secondCountry ) && (m_secondCountry->owner())
                 && ( m_secondCountry->owner()->isAI() ) ) ) ) )
      toolBar("gameActionsToolBar")-> show();
  }


//    kdDebug() << "KGameWindow::evenementTimer before paint" << endl;
  paint();

//    kdDebug() << "KGameWindow::evenementTimer before m_canvas update" << endl;
  m_canvas-> update();

  if ( currentPlayer() 
       && (currentPlayer()-> isAI() ) 
       && (!currentPlayer()->isVirtual())
       && (!(static_cast< AIPlayer* >(currentPlayer())-> running())) 
     )
  {
    static_cast< AIPlayer* >(currentPlayer())-> start();
  }
  if (    ( isMyState(GameLogic::GameAutomaton::WAITDEFENSE)  ) 
       && ( m_secondCountry ) 
       && ( m_secondCountry->owner())
       && ( m_secondCountry->owner()->isAI() ) 
       && ( !m_secondCountry->owner()->isVirtual())
       && ( !(static_cast< AIPlayer* >(m_secondCountry->owner())-> running())) 
     )
  {
    static_cast< AIPlayer* >(m_secondCountry->owner())-> start();
  }
  
  
  GameAutomaton::changeable().run();
//    kdDebug() << "OUT KGameWindow::evenementTimer" << endl;
};

bool KGameWindow::attackEnd()
{
  kdDebug() << "KGameWindow::attackEnd" << endl;
  if (m_firstCountry==0 || m_secondCountry == 0)
  {
    return false;
  }
  bool res = false;
  QString mes = "";
  kdDebug() << "There is now " << m_secondCountry-> nbArmies() << " armies in " << m_secondCountry->name() << "." << endl;
  if (m_secondCountry-> nbArmies() == 0)
  {
    QPixmap pm(*currentPlayer()->getFlag()->image(0));

    KStringVector messageParts;
    messageParts << pm << I18N_NOOP("<font color=\"red\">%1 conquered %2 from %3</font>") << currentPlayer()->name() << m_secondCountry-> name() << m_firstCountry-> name();
    broadcastChangeItem(messageParts, ID_NO_STATUS_MSG);
    
    Player* oldOwner = m_secondCountry-> owner();
    unsigned int newOldOwnerNbCountries = oldOwner-> getNbCountries() - 1;
    
    if (GameLogic::GameAutomaton::changeable().isAdmin())
    {
      currentPlayer()-> incrNbCountries();
      oldOwner-> decrNbCountries();
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      stream << currentPlayer()->id();
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,CheckGoal);
      
    }
    
    m_secondCountry-> owner(currentPlayer());
    m_secondCountry-> nbArmies(1);
    m_firstCountry-> decrNbArmies();
    m_canvas-> update();
    if (m_firstCountry->nbArmies() > 1)
    {
      res = true;
    }
    kdDebug() << oldOwner-> name() << " now owns " << newOldOwnerNbCountries << " countries." << endl;
    if (newOldOwnerNbCountries == 0)
    {
      unsigned int oldOwnerId = oldOwner->id();
      KMessageBox::information(this,
                               i18n("%1, you are defeated! Bye, bye...").arg(oldOwner->name()),
                               i18n("KsirK - Game Over !"));
      if (GameLogic::GameAutomaton::changeable().isAdmin())
      {
        kdDebug() << "Removing player " << oldOwner-> name() << endl;
        GameLogic::GameAutomaton::changeable().playerList()->remove(oldOwner);
        kdDebug() << "There is now " << GameLogic::GameAutomaton::changeable().playerList()->count() << " GameLogic::GameAutomaton::changeable().playerList()->" << endl;
      }
      if ( ( (GameLogic::GameAutomaton::changeable().useGoals()) 
             && ( (currentPlayer()->goal()->type() == GameLogic::Goal::GoalPlayer) 
             && ( (*currentPlayer()->goal()->players().begin()) == oldOwnerId) ) ) 
           || (GameLogic::GameAutomaton::changeable().playerList()->count() == 1) )
      {
        haltTimer();
        GameLogic::GameAutomaton::changeable().state(GameLogic::GameAutomaton::GAME_OVER);
        QByteArray buffer;
        QDataStream stream(buffer, IO_WriteOnly);
        stream << currentPlayer()->id();
        GameLogic::GameAutomaton::changeable().sendMessage(buffer,Winner);
        return res;
      }
    }
  }
  m_firstCountry-> createArmiesSprites(m_backGnd);
  m_secondCountry-> createArmiesSprites(m_backGnd);
  if (GameLogic::GameAutomaton::changeable().isAdmin())
  {
    if (res)
    {
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayInvasionButtons);
    }
    else
    {
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNormalGameButtons);
      KStringVector messageParts;
      messageParts << I18N_NOOP("%1 : it's up to you again") << currentPlayer()-> name();
      broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
    }
  }
  return res;
}

void KGameWindow::winner(const Player* player)
{
  QString msg = "%1 won !";
  if (!player->isVirtual())
  {
    msg = "<big><b>%1</b>, you won !</big>";
  }
  if (GameLogic::GameAutomaton::changeable().useGoals())
  {
    msg += QString("<br/>Winner's goal was stated like this:<br/><i>") 
        += player->goal()->message()
        += QString("</i><br/><br/>Do you want to play again ?");
  }
  else
  {
    if (!player->isVirtual())
    {
      msg += "<br/>You conquered all the world!";
    }
    else
    {
      msg += "<br/>He conquered all the world!";
    }
  }
  RestartOrExitDialogImpl* restartDia = new RestartOrExitDialogImpl(i18n(msg).arg(player->name()));
              
  connect((QObject*)restartDia->newGameButton,
              SIGNAL(clicked()),
              this,
              SLOT(slotNewGame()));

  connect((QObject*)restartDia->exitButton,
              SIGNAL(clicked()),
              this,
              SLOT(close()));

  restartDia->setModal(true);
  restartDia->show();
}

void KGameWindow::resolveAttack()
{
//    kdDebug() << "KGameWindow::resolveAttack" << endl;

  int A1 = -1; int A2 = -1; int A3 = -1; int AE = -1;
  int D1 = -1; int D2 = -1; int DE = -1;
  
  NKD = NKA = 0;
  if (currentPlayer() == 0 || m_secondCountry == 0 || m_secondCountry->owner() == 0 || m_firstCountry == 0)
    return;
  A1 = Dice::roll();
  if (currentPlayer()-> getNbAttack() > 1) A2 = Dice::roll();
  if (currentPlayer()-> getNbAttack() > 2) A3 = Dice::roll();
  if ((A1>=A2)&&(A1>=A3))  // A1 is the greater ; don't move it; look at the two others
    if (A2>=A3) {} // A2 greater than A3 ; don't move
    else {AE = A2;A2 = A3;A3 = AE;} // A2 lesser than A3 ; swap them
  else
  { // A1 is not the greater
    if (A2>=A3) {AE=A1;A1=A2;A2=AE;}  // A2 is greater than A3, so it is the greater; swap it with A1
    else {AE=A1;A1=A3;A3=AE;} // A3 is greater than A2, so it is the greater; swap it with A1
                                            // now the new A1 is the greater, look at the 2 others
    if (A2>=A3) {} // A2 greater than A3, nothing to do
    else {AE=A2;A2=A3;A3=AE;} // A2 lesser than A3; swap them
  }
  D1 = Dice::roll();
  if (m_secondCountry-> owner()-> getNbDefense() > 1)
    D2 = Dice::roll();
  if (D2>D1) {DE=D1;D1=D2;D2=DE;}
  if (A1>D1)
  {
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    stream << m_secondCountry->name() << Q_UINT32(1);
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DecrNbArmies);
    NKD++;
  }
  else
  {
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    stream << m_firstCountry->name() << Q_UINT32(1);
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DecrNbArmies);
    NKA++;
  }
  if ((A2>0)&&(D2>0))
  {
    if (A2>D2)
    {
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      stream << m_secondCountry->name() << Q_UINT32(1);
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,DecrNbArmies);
      NKD++;
    }
    else
    {
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      stream << m_firstCountry->name() << Q_UINT32(1);
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,DecrNbArmies);
      NKA++;
    }
  }
//   kdDebug() << "(" << A1<<", "<<A2<<", "<<A3<<") <-> ("<<D1<<", "<<D2<<")"  << endl;
//   kdDebug() << "Attacker loses " << NKA<<" armies; Defender loses "<<NKD<<" armies."  << endl;
  
  KStringVector messageParts;
  if (currentPlayer()-> getNbAttack() == 1)
  {
    messageParts <<m_dices[Red][A1-1]<<"  "<<m_dices[Blue][D1-1];
  }
  else if (currentPlayer()-> getNbAttack() == 2 && m_secondCountry-> owner()-> getNbDefense() == 1) 
  {
    messageParts <<m_dices[Red][A1-1]<<" "<<m_dices[Red][A2-1]
            <<"  "<<m_dices[Blue][D1-1];
  }
  else if (currentPlayer()-> getNbAttack() == 2 && m_secondCountry-> owner()-> getNbDefense() == 2) 
  {
    messageParts <<m_dices[Red][A1-1]<<" "<<m_dices[Red][A2-1]
            <<"  "<<m_dices[Blue][D1-1]<<"  "<<m_dices[Blue][D2-1];
  }
  else if (currentPlayer()-> getNbAttack() == 3 && m_secondCountry-> owner()-> getNbDefense() == 1)
  {
    messageParts <<m_dices[Red][A1-1]<<" "<<m_dices[Red][A2-1]<<" "<<m_dices[Red][A3-1]<<"  "<<m_dices[Blue][D1-1];
  }
  else if (currentPlayer()-> getNbAttack() == 3 && m_secondCountry-> owner()-> getNbDefense() == 2) 
  {
    messageParts <<m_dices[Red][A1-1]<<" "<<m_dices[Red][A2-1]<<" "<<m_dices[Red][A3-1]
            <<"  "<<m_dices[Blue][D1-1]<<"  "<<m_dices[Blue][D2-1];
  }
  if (NKA > 0)
  {
    QPixmap pm(*currentPlayer()->getFlag()->image(0));
    messageParts << I18N_NOOP("The attacker <font color=\"red\">%1</font> (")<<m_firstCountry->name()<<pm<< I18N_NOOP("%1) <font color=\"red\">loses %2 armies</font>.") << currentPlayer()-> name() << QString::number(NKA);
  }
  if (NKD > 0)
  {
    QPixmap pm(*m_secondCountry->owner()->getFlag()->image(0));
    messageParts << I18N_NOOP("The defender <font color=\"blue\">%1</font> (")<<m_secondCountry->name()<<pm<<I18N_NOOP("%1) <font color=\"blue\">loses %2 armies</font>.") << m_secondCountry->owner()-> name() << QString::number(NKD);
  }
  
  broadcastChangeItem(messageParts, ID_NO_STATUS_MSG);
  
  QByteArray buffer2;
  QDataStream stream2(buffer2, IO_WriteOnly);
  
  if ((NKD != 0)&&(NKA != 0)) stream2 << Q_UINT32(2);
  else if (NKA != 0) stream2 << Q_UINT32(0);
  else if (NKD != 0) stream2 << Q_UINT32(1);
  GameLogic::GameAutomaton::changeable().sendMessage(buffer2,AnimExplosion);
}

/**
  * Reimplementation of the inherited function called when a window close event arise
  */
bool KGameWindow::queryClose()
{
    switch ( KMessageBox::warningYesNoCancel( this, i18n("Before you quit, do want to save your game?")) ) {
    case KMessageBox::Yes :
        slotSaveGame();
        return true;
    case KMessageBox::No :
        return true;
    default: // cancel
        return false;
    }
}

bool KGameWindow::actionOpenGame()
{
//   kdDebug() << "KGameWindow::actionOpenGame" << endl;
  haltTimer();
  QString fileName = KFileDialog::getOpenFileName(QString::null, "*.xml", this, i18n("KsirK - Load Game")); 
  if (fileName != "")
  {
    m_waitedPlayers.clear();
    Ksirk::SaveLoad::GameXmlLoader loader(fileName, *this, m_waitedPlayers);
    for (unsigned int i = 0; i < m_theWorld->getNbCountries(); i++)
    {
      Country* country = m_theWorld-> getCountries().at(i);
//       kdDebug() << "Adding sprites to " << country->name() << endl;    
      country-> createArmiesSprites(m_backGnd);
      Player *player = country-> owner();
      if (player)
      {
        country-> flag(player->flagFileName(), m_backGnd);
      }
    }
    m_backGnd->hide();
    m_backGnd->show();
    if (m_waitedPlayers.empty())
    {
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNormalGameButtons);
      GameLogic::GameAutomaton::changeable().setGameStatus(KGame::Run);
//       kdDebug() << "slotOpenGame before initTimer" << endl;
      initTimer();
//       kdDebug() << "slotOpenGame after initTimer" << endl;
      m_frame->setFocus();
      return false;
    }
    else
    {
      KStringVector messageParts;
      messageParts << I18N_NOOP("Waiting for the connection of %1 network players.") << QString::number(m_waitedPlayers.size());
      broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
      return true;
    }
  }
  return false;
}

void KGameWindow::displayNextPlayerButton()
{
//   kdDebug() << "displayNextPlayerButton" << endl;
  clearGameActionsToolbar(false);
  if (currentPlayer() && !currentPlayer()->isVirtual() && currentPlayer()-> isAI())
  {
//     kdDebug() << "... NOT adding button: AI" << endl;
    if (!(static_cast<AIPlayer *>(currentPlayer()))-> running()) 
    {
      (static_cast< AIPlayer * >(currentPlayer()))-> start();
    }
  }
  else if (!currentPlayer()->isVirtual())
  {
//     kdDebug() << "... adding button" << endl;
    addAButton( CM_NEXTPLAYER, IDB_NEXTPLAYER,
                SLOT(slotNextPlayer()), i18n("Next Player"),Key_Escape,true);
  }
}

void KGameWindow::displayRecyclingButtons()
{
//   kdDebug() << "KGameWindow::displayRecyclingButtons" << endl;
  clearGameActionsToolbar(false);
  if (GameLogic::GameAutomaton::changeable().allLocalPlayersComputer())
  {
//     kdDebug() << "There is only computer local players" << endl;
    PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
    PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
    for (; it != it_end; it++)
    {
//       kdDebug() << "Looking at player " << (*it)->name() 
//               << ". is AI  : " << ((Player*)(*it))->isAI() 
//               << ". running: " << ((static_cast<AIPlayer *>(*it))-> running())
//               << ". virtual: " << (*it)->isVirtual() 
//                       << endl;
      if ( ((Player*)(*it))->isAI() 
           && (!(static_cast<AIPlayer *>(*it))-> running())
        && (!(*it)->isVirtual()) ) 
      {
//         kdDebug() << "Starting computer player " << (*it)->name() << endl;
        (static_cast<AIPlayer *>(*it))-> start();
        break;
      }
    }
  }
  else
  {
    addAButton(CM_RECYCLING,  IDB_RECYCLING, SLOT(slotRecycling()), i18n("Redistribute"),Key_R,true);
    addAButton(CM_RECYCLINGFINISHED,  IDB_RECYCLINGFINISHED, SLOT(slotRecyclingFinished()), i18n("End redistribute"), Key_Tab, true);
  }
}

void KGameWindow::displayOpenGameButton()
{
  clearGameActionsToolbar();
  addAButton(CM_OPENGAME, IDB_OPENGAME, SLOT(slotOpenGame()), i18n("Open game"),CTRL+Key_O,true);
}

void KGameWindow::displayNormalGameButtons()
{
//   kdDebug() << "KGameWindow::displayNormalGameButtons" << endl;
  clearGameActionsToolbar(false);
  if (currentPlayer() && currentPlayer()-> isAI() && (!currentPlayer()->isVirtual()))
  {
    if (!(static_cast<AIPlayer *>(currentPlayer()))-> running()) (static_cast<AIPlayer *>(currentPlayer()))-> start();
  }
  else if (!currentPlayer()->isVirtual())
  {
    addAButton(CM_OPENGAME, IDB_OPENGAME, SLOT(slotOpenGame()), i18n("Open game"),CTRL+Key_O,true);
    addAButton(CM_SAVEGAME, IDB_SAVEGAME, SLOT(slotSaveGame()), i18n("Save game"),CTRL+Key_S,true);
    addAButton(CM_NEXTPLAYER,  IDB_NEXTPLAYER, SLOT(slotNextPlayer()), i18n("Next Player"),Key_Escape,true);
    addAButton(CM_ATTACK1,  IDB_ATTACK1, SLOT(slotAttack1()), i18n("Attack with one army"),Qt::Key_1,true);
    addAButton(CM_ATTACK2,  IDB_ATTACK2, SLOT(slotAttack2()), i18n("Attack with two armies"),Qt::Key_2,true);
    addAButton(CM_ATTACK3,  IDB_ATTACK3, SLOT(slotAttack3()), i18n("Attack with three armies"),Qt::Key_3,true);
    addAButton(CM_SHIFT,  IDB_SHIFT, SLOT(slotMove()), i18n("Move armies"),Key_M,true);
  }
}

void KGameWindow::displayDefenseButtons()
{
  clearGameActionsToolbar(false);
  if (currentPlayer() && currentPlayer()-> isAI()  && (!currentPlayer()->isVirtual()))
  {
    if (!(static_cast<AIPlayer *>(currentPlayer()))-> running()) (static_cast<AIPlayer *>(currentPlayer()))-> start();
  }
  if (! (m_secondCountry-> owner()->isAI() ))
  {
    if (m_secondCountry && m_secondCountry-> owner() && m_secondCountry-> owner()-> getFlag())
        m_barFlagButton-> setPixmap(*(m_secondCountry-> owner()->getFlag()-> image()));
    addAButton(CM_DEFENSE1,  IDB_DEFENSE1, SLOT(slotDefense1()), i18n("Defend with one army"),Qt::Key_1,true);
    addAButton(CM_DEFENSE2,  IDB_DEFENSE2, SLOT(slotDefense2()), i18n("Defend with two armies"),Qt::Key_2,true);
  }
}

void KGameWindow::displayInvasionButtons()
{
  clearGameActionsToolbar(false);
  if (currentPlayer() && currentPlayer()-> isAI()  && (!currentPlayer()->isVirtual()))
  {
    if (!(static_cast<AIPlayer *>(currentPlayer()))-> running()) (static_cast<AIPlayer *>(currentPlayer()))-> start();
  }
  else if (!currentPlayer()->isVirtual())
  {
    addAButton(CM_INVADE1,  IDB_INVADE1, SLOT(slotInvade1()), i18n("Invade with one army"),Qt::Key_1,true);
    addAButton(CM_INVADE5,  IDB_INVADE5, SLOT(slotInvade5()), i18n("Invade with five armies"),Qt::Key_5,true);
    addAButton(CM_INVADE10,  IDB_INVADE10, SLOT(slotInvade10()), i18n("Invade with ten armies"),Qt::Key_0,true);
    addAButton(CM_INVASIONFINISHED,  IDB_INVASIONFINISHED, SLOT(slotInvasionFinished()), i18n("End Invasion"),Key_Return,true);
    addAButton(CM_RETREAT1,  IDB_RETREAT1, SLOT(slotRetreat1()), i18n("Retract one army"),CTRL+Qt::Key_1,true);
    addAButton(CM_RETREAT5,  IDB_RETREAT5, SLOT(slotRetreat5()), i18n("Retract five armies"),CTRL+Qt::Key_5,true);
    addAButton(CM_RETREAT10,  IDB_RETREAT10, SLOT(slotRetreat10()), i18n("Retract ten armies"),CTRL+Qt::Key_0,true);
  }
}

void KGameWindow::displayCancelButton()
{
  clearGameActionsToolbar();
  if (currentPlayer() && currentPlayer()-> isAI()  && (!currentPlayer()->isVirtual()))
  {
    if (!(static_cast<AIPlayer *>(currentPlayer()))-> running()) (static_cast<AIPlayer *>(currentPlayer()))-> start();
  }
  else addAButton(CM_CANCEL,  IDB_CANCEL, SLOT(slotCancel()), i18n("Cancel"), Key_Escape, true);
}

void KGameWindow::clearGameActionsToolbar(bool send)
{
//   kdDebug()<< "KGameWindow::clearGameActionsToolbar " << send << endl;
  if (send)
  {
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,ClearGameActionsToolbar);
  }
  
  (*toolBar("gameActionsToolBar")).clear();
  std::set< QString >::const_iterator it, it_end;
  it = m_temporaryAccelerators.begin(); it_end = m_temporaryAccelerators.end();
  for (; it != it_end; it++)
  {
    m_accels.remove(*it);
  }
  m_temporaryAccelerators.clear();
  m_accels.updateConnections();
}

void KGameWindow::addAButton(
    const QString& fileName, 
    int id, 
    const char* slot, 
    const QString& txt, 
    const KShortcut& shortcut,
    bool isTemp, 
    const std::string& toolBarName)
{
//   kdDebug() << "addAButton: " << fileName << endl;
  QString imageFileName = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/" + fileName);
//   kdDebug() << "Trying to load button image file: " << imageFileName << endl;
  if (imageFileName.isNull())
  {
    QMessageBox::critical(0, i18n("Error !"), i18n("Cannot load button image\nProgram cannot continue"));
    exit(2);
  }
  (*toolBar(toolBarName.c_str())).insertButton(QPixmap(imageFileName), id, SIGNAL(clicked()),
                          this,  slot, true,txt);
//   kdDebug() << "Button added " << txt << endl;
  if (shortcut != KShortcut::null())
  {
    QString str = " ";
    if (txt != "")
    {
      str = txt;
    }
    void* accel = m_accels.insert( txt, i18n(str),
                          i18n(str),
                          shortcut, this, slot );
//     kdDebug() << "Inserted accelerator " << accel << endl;
    
  }
  if (isTemp)
  {
    m_temporaryAccelerators.insert(txt);
  }
}

void KGameWindow::setBarFlagButton(const Player* player)
{
//   kdDebug() << "KGameWindow::setBarFlagButton" << endl;

  if (player == 0)
  {
    if (currentPlayer() 
        && currentPlayer()-> getFlag() 
        && currentPlayer()-> getFlag()-> image())
    {
      m_barFlagButton-> setPixmap(*(currentPlayer()->getFlag()-> image()));
      m_barFlagButton->show();
    }
  }
  else
  {
    if (player-> getFlag() && player-> getFlag()-> image())
    {
      m_barFlagButton-> setPixmap(*(player-> getFlag()-> image()));
      m_barFlagButton->show();
    }
  }
  m_frame->setFocus();
}

bool KGameWindow::setupPlayers()
{
  kdDebug() << "KGameWindow::setupPlayers" << endl;
  haltTimer();
  
  // Number of players
  bool networkGame = false;
  int port;
  uint newPlayersNumber = 0;
  if (!GameAutomaton::changeable().setupPlayersNumberAndSkin(networkGame, port, newPlayersNumber))
  {
    return false;
  }
  
  if (!(GameLogic::GameAutomaton::changeable().playerList()->isEmpty()))
  {
    GameLogic::GameAutomaton::changeable().playerList()->clear();
    GameLogic::GameAutomaton::changeable().currentPlayer(0);
    kdDebug() << "  playerList size = " << GameLogic::GameAutomaton::changeable().playerList()->count() << endl;
  }
  theWorld()->reset();
  clearGameActionsToolbar();
  
  std::map< QString, QString > nations = nationsList();
  if (!(GameLogic::GameAutomaton::changeable().playerList()->isEmpty()))
  {
    GameLogic::GameAutomaton::changeable().playerList()->clear();
  }
  //m_theWorld->communicatesWith_test();
  kdDebug() << "KGameWindow::setupPlayers: before switch; newPlayersNumber = " << newPlayersNumber << endl;
  unsigned int nbAvailArmies = (unsigned int)(m_theWorld->getNbCountries() * 2.5 / newPlayersNumber);
  kdDebug() << "KGameWindow::setupPlayers: nbAvailArmies = " << nbAvailArmies << " ; nb countries = " << m_theWorld->getNbCountries() << endl;
  // Players names
  QString mes = "";
  QString nationName;
  for (unsigned int i = 0; 
       i < newPlayersNumber - GameLogic::GameAutomaton::changeable().networkPlayersNumber(); 
       i++)
  {
    QString nomEntre = "";
    bool computer;
    bool network = false;
    QString password;

    // After closing KPlayerSetupDialog, it is guaranteed, that nomEntre is a valid
    // username (not empty, unique)
    KPlayerSetupDialog(m_theWorld, i, nomEntre, network, password, computer, nations, nationName,
                       this, "KDialogSetupPlayer").exec();

    kdDebug() << "Creating player " << nomEntre << "(computer: " << computer << "): " << nationName << endl;
    addPlayer(nomEntre, nbAvailArmies, 0, nationName, computer);
    nations.erase(nationName);
  }
  if (networkGame)
  {
    kdDebug() << "In setupPlayers: networkGame" << endl;
    GameLogic::GameAutomaton::changeable().offerConnections(port);
    KStringVector messageParts;
    messageParts << I18N_NOOP("Waiting for %1 players to connect")
      << QString::number(GameLogic::GameAutomaton::changeable().networkPlayersNumber());
    broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
  }
  m_frame->setFocus();
  return true;
}

bool KGameWindow::setupOnePlayer()
{
  kdDebug() << "KGameWindow::setupOnePlayer" << endl;
  haltTimer();
  
  kdDebug() << "  building the list of available nations" << endl;
  std::map< QString, QString > nations = nationsList();
  PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
  PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
  for (; it != it_end; it++)
  {
    Player* player = (Player*)(*it);
    std::cerr << "    removing nation of player " << player-> name() << std::endl;
    /// Don't understand why if using Player::getNation below, the method is
    /// not executed (get 0) but if using the same named myNation, it works...
    /// Ideas anybody ????
    Nationality* nation = player-> myNation();
    std::cerr << "    got player nation " << nation << std::endl;
    QString nationName = nation->name();
    std::map<QString,QString>::iterator nationsIt;
    nationsIt = nations.find(nationName);
    if (nationsIt !=  nations.end())
    {
      nations.erase(nationsIt);
    }
  }
  kdDebug() << "  number of available nations: " << nations.size() << endl;
  //m_theWorld->communicatesWith_test();
  unsigned int nbAvailArmies = (unsigned int)(m_theWorld->getNbCountries() * 2.5 / (GameAutomaton::changeable().nbPlayers()));
  kdDebug() << "KGameWindow::setupOnePlayer: nbAvailArmies = " << nbAvailArmies << " ; nb countries = " << m_theWorld->getNbCountries() << endl;
  // Players names
  QString mes = "";
  QString nationName;
    
  QString nomEntre = "";
  bool computer;
    
  bool found = true;
  while(found)
  {
    QString password;
    bool emptyName = true;
    while (emptyName)
    {
      mes.sprintf(i18n("Player number %d, what's your name ?"), 0);
      bool network = true;
      KPlayerSetupDialog(m_theWorld, 0, nomEntre, network, password, computer, nations, nationName, this, "KDialogSetupPlayer").exec();
      kdDebug() << "After KPlayerSetupDialog. name: " << nomEntre << endl;
      if (nomEntre == "")
      {
        mes.sprintf( i18n("Error - Player %d, you have to choose a name."), 0);
        QMessageBox::warning(this, i18n("Error"), mes);
        nomEntre.sprintf( i18n("Player%d"), 0);
      }
      else 
      {
        emptyName = false;
      }
    }
    found = false;
    PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
    PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
    for (; it != it_end; it++)
    {
      if ( (*it)-> name() ==  nomEntre)
      {
        found = true;
        it = it_end;
      }
    }
    if (!found)
    {
      kdDebug() << "Creating player " << nomEntre 
        << "(computer: " << computer << "): " << nationName 
        << " password: " << password << endl;
      addPlayer(nomEntre, nbAvailArmies, 0, nationName, computer, password);
      nations.erase(nationName);
    }
  }
  return true;
}

bool KGameWindow::setupOneWaitedPlayer()
{
  kdDebug() << "KGameWindow::setupOneWaitedPlayer" << endl;
  haltTimer();
  
  QString password;
  int result;
  KWaitedPlayerSetupDialog(password, result, this, "KWaitedPlayerSetupDialog").exec();
  kdDebug() << "After KWaitedPlayerSetupDialog. number: " << result << ", password: " << password << endl;
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  stream << (Q_UINT32)result << password;
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,ValidateWaitedPlayerPassword);
  initTimer();
  return true;
}

bool KGameWindow::createWaitedPlayer(Q_UINT32 waitedPlayerId)
{
  kdDebug() << "KGameWindow::createWaitedPlayer" << endl;
  haltTimer();
  
  PlayerMatrix& pm = m_waitedPlayers[waitedPlayerId];
  Player* player = 0;
  if (pm.isAI)
  {
    player = new AIColsonPlayer(pm.name, pm.nbAvailArmies,
                                      m_theWorld-> nationNamed(pm.nation), *GameLogic::GameAutomaton::changeable().playerList(), m_theWorld, &GameLogic::GameAutomaton::changeable());
    GameAutomaton::changeable().addPlayer(player);
    kdDebug() << "Created Waited AI player " << player->name() << endl;
    ((AIPlayer*)(player))->stop();
    kdDebug() << "Calling AI player createIO" << endl;
    GameAutomaton::changeable().createIO(player, KGameIO::IOMode(AIPLAYERIO));
  }
  else
  {
    player = new Player(pm.name, pm.nbAvailArmies, m_theWorld-> nationNamed(pm.nation));
    GameAutomaton::changeable().addPlayer(player);
    kdDebug() << "Created player " << player->name() << endl;
    kdDebug() << "Calling player createIO" << endl;
    GameAutomaton::changeable().createIO(player,KGameIO::IOMode(KGameIO::MouseIO));
    m_chatDlg->setFromPlayer(player);
  }
  player->setNbCountries(pm.nbCountries);
  player->setNbAvailArmies(pm.nbAvailArmies);
  player->setNbAttack(pm.nbAttack);
  player->setNbDefense(pm.nbDefense);
  player->setPassword(pm.password);
  player->goal(pm.goal);
  std::set<QString>::iterator it, it_end;
  it = pm.countries.begin(); it_end = pm.countries.end();
  for (; it != it_end; it++)
  {
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    stream << (*it) << pm.name;
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,CountryOwner);
  }
  return true;
}


void KGameWindow::firstCountriesDistribution()
{
  kdDebug() << "KGameWindow::firstCountriesDistribution" << endl;    
  
  if (GameAutomaton::changeable().isAdmin())
  {
    PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
    PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
    for (; it != it_end; it++)
    {
      ((Player*)(*it))->setNbAvailArmies((unsigned int)(m_theWorld->getNbCountries() * 2.5 / GameLogic::GameAutomaton::changeable().nbPlayers() ));
    }
    setCurrentPlayerToFirst();
    kdDebug() << "Setup players: distributing countries" << endl;
    countriesDistribution();
    
    
  //    kdDebug() << " KGameWindow::setupPlayers: before initTimer" << endl;
    initTimer();
    setCurrentPlayerToFirst();
    if ( currentPlayer()-> isAI()  && (!currentPlayer()->isVirtual()) )
      if ( ! ( static_cast<AIPlayer *>(currentPlayer())-> running()) )
        static_cast<AIPlayer *>(currentPlayer())-> start();
    
    
  //    kdDebug() << "OUT  KGameWindow::setupPlayers" << endl;
    
  }
}



void KGameWindow::distributeArmies()
{
//   kdDebug() << "KGameWindow::distributeArmies" << endl;
  PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
  PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
  for (; it != it_end; it++)
  {
    unsigned int nb = nbNewArmies(static_cast<Player*>(*it));
//     kdDebug() << "    Giving " << nb << " armies to " << static_cast<Player*>(*it)->name() << endl;
    static_cast<Player*>(*it)-> setNbAvailArmies(nb);
  }
}

int KGameWindow::nbNewArmies(Player *player)
{
//    kdDebug() << "KGameWindow::nbNewArmies for "  << player-> name() << endl;

  unsigned int res = 0;

  for (unsigned int i = 0; i<m_theWorld->getNbCountries(); i++)
      if (m_theWorld-> getCountries().at(i)-> owner() == player) res++;
  res = (res/3) < 3 ? 3 : res/3 ;

  std::vector<Continent*>& continents = m_theWorld-> getContinents();
  std::vector<Continent*>::iterator it = continents.begin();
  for (; it != continents.end(); it++)
  {
    Continent* currCont = *it;
    if (currCont-> owner() == player)
    {
//            kdDebug() << ">>>>>>>>>>> Adding bonus for "  << currCont-> name() << endl;
      res += currCont-> getBonus();
    }
  }

  return res;
}

void KGameWindow::changeItem( const QString& text, int id, bool log )
{
  if (id != ID_NO_STATUS_MSG)
  {
      statusBar()-> changeItem(text, id);
  }
  if (log)
  {
    KsirkChatItem* item = new KsirkChatItem(text, 0, 0);
    m_chatDlg->addItem(item);
//     m_chatDlg->addSystemMessage   ( "", text  ) ;
  }
}

void KGameWindow::changeItem( KStringVector& strings, int id, bool log )
{
//  kdDebug() << "KGameWindow::changeItem(KStringVector,int, log)" << log << endl;
  if (strings.begin() == strings.end())
  {
//     kdDebug() << "  nothing " << strings.size() << endl;
    return;
  }
  bool arguing = false;
  QString argument;
  KStringVector::iterator it, it_end;
  it = strings.begin(); it_end = strings.end();
  if (it.curIsStr())
  {
    QString status2Text;
    if (it.curStr() != "")
      argument = i18n(it.curStr());
    else
      argument = "";
    arguing = true;
  }
  KsirkChatItem* item = new KsirkChatItem(0);
  if (it.curIsPix())
  {
    (*item) << it.curPix();
  }
  it++;
  for (; it != it_end; it++)
  {
    if (it.curIsStr())
    {
      if (arguing)
      {
        argument = argument.arg(it.curStr());
      }
      else
      {
        if (it.curStr() != "")
          argument = i18n(it.curStr());
        else
          argument = "";
        arguing = true;
      }
    }
    else
    {
      if (arguing)
      {
        (*item) << argument;
      }
      (*item) << it.curPix();
      arguing = false;
    }
  /*    kdDebug() << "arg-ing " << status2Text << " with " << msgElem << endl;*/
/*      status2Text = status2Text.arg(i18n(msgElem));*/
  }
  if (arguing)
  {
    (*item) << argument;
  }
  if (log)
  {
    m_chatDlg->addItem(item);
  }
  if (id != ID_NO_STATUS_MSG)
  {
      statusBar()-> changeItem(argument, id);
  }
}

void KGameWindow::broadcastChangeItem ( KStringVector& strings, int id, bool log )
{
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
//   kdDebug() << "Broadcasting change item, size=" << strings.size() << endl;
  stream << (Q_UINT32)id << (Q_UINT32)log << (Q_UINT32)strings.size();
  
  /// @TODO finish the port to new KStringVector
//   QString s;
//   strings >> s;
//   stream << GameLogic::GameAutomaton::changeable().idForMsg(s);
//   while (!strings.empty())
//   {
//     strings >> s;
//     kdDebug() << "Pushing string '" << s << "'" << endl;
//     stream << s;
//   }

  
  KStringVector::iterator it, it_end;
  it = strings.begin(); it_end = strings.end();
  if (it != it_end)
  {
    stream << GameLogic::GameAutomaton::changeable().idForMsg(it.curStr());
    it++;
    for (; it != it_end; it++)
    {
      if (it.curIsStr())
      {
//         kdDebug() << "Pushing string '" << it.curStr() << "'" << endl;
        stream << KStringVector::Text << it.curStr();
      }
      else if (it.curIsPix())
      {
        stream << KStringVector::Pixmap << it.curPix();
      }
      else
      {
        kdError() << "Unsuported KStringVector elem type " << endl;
      }
    }
  }
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,ChangeItem);
  changeItem( strings, id, log );
}

void KGameWindow::enterEvent(QEvent* /*ev*/)
{
//   kdDebug() << "KGameWindow::enterEvent()" << endl;
  // Restart the AIs threads
  if ( currentPlayer() )
    if ( (currentPlayer()-> isAI()) && (!currentPlayer()->isVirtual()) && ( !((static_cast<AIPlayer*>(currentPlayer()))-> running())) )
      (static_cast<AIPlayer*>(currentPlayer()))-> start();
          
  // Restart the main game timer
  initTimer();
}

void KGameWindow::leaveEvent(QEvent* /*ev*/)
{
//    kdDebug() << "KGameWindow::leaveEvent()" << endl;
    // Stops the main game timer
//     haltTimer();
    // Stops the AIs threads
    PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
    PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
    for (; it != it_end; it++)
    {
      if (static_cast<Player*>(*it)-> isAI())
      {
          (static_cast<AIPlayer*>(*it))-> stop();
      }
    }

}


/** Return true if the state of the game is the argument; false otherwise */
bool KGameWindow::isMyState(GameLogic::GameAutomaton::GameState state) const
{
    return (GameLogic::GameAutomaton::single().state() == state);
}

/**
  * returns the current state of the game
  */
GameLogic::GameAutomaton::GameState KGameWindow::getState() const
{
    return GameLogic::GameAutomaton::single().state();
}

void KGameWindow::attack(Country& attacker, Country& defender, unsigned int nb)
{
  clearGameActionsToolbar();
  currentPlayer()-> setNbAttack( nb );
  KStringVector messageParts;
  messageParts << I18N_NOOP("%1 attacks %2 from %3 with <font color=\"red\">%4 armies</font>.") 
    << currentPlayer()-> name() 
    << defender.name() 
    << attacker.name() 
    << QString::number(nb);
  broadcastChangeItem(messageParts, ID_STATUS_MSG2);
  

  messageParts.clear();
  if (! (defender.owner()->isAI()))
  {
    if ((m_secondCountry-> nbArmies() > 1)
        && (nb >= 2))
    {
      QPixmap pm(*m_secondCountry->owner()->getFlag()->image(0));

      messageParts <<pm<< I18N_NOOP("%1, you are attacked by <font color=\"red\">%2 armies</font> ; with how many armies do you <font color=\"blue\">defend %3</font> ?") 
        << m_secondCountry->owner()->name() 
        << QString::number(nb)
        << m_secondCountry-> name();
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      stream << m_secondCountry->owner()->name();
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayDefenseButtons);
    }
    else
    {
    QPixmap pmA(*m_firstCountry-> owner()->getFlag()->image(0));
    QPixmap pmD(*m_secondCountry-> owner()->getFlag()->image(0));

    messageParts 
      << I18N_NOOP("Battle between <font color=\"red\">%1</font> (")
      << m_firstCountry-> name()
      << pmA
      << I18N_NOOP("%1) <font color=\"red\">with %2 armies</font> and <font color=\"blue\">%3</font> (")
      << m_firstCountry->owner()->name()
      << QString::number(nb)
      << m_secondCountry-> name()
      << pmD
      << I18N_NOOP("%1) <font color=\"blue\">with %2 armies</font>.") 
      << m_secondCountry->owner()->name()
      << QString::number(1);

      initCombatMovement(m_firstCountry, m_secondCountry);
    }
    broadcastChangeItem(messageParts, ID_NO_STATUS_MSG);
  }
  else
  {
  }
}

void KGameWindow::moveArmies(Country& src, Country& dest, unsigned int nb)
{
//    kdDebug() << "KGameWindow::moveArmies()" << endl;
  if ((src.owner() == currentPlayer())
      && (dest.owner() == currentPlayer())
      && (src.communicateWith(&dest))
      && (src.nbArmies() > nb) )
  {
    QByteArray bufferSrc;
    QDataStream streamSrc(bufferSrc, IO_WriteOnly);
    streamSrc << src.name();
    GameLogic::GameAutomaton::changeable().sendMessage(bufferSrc,FirstCountry);
    
    QByteArray bufferDest;
    QDataStream streamDest(bufferDest, IO_WriteOnly);
    streamDest << src.name();
    GameLogic::GameAutomaton::changeable().sendMessage(bufferDest,SecondCountry);
    
    int toMove = nb;
    while ( toMove >= 10 )
    {
      toMove -= 10;
      slotInvade10();
    }
    while ( toMove >= 5 )
    {
      toMove -= 5;
      slotInvade5();
    }
    while ( toMove >= 1 )
    {
      toMove -= 1;
      slotInvade1();
    }
  }
//    kdDebug() << "OUT KGameWindow::moveArmies()" << endl;
}

bool KGameWindow::isMoveValid(const QPoint& point)
{
  bool res = false;
  KStringVector messageParts;
  Country* secondCountry = clickIn(point); 
  if  ( ( m_firstCountry == 0 ) || ( secondCountry == 0 ) )
  {
    messageParts << I18N_NOOP("There is no country here!");
  }
  else if  ( m_firstCountry->owner() != currentPlayer() )
  {
    messageParts << I18N_NOOP("You are not the owner of the first country: %1 !")
            << m_firstCountry->name();
  }
  else if ( secondCountry->owner() != currentPlayer() )
  {
  messageParts << I18N_NOOP("You are not the owner of the second country: %1 !")
            << secondCountry->name();
  }
  else if (m_firstCountry == secondCountry)
  {
    messageParts << I18N_NOOP("You are trying to move armies from %1 to itself !")
                << m_firstCountry->name();
  }
  else if (!m_firstCountry->communicateWith(secondCountry))
  {
    messageParts 
      << I18N_NOOP("%1 is not a neighbour of %2 !") 
      << secondCountry-> name() 
      << m_firstCountry-> name() << " !";
  }
  else 
  {
    messageParts << I18N_NOOP("Moving armies from %1 to %2.") << m_firstCountry->name() 
            << secondCountry->name();
    res = true;
  }
  broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
  return res;    
}

/** sets the current player to be the one pointed by the argument. Makes associated actions:
  * Changes the flag in the status bar,...
  * @return Returns true in case of success; false otherwise.
  */
/**
  * sets the current player to be the first one. Makes associated actions:
  * Changes the flag in the status bar,...
  * @return Returns 0 in case of success; non-zero otherwise.
  */
int KGameWindow::setCurrentPlayerToFirst()
{
//   kdDebug() << "KGameWindow::setCurrentPlayerToFirst()" << endl;
  if (    ( currentPlayer() ) &&
            ( currentPlayer()-> isAI()) && ( static_cast<AIPlayer *>(currentPlayer())-> running() ) )
        static_cast<AIPlayer *>(currentPlayer())-> stop();

  GameLogic::GameAutomaton::changeable().currentPlayer((Player*)(*GameLogic::GameAutomaton::changeable().playerList()->begin()));

  if ( currentPlayer() && currentPlayer()-> isAI()  && (!currentPlayer()->isVirtual()) )
      if ( ! ( static_cast<AIPlayer *>(currentPlayer())-> running()) )
          static_cast<AIPlayer *>(currentPlayer())-> start();
//    kdDebug() << "OUT KGameWindow::setCurrentPlayerToFirst()" << endl;
  m_frame->setFocus();
  return 0;
}


/** sets the current player to be the next one in the list. Makes the associated actions :
  * Changes the flag in the status bar,...
  * @return Returns 0 in case of success; non-zero otherwise. For example, it returns 1 the current player was the last one
  */
int KGameWindow::setCurrentPlayerToNext(bool restartRunningAIs)
{
  int looped(0);
//   kdDebug() << "KGameWindow::setCurrentPlayerToNext()" << endl;
  if ( currentPlayer() && ( currentPlayer()-> isAI())  && ( static_cast<AIPlayer *>(currentPlayer())-> running() ) )
      static_cast<AIPlayer *>(currentPlayer())-> stop();
  
  PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
  PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
  for (;it != it_end; it++)
  {
    if (*it == currentPlayer())
    {
      it++;
      break;
    }
  }
  if (it == it_end)
  {
      setCurrentPlayerToFirst();
      looped = 1;
  }
  else
  {
    GameLogic::GameAutomaton::changeable().currentPlayer((Player*)(*it));
  }

  if ( restartRunningAIs && currentPlayer() && currentPlayer()-> isAI() && (!currentPlayer()->isVirtual()) )
  {
    if ( ! (static_cast< AIPlayer* >(currentPlayer())-> running()) )
    {
      static_cast< AIPlayer* >(currentPlayer())-> start();
    }
  }

//   kdDebug() << "New current player is " << currentPlayer()->name() << " ; return value is " << looped << endl;
  return looped;
}

void KGameWindow::countriesDistribution()
{
//   kdDebug() << "KGameWindow::countriesDistribution" << endl;
  unsigned int initialNbArmies;
  std::list< int > vect;
  std::map<QString,unsigned int> distributedCountriesNumberMap;
  PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
  initialNbArmies = ((Player*)(*GameLogic::GameAutomaton::changeable().playerList()->begin()))->getNbAvailArmies();
  PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
  for (; it != it_end; it++)
  {
    distributedCountriesNumberMap[(*it)-> name()] = 0;
  }
  // creates a vector containing the numbers of the countries
  for (unsigned int i = 0; i < m_theWorld->getNbCountries()  ; i++) vect.push_back(i);
  
  // do while the vector not empty (will distribute one country each turn and 
  // remove its number from the vector)
  while (vect.size())
  {
    // chooses randomly a position in the remaining countries vector
    int h = Dice::roll(vect.size()) - 1;
    
    // moves an iterator up to the position choosed
    std::list< int >::iterator it = vect.begin();
    for (int itPos = 0; itPos < h-1; itPos++) it++;
    
    // affect the country that have the number at this position
//     kdDebug() << "Setting owner of " << (m_theWorld-> getCountries().at(*it)->name()) << " to " << currentPlayer()->name() << endl;
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    stream << (m_theWorld-> getCountries().at(*it)->name()) << currentPlayer()->name();
    distributedCountriesNumberMap[currentPlayer()-> name()] = distributedCountriesNumberMap[currentPlayer()-> name()]+1;
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,CountryOwner);
    setCurrentPlayerToNext(false);
    
    // removes the choosen country number from the vector, thus reducing its size
    vect.erase(it);
  }
  it = GameLogic::GameAutomaton::changeable().playerList()->begin();
  it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
  for (; it != it_end; it++)
  {
    GameLogic::GameAutomaton::changeable().playerNamed((*it)-> name())->decrNbAvailArmies(distributedCountriesNumberMap[(*it)-> name()]);
    GameLogic::GameAutomaton::changeable().playerNamed((*it)-> name())->incrNbCountries(distributedCountriesNumberMap[(*it)-> name()]);
  }
//   kdDebug() << "All countries are now distributed." << endl;
  QString nextPlayerName = (*GameLogic::GameAutomaton::changeable().playerList()->begin())-> name();
  m_nbAvailArmies = initialNbArmies - distributedCountriesNumberMap[nextPlayerName];
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  stream << (Q_UINT32)m_nbAvailArmies;
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,KGameWinAvailArmies);
  kdDebug() << "  Setting status " << nextPlayerName << " / " << m_nbAvailArmies << endl;
  QPixmap pm(*GameLogic::GameAutomaton::changeable().playerNamed(nextPlayerName)->getFlag()->image(0));
  KStringVector messageParts;
  messageParts 
    << pm
    << I18N_NOOP("%1 : %2 armies to place")
    << nextPlayerName 
    <<  QString::number( initialNbArmies - distributedCountriesNumberMap[nextPlayerName]);
  kdDebug() << "Message parts size= " << messageParts.size() << endl;
  broadcastChangeItem(messageParts, ID_STATUS_MSG2);
  
  GameLogic::GameAutomaton::changeable().state(GameLogic::GameAutomaton::INTERLUDE);
}

bool KGameWindow::terminateAttackSequence()
{
  m_fighters.hideAndRemoveAll();
  m_movingFighters.hideAndRemoveAll();
  m_animFighters.hideAndRemoveAll();
  m_animExplodings.hideAndRemoveAll();
//        kdDebug() << "Termine Combat 2" << endl;
//        kdDebug() << "Termine Combat 3 FIN" << endl;
  toolBar("gameActionsToolBar")-> show();
  return attackEnd();
}

void KGameWindow::initTimer()
{
    if (m_frame != 0)    
        m_frame-> initTimer();
}

void KGameWindow::haltTimer()
{
    if (m_frame != 0)
        m_frame-> haltTimer();
}

bool KGameWindow::attacker(const QPoint& point)
{
  Country* clickedCountry = clickIn(point);
  KStringVector messageParts;
  if (clickedCountry == 0)
  {
    messageParts << I18N_NOOP("<font color=\"orange\">No country here !</font>");
    broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
    displayNormalGameButtons();
    return false;
  }
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  stream << clickedCountry->name();
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,FirstCountry);
  QByteArray buffer2;
  QDataStream stream2(buffer2, IO_WriteOnly);
  stream2 << "";
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,SecondCountry);
  
  if (clickedCountry-> owner() != currentPlayer())
  {
    messageParts << I18N_NOOP("<font color=\"orange\">You are not the owner of %1 !</font>")  << clickedCountry-> name();
    displayNormalGameButtons();
    broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
    return false;
  }
  else if (clickedCountry-> nbArmies() <= currentPlayer()-> getNbAttack())
  {
    messageParts << I18N_NOOP("<font color=\"orange\">There is only %1 armies in %2 !</font>") 
      << QString::number(clickedCountry-> nbArmies())
      << clickedCountry-> name();
    displayNormalGameButtons();
    broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
    return false;
  }
  else
  {
    QPixmap pm(*currentPlayer()->getFlag()->image(0));
    messageParts
      << pm
      << I18N_NOOP("%1 attacks from %2 with <font color=\"red\">%3 armies</font>") 
      << currentPlayer()-> name()
      << clickedCountry-> name()
      << QString::number(currentPlayer()-> getNbAttack());
    broadcastChangeItem(messageParts, ID_STATUS_MSG2);
    return true;
  }
}

unsigned int KGameWindow::attacked(const QPoint& point)
{
//  if (currentPlayer()-> isAI()) return 3;
        
  unsigned int res = 0;
  Country* secondCountry = clickIn(point);
  m_secondCountry = secondCountry;
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  if (secondCountry != 0)
  {
    stream << secondCountry->name();
  }
  else
  {
    stream << QString("");
  }
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,SecondCountry);

  KStringVector messageParts;

  if (!secondCountry || !secondCountry-> owner()) 
  {
    messageParts << I18N_NOOP("Invalid attacked country.");
    displayNormalGameButtons();
  }
  else if (m_firstCountry == secondCountry)
  {
    messageParts << I18N_NOOP("You are trying to attack %1 from itself !") << m_firstCountry-> name();
    displayNormalGameButtons();
  }
  else if (!m_firstCountry-> communicateWith(secondCountry))
  {
    messageParts << I18N_NOOP("%1 is not a neighbour of %2 !") << secondCountry-> name() << m_firstCountry-> name();
    displayNormalGameButtons();
  }
  else if (m_firstCountry-> owner() == secondCountry-> owner())
  {
    messageParts << I18N_NOOP("%1! You cannot attack %2! It's yours!") << currentPlayer()-> name()
            << secondCountry-> name();
    displayNormalGameButtons();
  }
  else if (m_firstCountry-> owner() != currentPlayer()) 
  {
    messageParts << I18N_NOOP("%1 ! You are not the owner of %2!") << currentPlayer()-> name() << m_firstCountry-> name();
    displayNormalGameButtons();
  }
  else if ( (m_firstCountry == NULL) || (secondCountry == NULL)
          || (m_firstCountry-> owner() != currentPlayer()) )
  {
    messageParts << I18N_NOOP("Nothing to attack !");
    displayNormalGameButtons();
  }
  else if ((secondCountry-> nbArmies() > 1)
      && (currentPlayer()-> getNbAttack() >= 2))
  {
    messageParts
      << I18N_NOOP("%1, with how many armies do you defend %2 ?") 
      << secondCountry->owner()-> name()
      << secondCountry-> name();
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    stream << secondCountry->owner()->name();
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayDefenseButtons);
    res = 1;
  }
  else
  {
/*    secondCountry-> owner()-> setNbDefense(1);
    messageParts << I18N_NOOP("Battle between %1 with %2 armies and %3 with %4 armies.") 
      << m_firstCountry-> name()
      << QString::number(currentPlayer()-> getNbAttack())
      << secondCountry-> name()
      << QString::number(1);*/
    messageParts << I18N_NOOP("");
    res = 2;
  }
  broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
  return res;
}

void KGameWindow::firstCountryAt(const QPoint& point)
{
  if (clickIn(point))
  {
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    stream << clickIn(point)->name();
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,FirstCountry);
  }
}

void KGameWindow::secondCountryAt(const QPoint& point)
{
  if (clickIn(point))
  {
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    stream << clickIn(point)->name();
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,SecondCountry);
  }
}

bool KGameWindow::playerPutsArmy(const QPoint& point, bool removable)
{
  kdDebug() << "KGameWindow::playerPutsArmy" << endl;
  Country* clickedCountry = clickIn(point);

  if ( (clickedCountry) )
  {
    kdDebug() << "clickedCountry name=" << clickedCountry->name()  << endl;
    kdDebug() << "clickedCountry owner=" << clickedCountry-> owner()->name() << endl;
    kdDebug() << "currentPlayer=" << currentPlayer()->name() << endl;
    kdDebug() << "nbAvailArmies=" << currentPlayer()->getNbAvailArmies() << endl;
    unsigned int nbAvailArmies = currentPlayer()->getNbAvailArmies();
    if (
          (clickedCountry-> owner() == currentPlayer()) &&
          (nbAvailArmies > 0))
    {
      nbAvailArmies--;
      currentPlayer()-> setNbAvailArmies(nbAvailArmies);
      kdDebug() << "owner new available armies=" << nbAvailArmies << endl;
      if (removable) clickedCountry-> incrNbAddedArmies();
      clickedCountry-> incrNbArmies();
      clickedCountry-> incrNbAddedArmies();
      clickedCountry-> createArmiesSprites(m_backGnd);
      QPixmap pm(*currentPlayer()->getFlag()->image(0));
      KStringVector messageParts;
      messageParts 
        << pm 
        << I18N_NOOP("%1 : %2 armies to place") 
        << currentPlayer()-> name()
        << QString::number(nbAvailArmies);
      broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);

      if (GameLogic::GameAutomaton::changeable().isAdmin())
      {
        QByteArray buffer;
        QDataStream stream(buffer, IO_WriteOnly);
        stream << currentPlayer()->id();
        GameLogic::GameAutomaton::changeable().sendMessage(buffer,CheckGoal);
        
      }
    }
  }
  return false;
}

bool KGameWindow::playerPutsInitialArmy(const QPoint& point)
{
  {
    kdDebug() << "KGameWindow::playerPutsInitialArmy" << endl;
    Country* clickedCountry = clickIn(point);
    
    if ( (clickedCountry) )
    {
      kdDebug() << "clickedCountry name=" << clickedCountry->name()  << endl;
      kdDebug() << "clickedCountry owner=" << clickedCountry-> owner()->name() << endl;
      kdDebug() << "currentPlayer=" << currentPlayer()->name() << endl;
      kdDebug() << "m_nbAvailArmies=" << m_nbAvailArmies << endl;
      
      if (
           (clickedCountry-> owner() == currentPlayer()) &&
           (m_nbAvailArmies > 0))
      {
        m_nbAvailArmies--;
        bool last = (m_nbAvailArmies == 0);
        unsigned int currentAvailArmiesNumber = m_nbAvailArmies;
        currentPlayer()-> setNbAvailArmies(currentAvailArmiesNumber);
        kdDebug() << "owner new available armies=" << m_nbAvailArmies << endl;
        clickedCountry-> incrNbArmies();
        clickedCountry-> incrNbAddedArmies();
        clickedCountry-> createArmiesSprites(m_backGnd);
        if ( last )
        {
          PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
          PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
          for (;it != it_end; it++)
          {
            if (*it == currentPlayer())
            {
              it++;
              break;
            }
          }
          if (it != it_end)
          {
            QPixmap pm(*((Player*)(*it))->getFlag()->image(0));

            KStringVector messageParts;
            messageParts 
              << pm 
              << I18N_NOOP("%1 : %2 armies to place") << ((Player*)(*it))-> name()
              << QString::number(((Player*)(*it))-> getNbAvailArmies());
            broadcastChangeItem(messageParts, ID_STATUS_MSG2);
            m_nbAvailArmies = ((Player*)(*it))-> getNbAvailArmies();
            QByteArray buffer;
            QDataStream stream(buffer, IO_WriteOnly);
            stream << (Q_UINT32)m_nbAvailArmies;
            GameLogic::GameAutomaton::changeable().sendMessage(buffer,KGameWinAvailArmies);
          }
          if (GameLogic::GameAutomaton::changeable().isAdmin())
          {
            return setCurrentPlayerToNext();
          }
          else
          {
            return false;
          }
        }
        else
        {
          QPixmap pm(*currentPlayer()->getFlag()->image(0));
          KStringVector messageParts;
          messageParts << pm << I18N_NOOP("%1 : %2 armies to place") 
            << currentPlayer()-> name()
            << QString::number(m_nbAvailArmies);
          changeItem(messageParts, ID_STATUS_MSG2, false);
        }
      }
    }
    return false;
  }
}

bool KGameWindow::playerRemovesArmy(const QPoint& point)
{
  kdDebug() << "KGameWindow::playerRemovesArmy" << endl;
  
  Country *clickedCountry = clickIn(point);
  kdDebug() << "  currentPlayer=" << currentPlayer()->name() << endl;
  if (clickedCountry == 0)
  {
    return false;
  }
  kdDebug() << "  owner=" << clickedCountry-> owner()->name() << endl;
  kdDebug() << "  nbArmies=" << clickedCountry->nbArmies() << endl;
  kdDebug() << "  nbAddedArmies=" << clickedCountry->nbAddedArmies() << endl;
  if ( clickedCountry
      && ( clickedCountry-> owner() == currentPlayer() )
      && ( clickedCountry-> nbArmies() > 1)
      && ( clickedCountry-> nbAddedArmies() >0 ) )
  {
    unsigned int newNbAvailArmies = currentPlayer()-> getNbAvailArmies() + 1;
    if ( GameLogic::GameAutomaton::changeable().isAdmin() )
    {
      currentPlayer()-> incrNbAvailArmies();
      QPixmap pm(*currentPlayer()->getFlag()->image(0));
      KStringVector messageParts;
      messageParts <<pm<< I18N_NOOP("%1 : %2 armies to place") << currentPlayer()-> name() 
        << QString::number(newNbAvailArmies);
      broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
    }
    clickedCountry-> decrNbAddedArmies();
    clickedCountry-> decrNbArmies();
    clickedCountry-> createArmiesSprites(m_backGnd);
  }
  return true;
}

/**
  * @brief setups window for recycling
  */
void KGameWindow::initRecycling()
{
  kdDebug() << "Initiating recycling" << endl;
  setCurrentPlayerToFirst();
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayRecyclingButtons);
  
  KStringVector messageParts;
  messageParts << I18N_NOOP("Exchange armies again or continue ?");
  broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
}

void KGameWindow::clear()
{
  kdDebug() << "1" << endl;
  m_nbMovedArmies = 0;
  kdDebug() << "2" << endl;
  m_firstCountry = m_secondCountry = 0;
  kdDebug() << "3" << endl;
  NKD = NKA = 0;
  kdDebug() << "4" << endl;
  m_movingCannons.moveAllToDestinationNow(true);
  kdDebug() << "5" << endl;
  m_movingCannons.hideAndRemoveAll();
  kdDebug() << "6" << endl;
  m_movingCavalrymen.moveAllToDestinationNow(true);
  kdDebug() << "7" << endl;
  m_movingCavalrymen.hideAndRemoveAll();
  kdDebug() << "8" << endl;
  m_movingInfantrymen.moveAllToDestinationNow(true);
  kdDebug() << "9" << endl;
  m_movingInfantrymen.hideAndRemoveAll();
  kdDebug() << "10" << endl;
  m_movingFighters.moveAllToDestinationNow(true);
  kdDebug() << "11" << endl;
  m_movingFighters.hideAndRemoveAll();
  kdDebug() << "12" << endl;
  m_animFighters.hideAndRemoveAll();
  kdDebug() << "13" << endl;
  m_animExplodings.hideAndRemoveAll();
  kdDebug() << "14" << endl;
  m_fighters.hideAndRemoveAll();
  kdDebug() << "15" << endl;
}

bool KGameWindow::nextPlayerRecycling()
{
  kdDebug() << "nextPlayerRecycling" << endl;
  if ( currentPlayer() && currentPlayer()-> getNbAvailArmies() > 0 )
  {
    QMessageBox::information(0, "KsirK", i18n("You must distribute\nall your armies"));
    return false;
  }
  else
  {
    if (setCurrentPlayerToNext())
    {
      initRecycling();
      return true;
    }
    else
    {
      KStringVector messageParts;
      QByteArray buffer;
      QDataStream stream(buffer, IO_WriteOnly);
      GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNextPlayerButton);
      QPixmap pm(*currentPlayer()->getFlag()->image(0));
      messageParts <<pm<< I18N_NOOP("%1 : %2 armies to place") << currentPlayer()-> name() 
        << QString::number(currentPlayer()-> getNbAvailArmies());
      broadcastChangeItem(messageParts, ID_STATUS_MSG2);
      return false;
    }
  }
}

/** 
  * @return if true next state will be NEWARMIES else it will be WAIT
  */
bool KGameWindow::nextPlayerNormal()
{
  kdDebug() << "nextPlayerNormal" << endl;
  if (setCurrentPlayerToNext())
  {
    distributeArmies();
  
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,ShowArmiesToPlace);
    
    clear();
    QByteArray buffer2;
    QDataStream stream2(buffer2, IO_WriteOnly);
    GameLogic::GameAutomaton::changeable().sendMessage(buffer2,DisplayNextPlayerButton);
    return true;
  }
  else
  {
    QPixmap pm(*currentPlayer()->getFlag()->image(0));
    KStringVector messageParts;
    messageParts 
      << pm
      << I18N_NOOP("%1, it's up to you.") << currentPlayer()->name();
    broadcastChangeItem(messageParts, ID_STATUS_MSG2);
    clear();
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNormalGameButtons);
    return false;
  }
}

void KGameWindow::attack(unsigned int nb)
{
  displayCancelButton();
  currentPlayer()-> setNbAttack(nb);
  KStringVector messageParts;
  messageParts << I18N_NOOP("Attack with %1 armies : Designate the belligerants") 
    << QString::number(nb);
  broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
}

void KGameWindow::defense(unsigned int nb)
{
  clearGameActionsToolbar();
  m_secondCountry-> owner()-> setNbDefense(nb);
  KStringVector messageParts;
  
  QPixmap pmA(*m_firstCountry-> owner()->getFlag()->image(0));
  QPixmap pmD(*m_secondCountry-> owner()->getFlag()->image(0));

  messageParts 
    << I18N_NOOP("Battle between <font color=\"red\">%1</font> (")
    << m_firstCountry-> name()
    << pmA
    << I18N_NOOP("%1) <font color=\"red\">with %2 armies</font> and <font color=\"blue\">%3</font> (")
    << m_firstCountry->owner()->name()
    << QString::number(currentPlayer()-> getNbAttack())
    << m_secondCountry-> name()
    << pmD
    << I18N_NOOP("%1) <font color=\"blue\">with %2 armies</font>.") 
    << m_secondCountry->owner()->name()
    << QString::number(nb);

  broadcastChangeItem(messageParts, ID_NO_STATUS_MSG);
    
  if (m_firstCountry && m_firstCountry-> owner() && m_firstCountry-> owner()-> getFlag())
      m_barFlagButton-> setPixmap(*(m_firstCountry-> owner()->getFlag()-> image()));
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,InitCombatMovement);
  GameLogic::GameAutomaton::changeable().state(GameLogic::GameAutomaton::FIGHT_BRING);
}

int KGameWindow::nbMovedArmies()
{
  return m_nbMovedArmies;
}

void KGameWindow::incrNbMovedArmies(unsigned int nb)
{
  m_nbMovedArmies += nb;
}

void KGameWindow::decrNbMovedArmies(unsigned int nb)
{
  m_nbMovedArmies -= nb;
}

bool KGameWindow::invade(unsigned int nb )
{
  bool res = initArmiesMovement(nb, m_firstCountry, m_secondCountry);
  kdDebug() << "invade("<<nb<<") returns " << res << endl;
  return res;
}

bool KGameWindow::retreat(unsigned int nb)
{
    if (m_nbMovedArmies >= int(nb))
      return initArmiesMovement(nb, m_secondCountry, m_firstCountry);
    else
    {
      KStringVector messageParts;
      messageParts << I18N_NOOP("<font color=\"orange\">Cannot remove %1 armies from %2</font>: %3 maximum.") 
        << QString::number(nb)
        << m_secondCountry->name() 
        << QString::number(m_nbMovedArmies);
      broadcastChangeItem(messageParts, ID_STATUS_MSG2, false);
      return false;
    }
}

void KGameWindow::invasionFinished()
{
  displayNormalGameButtons();
  KStringVector messageParts;

  QPixmap pm(*currentPlayer()->getFlag()->image(0));
  messageParts 
    << pm 
    << I18N_NOOP("%1, it's up to you.") << currentPlayer()->name();
  broadcastChangeItem(messageParts, ID_STATUS_MSG2);
}
        
void KGameWindow::shiftFinished()
{
  displayNormalGameButtons();
  QPixmap pm(*currentPlayer()->getFlag()->image(0));
  KStringVector messageParts;
  messageParts 
    << pm 
    << I18N_NOOP("%1, it's up to you.") << currentPlayer()->name();
  broadcastChangeItem(messageParts, ID_STATUS_MSG2);
  slotNextPlayer();
}

void KGameWindow::cancelAction()
{
  kdDebug() << "KGameWindow::cancelAction" << endl;
  displayNormalGameButtons();
  KStringVector messageParts;
  QPixmap pm(*currentPlayer()->getFlag()->image(0));
  messageParts 
    << pm 
    << I18N_NOOP("%1, it's up to you.") << currentPlayer()->name();
  broadcastChangeItem(messageParts, ID_STATUS_MSG2);
}

void KGameWindow::cancelShiftSource()
{
//        clearGameActionsToolbar();
  if (m_nbMovedArmies < 0)
  {
    m_firstCountry-> decrNbArmies(m_nbMovedArmies);
    m_secondCountry-> incrNbArmies(m_nbMovedArmies);
    m_firstCountry-> createArmiesSprites(m_backGnd);
    m_secondCountry-> createArmiesSprites(m_backGnd);
    m_nbMovedArmies = 0;
  }
  if (m_nbMovedArmies > 0)
  {
    m_firstCountry-> incrNbArmies(m_nbMovedArmies);
    m_secondCountry-> decrNbArmies(m_nbMovedArmies);
    m_firstCountry-> createArmiesSprites(m_backGnd);
    m_secondCountry-> createArmiesSprites(m_backGnd);
    m_nbMovedArmies = 0;
  }
}

bool KGameWindow::actionNewGame()
{
//   kdDebug() << "KGameWindow::actionNewGame()" << endl;
  if  ( ( GameLogic::GameAutomaton::changeable().playerList()->count() == 0 ) ||
  ( isMyState(GameLogic::GameAutomaton::GAME_OVER)  ) ||
        (KMessageBox::warningContinueCancel(this,i18n("Do you really want to end your current game and start a new one ?"),i18n("New game confirmation"),
                                            i18n("Yes"), QString::null, 0) == KMessageBox::Continue ) )
  {
    // @todo if new game is canceled, removed buttons should be displayed again
//    clearGameActionsToolbar();
    haltTimer();
/*    if (!(GameLogic::GameAutomaton::changeable().playerList()->isEmpty()))
    {
      GameLogic::GameAutomaton::changeable().playerList()->clear();
      GameLogic::GameAutomaton::changeable().currentPlayer(0);
      kdDebug() << "  playerList size = " << GameLogic::GameAutomaton::changeable().playerList()->count() << endl;
    }
    theWorld()->reset();*/
    
    return (setupPlayers());
  }
  return false;
}

void KGameWindow::saveXml(std::ostream& xmlStream)
{
  xmlStream << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" << std::endl;
  xmlStream << "<ksirkSavedGame formatVersion=\"" << SAVE_GAME_FILE_FORMAT_VERSION << "\" >" << std::endl;
  xmlStream << "<game skin=\"" << GameAutomaton::single().skin() << "\" state=\"" << GameAutomaton::single().state() << "\" >" << std::endl;
  m_theWorld->saveXml(xmlStream);
  xmlStream << "<players nb=\""<<GameLogic::GameAutomaton::changeable().playerList()->count()<<"\">" << std::endl;
  PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->begin();
  PlayersArray::iterator it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
  for (; it != it_end; it++)
  {
    static_cast<Player*>(*it)->saveXml(xmlStream);
  }
  xmlStream << "</players>" << std::endl;
  Player* player = GameLogic::GameAutomaton::changeable().currentPlayer();
  if (player)
  {
    QString name = player->name().utf8();
    name = name.replace("&","&amp;");
    name = name.replace("<","&lt;");
    name = name.replace(">","&gt;");
    xmlStream << "<currentPlayer name=\"" << name << "\" />" << std::endl;
  }
  else
    xmlStream << "<currentPlayer name=\"\" />" << std::endl;
  xmlStream << "<goals>\n";
  it = GameLogic::GameAutomaton::changeable().playerList()->begin();
  it_end = GameLogic::GameAutomaton::changeable().playerList()->end();
  for (; it != it_end; it++)
  {
    static_cast<Player*>(*it)->goal()->saveXml(xmlStream);
  }
  xmlStream << "</goals>\n";
  xmlStream << "</game>" << std::endl;
  xmlStream << "</ksirkSavedGame>" << std::endl;
}

/**
  * @brief Accessor to the world
  * @return A pointer to the world
  */
ONU* KGameWindow::theWorld()
{
  return m_theWorld;
}

/**
  * @brief Adds a player
  */
void KGameWindow::addPlayer(const QString& playerName, 
      unsigned int nbAvailArmies, 
      unsigned int nbCountries, 
      const QString& nationName, 
      bool isAI,
      const QString& password,
      unsigned int nbAttack,
      unsigned int nbDefense)
{
//   kdDebug() << "Adding player (AI: " << isAI << ")" << endl;
  Player* p = 0;
  if (isAI)
  {
    AIPlayer *aiplayer = new AIColsonPlayer(playerName, nbAvailArmies,
                                      m_theWorld-> nationNamed(nationName), *GameLogic::GameAutomaton::changeable().playerList(), m_theWorld, &GameLogic::GameAutomaton::changeable());
    GameAutomaton::changeable().addPlayer(aiplayer);
//     kdDebug() << "Created AI player " << aiplayer->name() << endl;
    aiplayer->stop();
    aiplayer->setNbCountries(nbCountries);
    aiplayer->setNbAvailArmies(nbAvailArmies);
    aiplayer->setNbAttack(nbAttack);
    aiplayer->setNbDefense(nbDefense);
    aiplayer->setPassword(password);
//     kdDebug() << "Calling AI player createIO" << endl;
    GameAutomaton::changeable().createIO(aiplayer, KGameIO::IOMode(AIPLAYERIO));
    p = aiplayer;
  }
  else
  {
    Player *player = new Player(playerName, nbAvailArmies, m_theWorld-> nationNamed(nationName));
    GameAutomaton::changeable().addPlayer(player);
//     kdDebug() << "Created player " << player->name() << endl;
    player->setNbCountries(nbCountries);
    player->setNbAvailArmies(nbAvailArmies);
    player->setNbAttack(nbAttack);
    player->setNbDefense(nbDefense);
    player->setPassword(password);
//     kdDebug() << "Calling player createIO" << endl;
    GameAutomaton::changeable().createIO(player,KGameIO::IOMode(KGameIO::MouseIO));
    p = player;
    m_chatDlg->setFromPlayer(p);
  }
  
}

std::map< QString, QString > KGameWindow::nationsList()
{
  std::map< QString, QString >  res;
  
  std::vector<Nationality*>& nationsList = m_theWorld->getNationalities();
//   kdDebug() << "There is " << nationsList.count() << " nations" << endl;
  std::vector<Nationality*>::iterator nationsIt = nationsList.begin();
  Nationality* nation; 
  for (; nationsIt != nationsList.end(); nationsIt++ ) 
  {
//     kdDebug() << "Nation = " << *nationsIt << endl;
    Nationality* nation = *nationsIt; 
    res.insert(std::make_pair(nation->name(),nation->flagFileName()));
  } 
  return res;
}

/** @return true if the given player is the last one ; false otherwise */
bool KGameWindow::isLastPlayer(const Player& player)
{
  if (GameLogic::GameAutomaton::changeable().playerList()->begin() == GameLogic::GameAutomaton::changeable().playerList()->end())
  {
    kdError() << "No player ; should not be able to call isLastPlayer !" << endl;
    exit(1);
  }
  PlayersArray::iterator it = GameLogic::GameAutomaton::changeable().playerList()->end();
  //  it--;
  Player* lastPlayer = static_cast<Player*>(*it);
  return (player == (*lastPlayer));
}

void KGameWindow::actionRecycling()
{
//   kdDebug() << "actionRecycling" << endl;
  setCurrentPlayerToFirst();
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNextPlayerButton);
  KStringVector messageParts;
  QPixmap pm(*currentPlayer()->getFlag()->image(0));
  messageParts 
    << pm 
    << I18N_NOOP("%1, please change your distributions.") 
    << currentPlayer()->name();
  broadcastChangeItem(messageParts, ID_STATUS_MSG2);
  initTimer();
}

void KGameWindow::actionRecyclingFinished()
{
//   kdDebug() << "actionRecyclingFinished" << endl;
  if (GameLogic::GameAutomaton::changeable().isAdmin())
  {
    for (unsigned int i = 0; i < m_theWorld->getNbCountries(); i++) 
    {
      m_theWorld-> getCountries().at(i)-> nbAddedArmies(0);
    }
    QPixmap pm(*currentPlayer()->getFlag()->image(0));
    KStringVector messageParts;
    messageParts 
      << pm
      << I18N_NOOP("%1, it's up to you.") << currentPlayer()->name();
    broadcastChangeItem(messageParts, ID_STATUS_MSG2);
    QByteArray buffer;
    QDataStream stream(buffer, IO_WriteOnly);
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNormalGameButtons);
    GameLogic::GameAutomaton::changeable().state(GameLogic::GameAutomaton::WAIT);
  }
  //  initTimer();
}

void KGameWindow::finishMoves()
{
  m_movingCannons.moveAllToDestinationNow();
  m_movingCavalrymen.moveAllToDestinationNow();
  m_movingInfantrymen.moveAllToDestinationNow();
  m_movingFighters.moveAllToDestinationNow();
}

void KGameWindow::sendCountries()
{
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  
  m_theWorld->sendCountries(stream);
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,SetupCountries);
}

void KGameWindow::displayButtonsForState(GameAutomaton::GameState state)
{
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  switch (state)
  {
  case GameLogic::GameAutomaton::WAIT:;
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNormalGameButtons);
    break;
  case GameLogic::GameAutomaton::WAIT_RECYCLING:;
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNextPlayerButton);
    break;
  case GameLogic::GameAutomaton::NEWARMIES:;
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNextPlayerButton);
    break;
  case GameLogic::GameAutomaton::INIT:;
    break;
  case GameLogic::GameAutomaton::INTERLUDE:;
    break;
  case GameLogic::GameAutomaton::ATTACK:;
    break;
  case GameLogic::GameAutomaton::ATTACK2:;
    break;
  case GameLogic::GameAutomaton::INVADE:;
    break;
  case GameLogic::GameAutomaton::SHIFT1:;
    break;
  case GameLogic::GameAutomaton::SHIFT2:;
    break;
  case GameLogic::GameAutomaton::FIGHT_BRING:;
    break;
  case GameLogic::GameAutomaton::FIGHT_ANIMATE:;
    break;
  case GameLogic::GameAutomaton::FIGHT_BRINGBACK:;
    break;
  case GameLogic::GameAutomaton::WAITDEFENSE:;
    break;
  case GameLogic::GameAutomaton::EXPLOSION_ANIMATE:;
    break;
    
  default: 
    GameLogic::GameAutomaton::changeable().sendMessage(buffer,DisplayNormalGameButtons);
  }
}

void KGameWindow::optionsConfigure()
{
  //An instance of your dialog could be already created and could be cached, 
  //in which case you want to display the cached dialog instead of creating 
  //another one 
  if ( KsirkConfigurationDialog::showDialog( "settings" ) ) 
    return; 
 
  //KConfigDialog didn't find an instance of this dialog, so lets create it : 
  KsirkConfigurationDialog* dialog = new KsirkConfigurationDialog( this, "settings", 
                                             KsirkSettings::self() ); 
  

  dialog->show();
}

void KGameWindow::explain()
{
  KStringVector message0Parts;
  message0Parts << "<b>KsirK quick Introduction</b>";
  broadcastChangeItem(message0Parts, ID_NO_STATUS_MSG);

  KStringVector message1Parts;
  message1Parts << I18N_NOOP("All commands are issued through changing toolbar buttons and drag & drop. Hit...");
  broadcastChangeItem(message1Parts, ID_NO_STATUS_MSG);

  QString newGameImageFileName = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/" + CM_NEWGAME);
  if (newGameImageFileName.isNull())
  {
    QMessageBox::critical(0, i18n("Error !"), i18n("Cannot load button image\nProgram cannot continue"));
    exit(2);
  }
  QPixmap newGameButtonPix(newGameImageFileName); 
  KStringVector message2Parts;
  message2Parts << "\t" << newGameButtonPix << I18N_NOOP(" to start a new game;");
  broadcastChangeItem(message2Parts, ID_NO_STATUS_MSG);

  QString joinGameImageFileName = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/" + CM_NEWNETGAME);
  if (joinGameImageFileName.isNull())
  {
    QMessageBox::critical(0, i18n("Error !"), i18n("Cannot load button image\nProgram cannot continue"));
    exit(2);
  }
  QPixmap joinGameButtonPix(joinGameImageFileName); 
  KStringVector message3Parts;
  message3Parts << "\t" << joinGameButtonPix << I18N_NOOP(" to join a network game (starting or reloading); and");
  broadcastChangeItem(message3Parts, ID_NO_STATUS_MSG);

  QString openGameImageFileName = m_dirs-> findResource("appdata", GameAutomaton::changeable().skin() + "/" + CM_OPENGAME);
  if (openGameImageFileName.isNull())
  {
    QMessageBox::critical(0, i18n("Error !"), i18n("Cannot load button image\nProgram cannot continue"));
    exit(2);
  }
  QPixmap openGameButtonPix(openGameImageFileName); 
  KStringVector message4Parts;
  message4Parts << "\t" << openGameButtonPix << I18N_NOOP(" to open a saved game.");
  broadcastChangeItem(message4Parts, ID_NO_STATUS_MSG);

  KStringVector message5Parts;
  message5Parts << I18N_NOOP("And then let the system guide you through messages and tooltips appearing on buttons when hovering above them.");
  broadcastChangeItem(message5Parts, ID_NO_STATUS_MSG);
}



} // closing namespace Ksirk

#include "kgamewin.moc"
