/*************************************************************************************
                          kgamewinslots.cpp 
                   implementation of the KGameWindow class slots
                             -------------------
    begin                : mer jui 11 22:27:28 EDT 2001
    copyright            : (C) 2001-2005 by Gaël de Chalendar
    email                : Gael.de.Chalendar@free.fr
 *************************************************************************************/

/*************************************************************************************
 *                                                                                   *
 *   This program is free software; you can redistribute it and/or modify            *
 *   it under the terms of the GNU General Public License as published by            *
 *   the Free Software Foundation; either version 2 of the License, or               *
 *   (at your option) any later version.                                             *
 *                                                                                   *
 *************************************************************************************/
#define KDE_NO_COMPAT

// application specific includes
#include "kgamewin.h"
#include "backgnd.h"

#include "GameLogic/gameautomaton.h"
#include "GameLogic/country.h"
#include "GameLogic/onu.h"
#include "GameLogic/goal.h"
#include "SaveLoad/ksirkgamexmlloader.h"

// STL include files
#include <fstream>

// include files for QT
#include <qmessagebox.h>
#include <qcursor.h>

// include files for KDE
#include <kfiledialog.h>
#include <klocale.h>
#include <kconfig.h>
#include <kaboutapplication.h>
#include <kdebug.h>
#include <kmessagebox.h>


namespace Ksirk
{
using namespace GameLogic;

void KGameWindow::slotTimerEvent()
{
//   kdDebug() << "slotTimerEvent" << endl;
  QString countryName;
  QPoint mousePosition;
  Country *mouseLocalisation;

  mousePosition = QCursor::pos();
  mousePosition =  m_frame-> mapFromGlobal(mousePosition);
  mousePosition += QPoint(m_frame-> contentsX(), m_frame-> contentsY());
  mouseLocalisation = clickIn(mousePosition);
  countryName = (mouseLocalisation) ? mouseLocalisation->name() : "";

  if (mouseLocalisation)
  {
    if (countryName != "")
    {
      QString status1Text = "";
      const Player* player = mouseLocalisation-> owner();
      if (player)
      {
        status1Text = i18n("%1 belongs to %2")
                        .arg(i18n(countryName))
                        .arg(player->name());
      }

      statusBar()-> changeItem(status1Text, ID_STATUS_MSG);
    }
  }
  else statusBar()-> changeItem("", ID_STATUS_MSG); // Reset
  
  evenementTimer();
}

void KGameWindow::slotLeftButtonDown(const QPoint& point)
{
//   kdDebug() << "slotLeftButtonDown" << endl;
//   if (currentPlayer() && !(currentPlayer()-> isAI()) )
    GameAutomaton::changeable().event("actionLButtonDown", point);
}

void KGameWindow::slotLeftButtonUp(const QPoint& point)
{
//     kdDebug() << "slotLeftButtonUp" << endl;
//     if (currentPlayer() && ! (currentPlayer()-> isAI()) )
    GameAutomaton::changeable().event("actionLButtonUp", point);
}

void KGameWindow::slotRightButtonDown(const QPoint& point)
{
//   if (currentPlayer() && ! (currentPlayer()-> isAI()) )
    GameAutomaton::changeable().event("actionRButtonDown", point);
  return;
}

/** @todo Clean exit with memory freeing */
bool KGameWindow::queryExit()
{
//   kdDebug() << "Writing skin m_config: " << GameAutomaton::changeable().skin() << endl;
  m_config->writeEntry("skin", GameAutomaton::changeable().skin());
  m_config->sync();
  return true;
}

void KGameWindow::slotKey1()
{
  if (    ( isMyState(GameLogic::GameAutomaton::WAITDEFENSE)  ) 
       && ( m_secondCountry ) 
       && ( m_secondCountry->owner())
       && ( !m_secondCountry->owner()->isAI() ) 
       && ( !m_secondCountry->owner()->isVirtual())
     ) 
  {
    slotDefense1();
  }
  else if (    ( isMyState(GameLogic::GameAutomaton::WAIT)  ) 
       && ( !currentPlayer()->isAI() ) 
       && ( !currentPlayer()->isVirtual())
       )
  {
    slotAttack1();
  } 
}

void KGameWindow::slotKey2()
{
  if (    ( isMyState(GameLogic::GameAutomaton::WAITDEFENSE)  ) 
       && ( m_secondCountry ) 
       && ( m_secondCountry->owner())
       && ( !m_secondCountry->owner()->isAI() ) 
       && ( !m_secondCountry->owner()->isVirtual())
     ) 
  {
    slotDefense2();
  }
  else if (    ( isMyState(GameLogic::GameAutomaton::WAIT)  ) 
       && ( !currentPlayer()->isAI() ) 
       && ( !currentPlayer()->isVirtual())
       )
  {
    slotAttack2();
  } 
}

void KGameWindow::slotKey3()
{
  if (    ( isMyState(GameLogic::GameAutomaton::WAIT)  ) 
       && ( !currentPlayer()->isAI() ) 
       && ( !currentPlayer()->isVirtual())
       )
  {
    slotAttack3();
  } 
}

void KGameWindow::slotNewGame()
{
//   kdDebug() << "Slot new game: posting event actionNewGame" << endl;
  QPoint point;
  GameAutomaton::changeable().event("actionNewGame", point);
}

void KGameWindow::slotOpenGame()
{
//   kdDebug() << "Slot open game: posting event actionOpenGame" << endl;
  QPoint point;
  GameAutomaton::changeable().event("actionOpenGame", point);
}

void KGameWindow::slotSaveGame()
{
  if (GameLogic::GameAutomaton::changeable().isAdmin())
  {
    QString fileName = KFileDialog::getSaveFileName (QString::null, "*.xml", this, i18n("KsirK - Save Game")); 
    if (fileName != "")
    {
      std::ofstream ofs(fileName);
      saveXml(ofs);
    }
  }
  else
  {
    KMessageBox::sorry(this, i18n("Only game master can save the game in network playing."),i18n("KsirK - Cannot save !"));
  }
}

void KGameWindow::slotRecycling()
{
  QPoint point;
  GameAutomaton::changeable().event("actionRecycling", point);
}

void KGameWindow::slotRecyclingFinished()
{
  QPoint point;
  GameAutomaton::changeable().event("actionRecyclingFinished", point);
}

void KGameWindow::slotNextPlayer()
{
  QPoint point;
  GameAutomaton::changeable().event("actionNextPlayer", point);
}

void KGameWindow::slotAttack1()
{
  QPoint point;
  GameAutomaton::changeable().event("actionAttack1", point);
}

void KGameWindow::slotAttack2()
{
  QPoint point;
  GameAutomaton::changeable().event("actionAttack2", point);
}

void KGameWindow::slotAttack3()
{
  QPoint point;
  GameAutomaton::changeable().event("actionAttack3", point);
}

void KGameWindow::slotDefense1()
{
  QPoint point;
  GameAutomaton::changeable().event("actionDefense1", point);
}

void KGameWindow::slotDefense2()
{
  QPoint point;
  GameAutomaton::changeable().event("actionDefense2", point);
}

void KGameWindow::slotInvade1()
{
  QPoint point;
  GameAutomaton::changeable().event("actionInvade1", point);
}

void KGameWindow::slotInvade5()
{
  QPoint point;
  GameAutomaton::changeable().event("actionInvade5", point);
}

void KGameWindow::slotInvade10()
{
  QPoint point;
  GameAutomaton::changeable().event("actionInvade10", point);
}

void KGameWindow::slotInvasionFinished()
{
  QPoint point;
  GameAutomaton::changeable().event("actionInvasionFinished", point);
}

void KGameWindow::slotRetreat1()
{
  QPoint point;
  GameAutomaton::changeable().event("actionRetreat1", point);
}

void KGameWindow::slotRetreat5()
{
  QPoint point;
  GameAutomaton::changeable().event("actionRetreat5", point);
}

void KGameWindow::slotRetreat10()
{
  QPoint point;
  GameAutomaton::changeable().event("actionRetreat10", point);
}

void KGameWindow::slotMove()
{
  QPoint point;
  GameAutomaton::changeable().event("actionMove", point);
}

void KGameWindow::slotCancel()
{
  QPoint point;
  GameAutomaton::changeable().event("actionCancel", point);
}

void KGameWindow::slotDumpGameInformations()
{
//   kdDebug() << "Game informations : " << endl;
//    kdDebug() << "  state : " << GameStateNames[getState()] << endl;
//   kdDebug() << "  current player : " 
//       << ((currentPlayer()) ? currentPlayer()-> name() : "nobody") << endl;
  m_theWorld-> communicatesWith_test();
}

void KGameWindow::slotScrollUp()
{
  m_backGnd-> scrollUp();
}

void KGameWindow::slotScrollDown()
{
  m_backGnd-> scrollDown();
}

void KGameWindow::slotScrollLeft()
{
  m_backGnd-> scrollLeft();
}

void KGameWindow::slotScrollRight()
{
  m_backGnd-> scrollRight();
}

void KGameWindow::slotFinishMoves()
{
//   kdDebug() << "slotFinishMoves" << endl;
  QByteArray buffer;
  QDataStream stream(buffer, IO_WriteOnly);
  GameLogic::GameAutomaton::changeable().sendMessage(buffer,FinishMoves);
}

void KGameWindow::slotShowAboutApplication()
{
    //kdDebug() << "Dans mon About !" << endl;

  KAboutApplication kAA(this, 0, true);
  kAA.exec();
}

void KGameWindow::slotJoinNetworkGame() 
{
//   kdDebug() << "slotJoinNetworkGame" << endl;
  QPoint point;
  GameAutomaton::changeable().event("actionJoinNetworkGame", point);
}

void KGameWindow::slotShowGoal()
{
//   kdDebug() << "slotShowGoal" << endl;
  if (!currentPlayer()->isVirtual() && !currentPlayer()->isAI())
  {
    currentPlayer()->goal()->show(GameLogic::Goal::GoalDesc|GameLogic::Goal::GoalAdvance);
  }
}

void KGameWindow::slotChatMessage()
{
  setFocus();
}


} // closing namespace Ksirk
