<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.0">

<!-- ####################################### -->
<!-- ####################################### -->
<!-- Write slideshow html pages -->
<xsl:template match="album" mode="slideshows">
<xsl:variable name="albumAuthor" select="author"/>

<xsl:for-each select="subalbum">

  <xsl:if test="count(photo)">

  <xsl:variable name="subalbumNumber" select="position()"/>
  <xsl:variable name="photoCount" select="count(photo)"/>
  <xsl:document method="html" indent="yes" href="{concat($outputPath, '/subalbum_', string(position()), '_slideshow.html')}">
    <html>
      <head>
        <meta name="generator" content="Album Shaper (c.) Will Stokes"/>
        <meta name="theme" content="{$themeString}" />
	    <meta name="author" content="{$albumAuthor}" />

	    <link rel="stylesheet" href="resources/style.css" type="text/css" />

        <title><xsl:value-of select="name"/></title>

        <script type="text/javascript" src="resources/slideshow.js"></script>
        <script type="text/javascript" src="resources/tooltips.js"></script>
        <script type="text/javascript" language="JavaScript">
         
          //determine the starting image number  
          var url = self.location.href;
          var currentImage = getPhotoNum(url)

          //determine the collection number
          var currentCollection = <xsl:value-of select="$subalbumNumber"/>;

          //determine the numver of photos in the collection
          var numImages = <xsl:value-of select="$photoCount"/>;
          
          //construct an array of descriptions
          var descriptions = new Array(numImages);
          <xsl:for-each select="photo">
            <xsl:variable name="photoDescription" select="description"/>descriptions[<xsl:value-of select="position() - 1"/>] = <![CDATA["]]><xsl:call-template name="JavaScriptString"><xsl:with-param name="string" select="$photoDescription"/></xsl:call-template><![CDATA["]]>;
          </xsl:for-each>
          
        </script>
      </head>
      <body bgcolor="white" text="black" link="#0000FF" vlink="#0000FF" alink="#FF0000">

      <font face='Arial, sans-serif'>
        <center>
          <table border="0" cellpadding="0" cellspacing="0">

<!-- ############################ -->
<!-- ### Top Border           ### -->
<!-- ############################ -->
<tr>
  <td style="background-image: url(resources/topLeft.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/topRight.png);" width="16" height="16"></td>
</tr>

<!-- ##################################### -->
<!-- ### Subalbum Name and Description ### -->
<!-- ##################################### -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td width="600" align="center">

<table border="0"><tr>
<td width="180"><div class="title"><xsl:value-of select="name"/></div></td>
<td><div class="subtitle"><xsl:value-of select="description"/></div></td>
</tr></table>

  </td>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"> </td>
</tr>

<!-- ############################ -->
<!-- ### Photo                ### -->
<!-- ############################ -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>

  <td align="center">
    <table border="0">
      <tr>

        <!-- ####################################### -->
        <!--          Previous Button                -->
        <td valign="middle" align="center">
          <a title="Show previous photo" href="JavaScript:previousImage()">
            <div id="prevImageButton" alt="Show Preview Photo">
              <img src="resources/prev.png" alt="next" border="0"/>
            </div>
          </a>
        </td>
        <!-- ####################################### -->
        <!--             The Photo                   -->
       <td valign="center" align="center">

<!-- Disable expanding to large image in small web exports because they are not included! -->
<xsl:if test="$smallWebExport=0">
  <xsl:text disable-output-escaping="yes"><![CDATA[<a href="JavaScript:expandImage()">]]></xsl:text>
</xsl:if>

<script type="text/javascript" language="JavaScript">
<![CDATA[
document.write("<img alt='current photo' src='img/]]><xsl:value-of select="$subalbumNumber"/><![CDATA[/" + currentImage + "_slideshow.jpg' name='currentPhoto' border='0'>");
]]>
</script>

<xsl:if test="$smallWebExport=0">
<xsl:text disable-output-escaping="yes"><![CDATA[</a>]]></xsl:text>
</xsl:if>

       </td>
        <!-- ####################################### -->
        <!--            Next Button                  -->
        <td valign="middle" align="center">
          <a title="Show next photo" href="JavaScript:nextImage()">
            <div id="nextImageButton">
              <img src="resources/next.png" alt="next" border="0"/>
            </div>
          </a>
        </td>
        <!-- ####################################### -->
      </tr>
    </table>
  </td>

  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
</tr>

<!-- ################################## -->
<!-- ### Control Buttons and Photo Info -->
<!-- ################################## -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td align="center">
    <table border="0">
      <tr>
        <td valign="middle" align="center"><a title="Show first photo" href="JavaScript:firstImage()"><img src="resources/first.png" alt="next" border="0"/></a></td>
        <td valign="middle" align="center" width="170">
          <div class="photoDetails" width="100%" id="photoNum">
            <script type="text/javascript" language="JavaScript"> document.write("Photo " + currentImage + " of "); </script>                 
            <xsl:value-of select="$photoCount"/>
          </div>
        </td>
        <td valign="middle" align="center"><a title="Show last photo" href="JavaScript:lastImage()"><img src="resources/last.png" alt="next" border="0"/></a></td>
      </tr>
    </table>
  </td>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
</tr>

<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td valign="middle" align="center" height="20">

  <table width="450" border="0"><tr><td align="center" valign="middle"><div align="center" class="photoDetails" height="100%"><span id="photoDesc">
     <script type="text/javascript" language="JavaScript">
       if( descriptions[currentImage-1].length > 1 )
         document.write( descriptions[currentImage-1] );
       else
         document.write( "<![CDATA[&nbsp;&nbsp;]]>" );
     </script>                
   </span></div></td></tr></table>

  </td>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
</tr>

<!-- ############################ -->
<!-- ### Horizontal Separator ### -->
<!-- ############################ -->
<tr>
  <td style="background-image: url(resources/leftJoint.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/rightJoint.png);" width="16" height="16"></td>
</tr>

<!-- ######################################### -->
<!-- ### Album Links and Album Shaper Link ### -->
<!-- ######################################### -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>

  <td>
    <table width="100%" border="0"><tr>   

      <td width="64" valign="middle" align="center">      
        <div id="keyboardShortcuts" class="popUpHelp">
          <table cellspacing="4">
            <tr><td class="shortcutLabel">Previous</td><td> </td>
                <td class="shortcutKeys"> <xsl:text disable-output-escaping="yes"><![CDATA[&larr; / &uarr; ]]></xsl:text> </td></tr>
            <tr><td class="shortcutLabel">Next</td><td> </td>
                <td class="shortcutKeys"> <xsl:text disable-output-escaping="yes"><![CDATA[&rarr; / &darr; ]]></xsl:text> </td></tr>
            <tr><td class="shortcutLabel">First</td><td> </td>
                <td class="shortcutKeys">Home</td></tr>
            <tr><td class="shortcutLabel">Last</td><td> </td>
                <td class="shortcutKeys">End</td></tr>
          </table>
        </div>
   
        <img src="resources/shortcuts.png"
             id="keyboardIcon"
             onMouseOver="showTooltip(event, 'keyboardShortcuts')"
             onMouseOut="hideTooltip()"/>
     
        <script type="text/javascript"> 
          document.getElementById("keyboardShortcuts").style.visibility = "hidden"; 
        </script>
        
      </td>

      <td valign="middle" align="right" cellpadding="10">
        <table><tr>
          <td><a href="javascript:location.href='subalbum_{position()}_thumbs.html#'+currentImage">
            <img src="resources/otherLayout.png" border="0"/>
          </a></td>
          <td><div class="pageDetails" valign="middle" align="right">
            <a href="javascript:location.href='subalbum_{position()}_thumbs.html#'+currentImage">
            Thumbnails</a>
          </div></td>
        </tr></table>
      </td>
      
      <td width="30"> </td>

      <td valign="middle" align="left">
        <table><tr>
          <td><a href="Album.html">
            <img src="resources/contents.png" border="0"/>
          </a></td>
          <td><div class="pageDetails" valign="middle" align="right">
            <a href="Album.html">
            Album Index</a>
          </div></td>
        </tr></table>
      </td>

      <td valign="middle" align="center" width="64">
        <a href="http://albumshaper.sf.net" title="Generated by Album Shaper, Slick theme">
          <img src="resources/asLogo.png" border="0"/>
        </a>
      </td>

    </tr></table>
  </td>
  
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
</tr>

<!-- ##################### -->
<!-- ### Bottom Border ### -->
<!-- ##################### -->
<tr>
  <td style="background-image: url(resources/bottomLeft.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/bottomRight.png);" width="16" height="16"></td>
</tr>

          </table>
        </center>
      </font>


        <script type="text/javascript" language="JavaScript">
         showHideButtons();
        </script>


      </body>
    </html>
  </xsl:document>

</xsl:if>

</xsl:for-each>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>
