//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef BACKEND_TOOLS_IMAGETOOLS_H
#define BACKEND_TOOLS_IMAGETOOLS_H

//--------------------
//forward declarations
//--------------------
class QString;
class QImage;
class QPoint;
class QSize;
#include <qcolor.h>

//Transform Codes
typedef enum 
{
  ROTATE_90,    //rotate clockwise 90 degrees
  ROTATE_270,  //rotate counter-clockwise 90 degrees
  FLIP_H,              //flip left-to-right
  FLIP_V,              //flip top-to-bottom
} TRANSFORM_CODE;

///Checks to see if an image is a valid jpg by seeing if the image dimensions can be read
bool isJpeg(const char* filename);

///Computes scale of image dimensions while respecting aspect ratio,
///equivalent to a QImage::scaleMin without actually scaling any image
void calcScaledImageDimensions(int origWidth, int origHeight,
                               int idealWidth, int idealHeight,
                               int& width, int& height);

///Constructs slideshow and thumbnail images for a full sized image.
void constructImages(QString imageName, 
                     QImage& slideshowImage, QImage& thumbnailImage);
                  
///Apply image transformation on image                  
bool transformImage( QString fileIn, QString fileOut, TRANSFORM_CODE transformation );

///Scale image and save copy to disk
bool scaleImage( QString fileIn, QString fileOut, 
                 int newWidth, int newHeight );

///Loaded scaled version of image                 
bool scaleImage(QString fileIn, QImage& scaledImage, int targetWidth, int targetHeight);

///Get image dimensions
bool getImageSize( const char* filename,QSize& size );

///Get image dimensions
bool getImageSize( const char* filename, int& width, int& height );

///find luminance of a rgb color triplet
double RGBtoL(QRgb* rgb);

///Convert a RGB color triplet to HSV
void RGBtoHSV( double r, double g, double b, 
               double *h, double *s, double *v );

///Convert a HSV color triplet to RGB
void HSVtoRGB( double *r, double *g, double *b, 
               double h, double s, double v );

#endif //BACKEND_TOOLS_IMAGETOOLS_H
