//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_DIALOGS_ABOUT_H
#define GUI_DIALOGS_ABOUT_H

#include <qdialog.h>
#include <qhttp.h>

//forward declarations
class QGridLayout;
class QMovie;
class QPixmap;
class QLabel;
class QTabWidget;
class QTextBrowser;
class QPushButton;
class QStringList;

//=====================================
/*! \brief About window widget
 */
//=====================================

//======================
class About : public QDialog
{
Q_OBJECT
//----------------------
public:
  About( int mode, QWidget *parent=0, const char* name=0);
  ~About();
//----------------------
signals:
void closed();
//----------------------
private slots:
 void fileFetched(bool error);
 void reject();
//----------------------
private:
  void closeEvent( QCloseEvent* e);

  QGridLayout* grid;

  QMovie* albumShaperAgingImage;
  QLabel* albumShaperLogo;

  QLabel* progDesc;
  QLabel* progURL;

  QTabWidget* tabWidget;

  QTextBrowser* credits;
  QTextBrowser* history;
  QTextBrowser* newImprovements;
  QTextBrowser* upcomingFeatures;

  ///Close button
  QPushButton* closeButton;

  QStringList* releases;

  //http object for getting urls
  QHttp http;

  //current get action mode
  int getMode;

  //determines which tab to be displayed by default
  int displayMode;
//----------------------
};
//======================

#endif //GUI_DIALOGS_ABOUT_H
