//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "framing.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString Framing::filename()
{
  return QString("%1/framing.html").arg(TEMP_DIR);
}
//==============================================
void Framing::generateHTML(QTextStream::Encoding type, QString charSet)
{
  QString ctrlKey;
#if defined(Q_OS_MACX)
  ctrlKey = "Command";
#else
  ctrlKey = "Ctrl";
#endif
  
  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    stream << "<table cellpadding='4'><tr>\n";
    stream << "<td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "<td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << HelpWindow::tr("Framing") << "</font></td>\n";
    stream << "</tr></table>\n";

    stream << "<font face='Arial, sans-serif'>\n";
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";
    
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Batch Effects:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
 
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper makes rotating your pictures a snap; in fact, you can rotate multiple pictures at once! Select one or more photos in a collection and click the <font color='red'>Rotate Right</font> or <font color='red'>Rotate Left</font> button. If you scanned a negative backwards and need a quick flip, or if you took that photo that is a little tilted, double click the photo or select it and switch to the <font color='red'>Edit</font> tab to use additional framing tools.") << "\n";
    
    stream << "</td></tr><tr><td>\n";

    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Rotating & Flipping:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Using the framing controls found at the bottom left of the photo editor, you can rotate, correct tilt, flip, and crop your photos. Rotate and flip operations require a single click.") << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/frameControls.png'>\n";
    stream << "</td></tr></table>\n";
    
    stream << "</td></tr><tr><td>\n";
    
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Tilt Correction:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/tiltCorrection.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("You can correct tilt in images by identifying what should be a vertical or horizontal edge. Click the green tilt correction button, then click two places along what should be a vertical or horizontal edge. Album Shaper takes cares of the rest, figuring out how many degrees to rotate your image for you.") << "\n";
    stream << "</td></tr></table>\n";
    
    stream << "</td></tr><tr><td>\n";
    
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Cropping:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Cropping to preset size is easy. First, select the dimensions you are interested in from the aspect ratio menu. The largest portion of the photo that matches that size is automatically selected. Simply click and drag to move the selected region. You can scale the selection by holding Shift and clicking and dragging right and left to expand or shrink the selection about its center. To crop to the selected region, click the <font color='red'>crop</font> button.") << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/cropping5x7.png'>\n";
    stream << "</td></tr></table>\n";
    
    stream << "</td></tr><tr><td>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/dpiWarning.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper takes the difficulties out of cropping and printing your photos. If you crop too small, you will get lower quality prints. If Album Shaper knows the dimensions you want, it passively lets you know if you are cropping too small by changing the color of the selection rectangle. If the selection rectangle turns red, you know the quality of your print will be lower. In such situations the target DPI (dots per inch) is printed next to the selected resolution.") << "\n";
    stream << "</td></tr></table>\n";
    
    stream << "</td></tr><tr><td>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("In addition to cropping to standard print sizes, you can crop images to your current display resolution for creating desktop wallpapers, or even crop to a custom size by clicking and dragging out a selection. You can adjust the corners and edges of the selection independently by clicking and dragging as well.") << "\n";
    stream << "<p>\n";
    stream << QString(HelpWindow::tr("To rotate the selected region about its center, hold %1 and click the selected region.")).arg(ctrlKey) << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/customRotate.png'>\n";
    stream << "</td></tr></table>\n";
    
    stream << "</font>\n";
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
