//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_TITLEWIDGET_H
#define GUI_TITLEWIDGET_H

//--------------------
//forward declarations
class QMenuBar;
class QPopupMenu;
class QGridLayout;
class QLabel;
class QLineEdit;
class QPixmap;
class QToolButton;
class Album;
class Subalbum;
class Window;
class AlbumStatistics;
class ConfigurationWidget;
class About;
class HelpWindow;
class Shortcuts;
class ALabel;
class QIconViewItem;
class Photo;
class RecentAlbumMenuItem;
//--------------------

#define ABOUT 0
#define UPDATES 1
#define UPCOMING 2

#include <qframe.h>
#include "../backend/recentAlbums.h"

//=====================================
/*! \brief Widget which displays album name, description, representative
   image, and album shaper logo.
 */
//=====================================
class TitleWidget : public QFrame
{
Q_OBJECT

public:
  ///Creates layout
  TitleWidget(QWidget *parent=0, const char* name=0);

  ///Deletes stuff!
  ~TitleWidget();
  
  ///Use animation for rep images?
  void useAnimation(bool val);

  ///Sets new pointer to the album object
  void setAlbum( Album* val);

  ///Returns a pointer to the album object
  Album* getAlbum();

  ///Refreshs data from backend objects
  void refresh();

  ///is program busy?
  bool getBusy();

  ///set program busy state
  void setBusy(bool val);

  ///returns handle to recent albums object
  RecentAlbums* getRecentAlbums();
//----------------------
protected:
  void dragEnterEvent( QDragEnterEvent* e);
  void dropEvent( QDropEvent* e);
  
  //create and return path to temporary directory for an album, 
  //if no string is provided temporary directory is created
  //using user prefernce for default temporary directories
  QString createTmpDir(QString albumPath = QString::null );       
//----------------------
signals:
  ///Emitted when user changes subalbum name
  void subalbumNameChanged();
//----------------------
public slots:  
  ///Frees album statistics dialog once closed
  void albumStatisticsClosed();

  ///Frees about dialog once closed
  void aboutClosed();

  ///Frees HelpWindow once closed
  void helpClosed();

  ///Quit slot
  void quitApplication();

  //Settings closed
  void settingsWindowClosed();

  ///Updates subalbum annotations
  void updateAlbumAnnotations();

  ///Update displayed collection name and cover image
  void refreshCollectionAnnotations(Subalbum* collection);
  
  ///Sets the album image to the passed in photo
  void setAlbumImage(Photo* photo);

  ///Sets the subalbum image to the passed in photo
  void setSubalbumImage(Photo* photo);

  ///Pops up about dialog
  void aboutProgram(int mode = ABOUT);

  ///Pops up HelpWindow
  void help();
  
  ///Enables/disables "minimize" window menu entry depending on window state
  void windowStateChanged(bool state);
  
  ///update begin presentation menu entry - disabled when no photos in album
  void updateMenus(bool anySelected=false, bool anyRevertable=false);
//----------------------
private slots:
  ///Store annotations
  void storeAnnotations();

  ///Sets the Album Image
  void setAlbumImage();

  ///Unsets the Album Image
  void unsetAlbumImage();

  ///Sets the Subalbum Image
 void setSubalbumImage();

  ///Unsets the Subalbum Image
 void unsetSubalbumImage();

  ///Resets to empty album
  void newAlbum();
  //----------------------------  
  ///Loads an album specified with file chooser
  void loadAlbum();
  
  ///Loads a recent album
  void loadRecentAlbum(int index);
  
  ///Helper function for load methods, checks
  ///if there are any unsaved changes and if so
  ///warns user any such changes will be lost if they proceed.
  bool proceedWithLoad();

  ///Loads a specified album
  void loadAlbum(QString location);
  //----------------------------  
  ///Saves album
  void saveAlbum();

  ///Saves album as
  void saveAsAlbum();

  ///Revert to last saved album
  void revertToSaved();
  
  ///Export small web gallery (excludes full size images and Album.xml file)
  void exportSmallWebGallery();
  
  ///Export large images only to a new directory for printing purposes
  void exportLargeImages();
  
  ///Pops up settings window
  void settings();

  ///Strip descriptions from selected photos
  void removeSelectedPhotoDesc();

  ///Revert selected photos to original form
  void revertPhotos();
  
  ///Pops up album statistics window
  void albumStatistics();

  ///Clears albums from open recent menu
  void clearOpenRecentMenu();
  //----------------------
private:
  ///Populates the open recent menu with a default set of 9 items + clear
  void populateOpenRecentMenu();
    
  ///Refreshes open recent menu
  void refreshOpenRecentMenu();  

  ///Menubar file menu and help menu inserted in
  QMenuBar* menu;

  ///File menu
  QPopupMenu* file;

  ///Open recent submenu
  QPopupMenu* openRecent;
  int* recentMenuItems;
  int numRecentMenuItems;
  RecentAlbumMenuItem** customRecentMenuItems;
  
  
  ///Photos menu
  QPopupMenu* photoMenu;
  
  ///Tools menu
  QPopupMenu* tools;

  //PLATFORM_SPECIFIC_CODE
  ///Window menu, only used in OSX
  #if defined(Q_OS_MACX)
  QPopupMenu* windowMenu;
  int WINDOW_MINIMIZE;
  #endif
  
  ///Help menu
  QPopupMenu* helpMenu;

  ///Main grid
  QGridLayout* mainGrid;
  QFrame* mainFrame;

  ///Album annotation grid
  QGridLayout* albumAnnotationGrid;
  QFrame* albumAnnotationFrame;
  ALabel* albumImage;
  QLabel* albumName;
  QLineEdit* albumNameVal;
  QLabel* albumDescription;
  QLineEdit* albumDescriptionVal;
  QLabel* albumAuthor;
  QLineEdit* albumAuthorVal;

  ///Subalbum annotation grid
  QGridLayout* subalbumAnnotationGrid;
  QFrame* subalbumAnnotationFrame;
  ALabel* subalbumImage;
  QLabel* subalbumName;
  QLineEdit* subalbumNameVal;
  QLabel* subalbumDescription;
  QLineEdit* subalbumDescriptionVal;

  ///Backend album object
  Album* albm;

  ///Window pointer
  Window* window;

  ///Album Statistics dialog pointer
  AlbumStatistics* albumStats;

  ///Settings dialog pointer
  ConfigurationWidget* settingsWindow;

  ///About dialog pointer
  About* about;

  ///HelpWindow pointer
  HelpWindow* helpWindow;

  ///Is the program currently busy? helps block other operations
  bool busy;

  //modification detection enabled/disabled
  bool detectModifications;

  //file menu item id's
  int NEW_ALBUM;
  int OPEN_ALBUM;
  int SAVE_ALBUM;
  int SAVEAS_ALBUM;
  int REVERT_TO_SAVED_ALBUM;
  int EXPORT_SMALL_WEB_GALLERY;
  int EXPORT_LARGE_IMAGES;
  
  ///photos menu item id's
  int REMOVE_DESCRIPTIONS;
  int REVERT_PHOTOS;
  
  ///tools menu item id's
  int BEGIN_PRESENTATION;
  int BEGIN_PRESENTATION_AT;

  ///cached set button state
  bool cacheSetButtonState;
   
  ///error message and description when temp directory cannot be created
  QString tmpDirErrorMessage, tmpDirErrorDesc;
   
  //recent albums object
  RecentAlbums recentAlbums;
  //----------------------
};
//======================

#endif //GUI_TITLEWIDGET_H
