#!/soft/perl5.6/bin/perl -w
my $INCS = "..\\..\\include";
my $TEXDIR = "./texture";
my $SEQDIR = "./sequence";
my $dir;
# Comment this out to not remove obj files and other crud.
my $CLEAN = 1;
# uncomment these to install all of the dll's in a diffrent dir.
# my $TEXINSTDIR = "c:\blender\plugins\texture";
# my $SEQINSTDIR = "c:\blender\plugins\sequence";

# Create texture dll's
if (opendir(DIR, $TEXDIR)) {
   @dirs = grep !/^\.\.?$/, readdir DIR;
   close(DIR);
} 
foreach $i (@dirs) {
   $dir = "$TEXDIR/$i";
   if (-d $dir) {
      chdir($dir);
      system("lcc -I$INCS -I. $i.c");
      if (-f "$i.def") {
         system("lcclnk -DLL $i.obj $i.def");
      } else { 
         system("lcclnk -DLL $i.obj $INCS\\tex.def");
      }
      system("implib $i.dll");
      if ($CLEAN) {
         unlink("$i.obj");
         unlink("$i.lib");
         unlink("$i.exp");
      }
      chdir("..\\..");
      if ($TEXINSTDIR) {
	copy("$TEXDIR/$i/$i.dll","$TEXINSTDIR/$i.dll");
      }
   }
}

# Create sequence dll's
if (opendir(DIR, $SEQDIR)) {
   @dirs = grep !/^\.\.?$/, readdir DIR;
   close(DIR);
} 
foreach $i (@dirs) {
   $dir = "$SEQDIR/$i";
   if (-d $dir) {
      chdir("$dir");
      system("lcc -I$INCS -I. $i.c");
      if (-f "$i.def") {
         system("lcclnk -DLL $i.obj $i.def");
      } else { 
         system("lcclnk -DLL $i.obj $INCS\\seq.def");
      }
      system("implib $i.dll");
      if ($CLEAN) {
         unlink("$i.obj");
         unlink("$i.lib");
         unlink("$i.exp");
      }
      chdir("..\\..");
      if ($SEQINSTDIR) {
	copy("$SEQDIR/$i/$i.dll","$SEQINSTDIR/$i.dll");
      }
   }
}
