#ifndef MO_DEBUG_H
#define MO_DEBUG_H

#include <limits.h>
#include <stdio.h>

#ifdef MO_DEBUG
  #define _db(s) { printf("%s\n",s); fflush(stdout); }
  #define p_db(p) { printf("%s=%p\n",#p,p); fflush(stdout); }
  #define s_db(s) { printf("%s=%s\n",#s,s); fflush(stdout); }
  #define i_db(i) { printf("%s=%d\t(=0x%x)\n",#i,i,i); fflush(stdout); }
  #define d_db(d) { printf("%s=%g\n",#d,(double)(d)); fflush(stdout); }
  #define _db1(s,a)       { printf(s,a); fflush(stdout); }
  #define _db2(s,a,b)     { printf(s,a,b); fflush(stdout); }
  #define _db3(s,a,b,c)   { printf(s,a,b,c); fflush(stdout); }
  #define _db4(s,a,b,c,d) { printf(s,a,b,c,d); fflush(stdout); }
  #define _db5(s,a,b,c,d,e) { printf(s,a,b,c,d,e); fflush(stdout); }
  #define _db6(s,a,b,c,d,e,f) { printf(s,a,b,c,d,e,f); fflush(stdout); }
  #define _db7(s,a,b,c,d,e,f,g) { printf(s,a,b,c,d,e,f,g); fflush(stdout); }
#else  /* MO_DEBUG */
  #define _db(s)
  #define p_db(p)
  #define s_db(s)
  #define i_db(i)
  #define d_db(d)
  #define _db1(s,a)
  #define _db2(s,a,b)
  #define _db3(s,a,b,c)
  #define _db4(s,a,b,c,d)
  #define _db5(s,a,b,c,d,e)
  #define _db6(s,a,b,c,d,e,f)
  #define _db7(s,a,b,c,d,e,f,g)
#endif /* MO_DEBUG */
#define fehler(s) _db(s)

/* typedef struct { unsigned char a,b,g,r; } RGBA; */
enum { ROT=0, GRUEN=1, BLAU=2, ALPHA=3 };

typedef struct { unsigned char r,g,b,a; } RGBA;
typedef char VRGBA[4];
/* #define MAX_Z 0x7fffffff  // INT_MAX=0x7fffffff */
/* #define MAX_Z INT_MAX */
#define MAX_Z (1<<31)

#define i2d_z(z) (sqrt(1.0+ ((double)(z))/MAX_Z))
#define d2i_z(z) (((z)*(z)-1.0)*MAX_Z)

/* #define i2d_z(z) (((double)(z))/MAX_Z) */
/* #define d2i_z(z) ((z)*(MAX_Z-1)) */


const char getmem_err[]="\n%s (%d): Not enough memory for %u*%g Bytes!";

/* Achtung: unbedingt EXIT() definieren */
#define getmem(s,l) { if((s=(void*)malloc(sizeof(*s)*(l)))==NULL) { p_db(s);fprintf(stderr,getmem_err,__FILE__,__LINE__,sizeof(*s),(double)(l)); EXIT();} }
#define remem(s,l) { if ((s=(void*)realloc((void*)(s),sizeof(*s)*(l)))==NULL) { p_db(s);fprintf(stderr,getmem_err,__FILE__,__LINE__,sizeof(*s),(double)(l)); EXIT(); } }
#define freemem(s) if (s!=NULL) free(s);

#define vecdup(v,w,l) { getmem(v,l);memcpy(v,w,(l)*sizeof(*w)); }
#define veccpy(v,w,l) { memcpy(v,w,(l)*sizeof(*w)); }
#define vecclr(v,l)   { memset(v,0,(l)*sizeof(*v)); }

#define getmem0(v,l) { getmem(v,l); vecclr(v,l); }

#endif /* MO_DEBUG_H */
