/*
 * Alphamatte
 * Ziggy Uszkurat
 * ziggy@zigzagfilms.com
 * Website: http://www.uszkurat.demon.co.uk/blender.html
 *
 * This plugin takes one strip as input and makes greyscale
 * image of the alpha channel.
 *
 * License: Artistic
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "Matte Maker";

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
    { LABEL,		"Input: 1 strip",	0.0,	0.0,	0.0,	""},
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
   int dummy;
} Cast;

/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

/* ************************************************************
		Alphamatte- makes greyscale image of the alpha channel	
   ************************************************************ */


void plugin_seq_doit(Cast *cast, float facf0, float facf1, int sx, int sy, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
	int x, y;
	char *rectOrg, *rectDest;

	int sizeX, sizeY;
	sizeX = ibuf1->x;
	sizeY = ibuf1->y;

	if(ibuf1) {
		/* itereer over de scanlines */
		y = sizeY;
		rectDest = (char *) out->rect;
		rectOrg  = (char *) ibuf1->rect;
		while (y--) {

			/* kopieer een regel */
			x = sizeX;
			while (x--) {
				rectDest[0] = rectOrg[3];
				rectDest[1] = rectOrg[3];
				rectDest[2] = rectOrg[3];			
				rectDest[3] = rectOrg[3];

				rectDest +=4;
				rectOrg +=4;


			}

		}
	
	}

}
