/* 
 * chromakey.c
 * Chroma Key Plugin 0.5
 * Set all pixels with a certain rgb value to transparent. (e.g. Bluebox, Greenbox).
 *
 * Copyright (c) Stefan Gartner <Stefan.Gartner@fhs-hagenberg.ac.at>
 * Portions Copyright (c) 1999, Not a Number / NeoGeo b.v. 
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */

char name[24]= "Chroma Key";	

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{ LABEL,	    "In: >= 1 strip", 0.0,   0.0, 0.0,   ""},
	{ NUMSLI|INT, "Red:",	      0.0,   0.0, 255.0, "Red ValuE"}, 
	{ NUMSLI|INT, "Green:",	      0.0,   0.0, 255.0, "GreEn Value"},
	{ NUMSLI|INT, "Blue:",  	      255.0, 0.0, 255.0, "BLue Value"},
	{ NUMSLI|INT, "Tolerance:",     0.0,   0.0, 255.0, "Tolerance" }
	};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int dummy;			/* because of the 'label' button */
	int red, green, blue, tolerance;			
} Cast;


/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

 
void plugin_seq_doit(Cast *cast, float facf0, float facf1, int x, int y, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
   unsigned char *rectOrg, *rectOrg2, *rectDest;
   int sizeX, sizeY, minRed, minGreen, minBlue, maxRed, maxGreen, maxBlue;
   int alpha= 0;
   sizeX = ibuf1->x;
   sizeY = ibuf1->y;
   /* calculate limits */
   minRed= MAX2(0,(cast->red - cast->tolerance));
   minGreen= MAX2(0,(cast->green - cast->tolerance));
   minBlue= MAX2(0,(cast->blue - cast->tolerance));
   maxRed= MIN2(255,(cast->red + cast->tolerance));
   maxGreen= MIN2(255,(cast->green + cast->tolerance));
   maxBlue= MIN2(255,(cast->blue + cast->tolerance));
   
   if (ibuf1) {
      y = sizeY;
      rectDest = (unsigned char *) out->rect;
      rectOrg  = (unsigned char *) ibuf1->rect;
       if (!ibuf2 || (ibuf2==ibuf1)) {
          printf("no ibuf2!\n");
          alpha= 1;
       } else rectOrg2 = (unsigned char *) ibuf2->rect;
      while (y--) {
         x = sizeX;
         while (x--) {
            if ((minRed <= rectOrg[0] && rectOrg[0] <= maxRed) &&
                (minGreen <= rectOrg[1] && rectOrg[1] <= maxGreen) &&
                (minBlue <= rectOrg[2] && maxBlue))
                {
                   if (alpha==0) {
                      rectDest[0] = rectOrg2[0];
                      rectDest[1] = rectOrg2[1];
                      rectDest[2] = rectOrg2[2];
                      rectDest[3] = rectOrg2[3];
	            } else {
	              rectDest[0] = 0;
	              rectDest[1] = 0;
	              rectDest[2] = 0;
	              rectDest[3] = 0;
	            } 
	        } else {
	           rectDest[3] = rectOrg[3];
	           rectDest[0] = rectOrg[0]; /* R */
	           rectDest[1] = rectOrg[1]; /* G */
	           rectDest[2] = rectOrg[2]; /* B */
	        }
		rectDest +=4;
		rectOrg +=4;
		rectOrg2 +=4;
	      }
	   }	     	  
	}	
}
