/* 
 * desaturate.c
 * desaturation plugin 0.1
 *
 * Remove Color From Sequence Strips. The alpha channel remains unchanged.
 *
 * Copyright (c) 1999 Stefan Gartner <Stefan.Gartner@fhs-hagenberg.ac.at>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */

char name[24]= "Desaturate";	

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{ LABEL,		"Input: 1 strip",   0.0, 0.0,   0.0, ""},
	{ NUMSLI|INT,	"Amount:"	, 100.0, 0.0, 100.0, ""}
	};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int dummy;			/* because of the 'label' button */
	int amount;
} Cast;


/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}



void plugin_seq_doit(Cast *cast, float facf0, float facf1, int x, int y, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
	char *rectOrg, *rectDest;
	char luminance;

	int sizeX, sizeY;
	sizeX = ibuf1->x;
	sizeY = ibuf1->y;

	if (ibuf1) {
		/* itereer over de scanlines */
		y = sizeY;
		rectDest = (char *) out->rect;
		rectOrg  = (char *) ibuf1->rect;
		while (y--) {

			/* kopieer een regel */
			x = sizeX;
			while (x--) {
				
			  /* Alpha is unchanged */
	  		  rectDest[3] = rectOrg[3];
		      luminance= rectOrg[0]*0.299 + rectOrg[1]*0.587 + rectOrg[2]*0.114;
		    	rectDest[0]= rectOrg[0]*(cast->amount/100.0)+luminance*(1-cast->amount/100.0);
		    	rectDest[1]= rectOrg[1]*(cast->amount/100.0)+luminance*(1-cast->amount/100.0);
		   	  rectDest[2]= rectOrg[2]*(cast->amount/100.0)+luminance*(1-cast->amount/100.0);
 			  
			  rectDest +=4;
			  rectOrg +=4;
			  
			}

		}
	
	}
	
}


