/* 
   Sequence Plugin: 		diff.c
   Made by SirDude              mein@cs.umn.edu
   http://www.cs.umn.edu/~mein/blender
   Last updated: Wed May  1 21:21:20 CDT 2002
   This plugin takes 2 or 3 strips as input and applys color differences in
   the first two to the 3rd.
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "diff";	

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{ LABEL,			"Input: 3 strips", 0.0, 0.0, 0.0, ""}, 
        { NUMSLI|INT, "Tolerance:",     10.0,   0.0, 255.0, "Tolerance" },
        { TOG|INT,              "Absolute",     0.0,    0.0,    1.0,
           "Make a b/w mask"},

};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int dummy;			/* because of the 'label' button */
        int tol,type;

} Cast;


/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

int inzone(char *in1, char *in2, Cast *cast) {
   float val;

   val = ABS(in1[0] - in2[0]) + ABS(in1[1] - in2[1]) + ABS(in1[3] - in2[3]);
/*
   val = MAX3(ABS(in1[0] - in2[0]),ABS(in1[1] - in2[1]),
      ABS(in1[3] - in2[3]));
*/
   if (val > cast->tol) return 1;

   return 0;
}

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int x, int y, 
   ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *ibufo, ImBuf *use) {
   int xo;
   char *in1, *in2, *in3, *out;	
	
   xo= x;
   in1=  (char *)ibuf1->rect;
   in2=  (char *)ibuf2->rect;
   in3=  (char *)use->rect;
   out=  (char *)ibufo->rect;
	
if (cast->type == 1) {
   while(y--) {
      x= xo;
      while(x--) {
        if (inzone(in1,in2,cast)) {
           out[0] = out[1] = out[2] = out[3] = 255;
        } else {
           out[0] = out[1] = out[2] = out[3] = 0;
        }
	in1 +=4; in2 +=4; out +=4;
      }		
   }	
   } else {
      while(y--) {
         x= xo;
         while(x--) {
            out[0] = in3[0] - (in1[0] - in2[0]);
            out[1] = in3[1] - (in1[1] - in2[1]);
            out[2] = in3[2] - (in1[2] - in2[2]);
            out[3] = in3[3] - (in1[3] - in2[3]);
            in1 +=4; in2 +=4; in3+=4; out +=4;
         }
      }
   }
}
