/*
 * Copyright (c) 1999, daniel simon.
 * V0.2
 *
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "fadeToBW";

/* structure for buttons,
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
    	{ LABEL,			"MIXING VALUES", 0.0, 0.0, 0.0, ""},
	{ NUMSLI|FLO,	"red ",		0.3,	0.0, 1.0, "redValue"},
        { NUMSLI|FLO,	"green ",      	0.59,	0.0, 1.0, "greenValue"},
        { NUMSLI|FLO,	"blue ",      	0.11,	0.0, 1.0, "blueValue"},
        { TOG|INT,	"Animated",	0.0,	0.0,	1.0, 
	   "For (Ipo) animated"},
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */

typedef struct Cast {
    int dummy;
    float redValue;
    float greenValue;
    float blueValue;
    float use_IPO;
} Cast;

/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void)
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but)
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int sx, int sy, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
	int a;
        char *rectc;
        char *rectu;
	float IPOcurve;

        if (cast->use_IPO) {
          if ((facf0 <= 1.0) && (facf0 >= 0.0)) {
		IPOcurve = facf0;
		} else {
		if (facf0 > 1.0) {
			IPOcurve = 1.0;
			} else {
			IPOcurve = 0.0;
			}
		}

        } else
            IPOcurve=1;


          if(ibuf1) {
		if(ibuf1->zbuf==0) {
			printf("no zbuf\n");
			return;
		}

                a= ibuf1->x*ibuf1->y;

		rectc= (char *)out->rect;
                rectu= (char *)ibuf1->rect;

                if (!out->zbuf) out->zbuf=malloc(a*sizeof(out->zbuf[0]));
                if (out->zbuf) memcpy(out->zbuf,ibuf1->zbuf,a*sizeof(out->zbuf[0]));

		while(a--) {
	            rectc[0]=rectu[0];

                    rectc[1]= (char) (CLAMP(rectu[1]*(1-IPOcurve*(1-cast->redValue))+
                                    rectu[2]*cast->greenValue*IPOcurve+
                                    rectu[3]*cast->blueValue*IPOcurve, 0.f, 255.f)+0.5f);
                     rectc[2]= (char)(CLAMP(rectu[1]*cast->redValue*IPOcurve+
                                     rectu[2]*(1-IPOcurve*(1-cast->greenValue))+
                                     rectu[3]*cast->blueValue*IPOcurve, 0.f,255.f)+0.5f);
                    rectc[3]= (char)(CLAMP(rectu[1]*cast->redValue*IPOcurve+
                                    rectu[2]*cast->greenValue*IPOcurve+
                                    rectu[3]*(1-IPOcurve*(1-cast->blueValue)),0.f, 255.f)+0.5f);

/*                    rectc[1]= rectc[2]= rectc[3]=rectc[1]*.3+ rectu[2]*.59+ rectu[3]*0.11; ; */

                    rectc+=4; rectu+=4;
		}
	}
}
