/* 
Various ways of flipping an input source
Written by Kent Mein mein@cs.umn.edu (Aka SirDude)
http://www.cs.umn.edu/~mein/blender
Date: Thu May 16 13:48:50 CDT 2002
*/

#include "plugin.h"
#define DEPTH 4

/* ******************** GLOBAL VARIABLES ***************** */
char name[24]= "Flipit";	

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
   { LABEL,   "Input: 1 strip", 0.0, 0.0, 0.0, ""},
   { TOG|INT, "Flip X", 0.0, 0.0, 1.0, "Flip image along x"},
   { TOG|INT, "Flip Y", 0.0, 0.0, 1.0, "Flip image along y"},
   { TOG|INT, "rot", 0.0, 0.0, 1.0, "Rotate Image"},
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
   int c, x, y, r;
} Cast;


/* cfra: the current frame */
float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, 
   ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */
int plugin_seq_getversion(void) {
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) {
}

void plugin_init() {
}

void plugin_getinfo(PluginInfo *info) {
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int xo, int yo, 
	ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *outbuf, ImBuf *use) {
   int x, y,x2,y2, i, tmp, src, dest;
   char *out=(char *)outbuf->rect;
   char *in=(char *)ibuf1->rect;
   for(y=0;y<yo;y++) {
      for(x=0;x<xo;x++) {
             x2 = x;
             y2 = y;
         if (cast->r == 1) {
             tmp = y2;
             y2 = yo - x2;
             x2 = tmp;
         }
         if (cast->x == 1) {
             x2 = xo - x2;
         }
         if (cast->y == 1) {
             y2 = yo - y2;
         }
         if (x2 < 0) x2 = x2 + xo;
         if (y2 < 0) y2 = y2 + yo;
         if (x2 > xo) x2 = xo - x2;
         if (y2 > yo) y2 = yo - y2;
         dest = (y * xo + x)*DEPTH;
         src = (y2 * xo + x2)*DEPTH; 
         for (i=0;i<DEPTH;i++) out[dest + i] = in[src + i];
      }
   }
}
