
/*
	framestamp v.5a

	text output directly to image including:
		framestamp
		timestamp
		image mame-if available
		50 char optional text

	origional code and concept by qwe (at gmail dot com)
	slightly enhanced by paprmh (at gmail dot com)


License: GPL
Version: 0.5a
*/

#include "plugin.h"
#include "stdio.h"


#define TEX	(6<<9)
#define TOG3	(7<<9)
#define SHO	64

char name[24]= "framestamp";


/* structure for buttons,
* 	butcode 	name 	default 	min 	max 	"tip"
*/

VarStruct varstr[]= {

	{ TOG|INT,	"frame stamp",	0.0,		0.0, 1.0,		"print frame stamp"},
	{ NUM|INT,	"Digits",		3.0,		1.0, 10.0, 	"How many digits for frame stamp"},
	{ TOG|INT,	"time stamp",	0.0,		0.0, 1.0, 	"print time stamp"},
	{ NUM|INT,	"frs/sec",	25.0,	1.0, 120.0, 	"frames per second- only needed for time stamp"},
	{ NUM|INT,	"x pos",		4.0,		0.0, 10000.0, 	"x position of frame/time stamp"},
	{ NUM|INT,	"y pos",		1.0,		0.0, 10000.0, 	"y position of frame/time stamp"},
	{ TOG|INT,	"stamp name",	0.0,		0.0, 1.0, 	"print name (if available)"},
	{ NUM|INT,	"x pos",		1000.0,	0.0, 10000.0, 	"x position of name"},
	{ NUM|INT,	"y pos",		1.0,		0.0, 10000.0, 	"y position of name"},
	{ TOG|INT,	"stamp text",	0.0,		0.0, 1.0, 	"print custom text to image"},
	{ NUM|INT,	"x pos",		100.0,	0.0, 10000.0, 	"x position of text"},
	{ NUM|INT,	"y pos",		100.0,	0.0, 10000.0, 	"y position of text"},
	{ LABEL,		"framestamp.5",0.0,		0.0, 0.0, 	"v.5a print information directly to the image"},
	{ LABEL,		"font color:",	0.0,		0.0, 0.0, 	"color of text"},
	{ TOG|INT,	"invert color",1.0,		0.0, 1.0, 	"inverts color of input strip pixel for font color"},
	{ COL|CHA,	"font Color",	0.0,		0.0, 255.0, 	"font color"},
	{LABEL,		"input text:",	0.0,		0.0,	60.0,	"enter text to print below"},
	{ TEX|CHA,	"Txt:",		0.0,		0.0, 50.0, 	"text to print"},

};

/* The cast struct is for input in the main doit function
Varstr and Cast must have the same variables in the same order */

typedef struct Cast {

	int fstamp;
	int digits;
	int tstamp;
	int frpsec;
	int flx;
	int fly;
	int nstamp;
	int nlx;
	int nly;
	int texstamp;
	int tlx;
	int tly;
	int dummy;		 /* because of the 'label' button */
	int dummy2;
	int invclr;
	char color[4];
	int dummy3;
	char intex[51];


} Cast;

/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int,
ImBuf *, ImBuf *, ImBuf *, ImBuf *);

int plugin_seq_getversion(void) {
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) {
}

void plugin_init() {
}

void plugin_getinfo(PluginInfo *info) {
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;
	info->varstr= varstr;
	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

/* Font data

	8x12 fixed font compressed into 12 bytes per char
	(1bit per pixel)
	[other fonts and could be made relatively easily]
	neat eh?

*/

unsigned char ftdat[95][12]={
/* [ ] = */ {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
/* [!] = */ {0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x78,0x78,0x78,0x30,0x00},
/* ["] = */ {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x66,0x66,0x66,0x00},
/* [#] = */ {0x00,0x00,0x6c,0x6c,0xfe,0x6c,0x6c,0x6c,0xfe,0x6c,0x6c,0x00},
/* [$] = */ {0x00,0x30,0x30,0xf8,0x0c,0x0c,0x78,0xc0,0xc0,0x7c,0x30,0x30},
/* [%] = */ {0x00,0x00,0x8c,0xcc,0x60,0x30,0x18,0xcc,0xc4,0x00,0x00,0x00},
/* [&] = */ {0x00,0x00,0x76,0xdc,0xcc,0xde,0xfa,0x70,0xd8,0xd8,0x70,0x00},
/* ['] = */ {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x30,0x30,0x00},
/* [(] = */ {0x00,0x00,0x0c,0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x0c,0x00},
/* [)] = */ {0x00,0x00,0x60,0x30,0x18,0x0c,0x0c,0x0c,0x18,0x30,0x60,0x00},
/* [*] = */ {0x00,0x00,0x00,0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,0x00},
/* [+] = */ {0x00,0x00,0x00,0x00,0x18,0x18,0x7e,0x18,0x18,0x00,0x00,0x00},
/* [,] = */ {0x00,0x60,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
/* [-] = */ {0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00,0x00},
/* [.] = */ {0x00,0x00,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
/* [/] = */ {0x00,0x00,0x80,0xc0,0x60,0x30,0x18,0x0c,0x06,0x02,0x00,0x00},
/* [0] = */ {0x00,0x00,0x7c,0xc6,0xe6,0xf6,0xd6,0xde,0xce,0xc6,0x7c,0x00},
/* [1] = */ {0x00,0x00,0xfc,0x30,0x30,0x30,0x30,0x30,0xf0,0x30,0x10,0x00},
/* [2] = */ {0x00,0x00,0xfc,0xcc,0x60,0x30,0x18,0x0c,0xcc,0xcc,0x78,0x00},
/* [3] = */ {0x00,0x00,0x78,0xcc,0x0c,0x0c,0x38,0x0c,0x0c,0xcc,0x78,0x00},
/* [4] = */ {0x00,0x00,0x1e,0x0c,0x0c,0xfe,0xcc,0x6c,0x3c,0x1c,0x0c,0x00},
/* [5] = */ {0x00,0x00,0x78,0xcc,0x0c,0x0c,0xf8,0xc0,0xc0,0xc0,0xfc,0x00},
/* [6] = */ {0x00,0x00,0x78,0xcc,0xcc,0xcc,0xf8,0xc0,0xc0,0x60,0x38,0x00},
/* [7] = */ {0x00,0x00,0x30,0x30,0x30,0x18,0x0c,0x06,0xc6,0xc6,0xfe,0x00},
/* [8] = */ {0x00,0x00,0x78,0xcc,0xcc,0xdc,0x78,0xec,0xcc,0xcc,0x78,0x00},
/* [9] = */ {0x00,0x00,0x70,0x30,0x18,0x18,0x7c,0xcc,0xcc,0xcc,0x78,0x00},
/* [:] = */ {0x00,0x00,0x00,0x38,0x38,0x00,0x00,0x38,0x38,0x00,0x00,0x00},
/* [;] = */ {0x00,0x30,0x18,0x38,0x38,0x00,0x00,0x38,0x38,0x00,0x00,0x00},
/* [<] = */ {0x00,0x00,0x0c,0x18,0x30,0x60,0xc0,0x60,0x30,0x18,0x0c,0x00},
/* [=] = */ {0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x7e,0x00,0x00,0x00,0x00},
/* [>] = */ {0x00,0x00,0x60,0x30,0x18,0x0c,0x06,0x0c,0x18,0x30,0x60,0x00},
/* [?] = */ {0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x18,0x0c,0xcc,0x78,0x00},
/* [@] = */ {0x00,0x00,0x7c,0xc0,0xc0,0xde,0xde,0xde,0xc6,0xc6,0x7c,0x00},
/* [A] = */ {0x00,0x00,0xcc,0xcc,0xcc,0xfc,0xcc,0xcc,0xcc,0x78,0x30,0x00},
/* [B] = */ {0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x66,0x66,0x66,0xfc,0x00},
/* [C] = */ {0x00,0x00,0x3c,0x66,0xc6,0xc0,0xc0,0xc0,0xc6,0x66,0x3c,0x00},
/* [D] = */ {0x00,0x00,0xf8,0x6c,0x66,0x66,0x66,0x66,0x66,0x6c,0xf8,0x00},
/* [E] = */ {0x00,0x00,0xfe,0x62,0x60,0x64,0x7c,0x64,0x60,0x62,0xfe,0x00},
/* [F] = */ {0x00,0x00,0xf0,0x60,0x60,0x64,0x7c,0x64,0x62,0x66,0xfe,0x00},
/* [G] = */ {0x00,0x00,0x3e,0x66,0xc6,0xce,0xc0,0xc0,0xc6,0x66,0x3c,0x00},
/* [H] = */ {0x00,0x00,0xcc,0xcc,0xcc,0xcc,0xfc,0xcc,0xcc,0xcc,0xcc,0x00},
/* [I] = */ {0x00,0x00,0x78,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x78,0x00},
/* [J] = */ {0x00,0x00,0x78,0xcc,0xcc,0xcc,0x0c,0x0c,0x0c,0x0c,0x1e,0x00},
/* [K] = */ {0x00,0x00,0xe6,0x66,0x6c,0x6c,0x78,0x6c,0x6c,0x66,0xe6,0x00},
/* [L] = */ {0x00,0x00,0xfe,0x66,0x66,0x62,0x60,0x60,0x60,0x60,0xf0,0x00},
/* [M] = */ {0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xd6,0xfe,0xfe,0xee,0xc6,0x00},
/* [N] = */ {0x00,0x00,0xc6,0xc6,0xce,0xde,0xfe,0xf6,0xe6,0xc6,0xc6,0x00},
/* [O] = */ {0x00,0x00,0x38,0x6c,0xc6,0xc6,0xc6,0xc6,0xc6,0x6c,0x38,0x00},
/* [P] = */ {0x00,0x00,0xf0,0x60,0x60,0x60,0x7c,0x66,0x66,0x66,0xfc,0x00},
/* [Q] = */ {0x00,0x1e,0x0c,0x7c,0xde,0xce,0xc6,0xc6,0xc6,0x6c,0x38,0x00},
/* [R] = */ {0x00,0x00,0xe6,0x66,0x66,0x6c,0x7c,0x66,0x66,0x66,0xfc,0x00},
/* [S] = */ {0x00,0x00,0x78,0xcc,0xcc,0x18,0x70,0xc0,0xcc,0xcc,0x78,0x00},
/* [T] = */ {0x00,0x00,0x78,0x30,0x30,0x30,0x30,0x30,0x30,0xb4,0xfc,0x00},
/* [U] = */ {0x00,0x00,0x78,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0x00},
/* [V] = */ {0x00,0x00,0x30,0x78,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0x00},
/* [W] = */ {0x00,0x00,0x6c,0x6c,0x6c,0xd6,0xd6,0xc6,0xc6,0xc6,0xc6,0x00},
/* [X] = */ {0x00,0x00,0xcc,0xcc,0xcc,0x78,0x30,0x78,0xcc,0xcc,0xcc,0x00},
/* [Y] = */ {0x00,0x00,0x78,0x30,0x30,0x30,0x78,0xcc,0xcc,0xcc,0xcc,0x00},
/* [Z] = */ {0x00,0x00,0xfe,0xc6,0x62,0x60,0x30,0x18,0x98,0xce,0xfe,0x00},
/* [[] = */ {0x00,0x00,0x3c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0x00},
/* [\] = */ {0x00,0x00,0x02,0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00,0x00},
/* []] = */ {0x00,0x00,0x3c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x3c,0x00},
/* [^] = */ {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc6,0x6c,0x38,0x10},
/* [_] = */ {0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
/* [`] = */ {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x30,0x30},
/* [a] = */ {0x00,0x00,0x76,0xcc,0xcc,0x7c,0x0c,0x78,0x00,0x00,0x00,0x00},
/* [b] = */ {0x00,0x00,0xdc,0x66,0x66,0x66,0x66,0x7c,0x60,0x60,0xe0,0x00},
/* [c] = */ {0x00,0x00,0x78,0xcc,0xc0,0xc0,0xcc,0x78,0x00,0x00,0x00,0x00},
/* [d] = */ {0x00,0x00,0x76,0xcc,0xcc,0xcc,0xcc,0x7c,0x0c,0x0c,0x1c,0x00},
/* [e] = */ {0x00,0x00,0x78,0xcc,0xc0,0xfc,0xcc,0x78,0x00,0x00,0x00,0x00},
/* [f] = */ {0x00,0x00,0xf0,0x60,0x60,0x60,0xf8,0x60,0x60,0x6c,0x38,0x00},
/* [g] = */ {0x78,0xcc,0x0c,0x7c,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,0x00},
/* [h] = */ {0x00,0x00,0xe6,0x66,0x66,0x66,0x76,0x6c,0x60,0x60,0xe0,0x00},
/* [i] = */ {0x00,0x00,0x7e,0x18,0x18,0x18,0x18,0x78,0x00,0x18,0x18,0x00},
/* [j] = */ {0x78,0xcc,0xcc,0x0c,0x0c,0x0c,0x0c,0x3c,0x00,0x0c,0x0c,0x00},
/* [k] = */ {0x00,0x00,0xe6,0x66,0x6c,0x78,0x6c,0x66,0x60,0x60,0xe0,0x00},
/* [l] = */ {0x00,0x00,0x7e,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x78,0x00},
/* [m] = */ {0x00,0x00,0xc6,0xd6,0xd6,0xd6,0xd6,0xfc,0x00,0x00,0x00,0x00},
/* [n] = */ {0x00,0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0xf8,0x00,0x00,0x00,0x00},
/* [o] = */ {0x00,0x00,0x78,0xcc,0xcc,0xcc,0xcc,0x78,0x00,0x00,0x00,0x00},
/* [p] = */ {0xf0,0x60,0x7c,0x66,0x66,0x66,0x66,0xdc,0x00,0x00,0x00,0x00},
/* [q] = */ {0x1e,0x0c,0x7c,0xcc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,0x00},
/* [r] = */ {0x00,0x00,0xf0,0x60,0x60,0x76,0x6e,0xec,0x00,0x00,0x00,0x00},
/* [s] = */ {0x00,0x00,0x78,0xcc,0x18,0x60,0xcc,0x78,0x00,0x00,0x00,0x00},
/* [t] = */ {0x00,0x00,0x38,0x6c,0x60,0x60,0x60,0xfc,0x60,0x20,0x00,0x00},
/* [u] = */ {0x00,0x00,0x76,0xcc,0xcc,0xcc,0xcc,0xcc,0x00,0x00,0x00,0x00},
/* [v] = */ {0x00,0x00,0x30,0x78,0xcc,0xcc,0xcc,0xcc,0x00,0x00,0x00,0x00},
/* [w] = */ {0x00,0x00,0x6c,0x6c,0xd6,0xd6,0xc6,0xc6,0x00,0x00,0x00,0x00},
/* [x] = */ {0x00,0x00,0xc6,0x6c,0x38,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00},
/* [y] = */ {0xf0,0x18,0x0c,0x3c,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00},
/* [z] = */ {0x00,0x00,0xfc,0xc4,0x60,0x18,0x8c,0xfc,0x00,0x00,0x00,0x00},
/* [{] = */ {0x00,0x00,0x1c,0x30,0x30,0x60,0xc0,0x60,0x30,0x30,0x1c,0x00},
/* [|] = */ {0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x00},
/* [}] = */ {0x00,0x00,0xe0,0x30,0x30,0x18,0x0c,0x18,0x30,0x30,0xe0,0x00},
/* [~] = */ {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xce,0xda,0x73,0x00},

};

void drawstr(char* dspstr, int* dest,int xp,int yp ,int xs,int ys, Cast* cast) {

	int ln=0,ltr=0, bt=0, i=0, n=0;
	unsigned char ftlnbt;
	int numltr=strlen(dspstr);
	int maxltr=(xs/8);
	int *out=(int*)dest;
	int *base;
	int *ftclr=(int*)cast->color;

/*is there something to print?*/

	if(!numltr){printf("drawstr:nothing here to print-> aborted\n");return;}

/*screen position check and adjust*/
	i=maxltr-numltr;
	if(i<0){
		dspstr-=i;
		numltr=maxltr;
		xp=0;
	}

	i=xs-((numltr*8)+xp);
	if(i<0) xp+=i;
	if(yp>ys-12)yp=ys-12;


printf("drawstr:\"%s\" at %d:%d\n",dspstr,xp,yp);


	for (i=0; i < numltr; i++,n++) {			/*number of chars*/
		ltr=dspstr[i]-32;						/*get the letter*/
		if(ltr<0||ltr>94)ltr=0;
		base=(int*)dest+(yp*xs)+(n*8)+xp;	/*bottom left screen position of letter*/

		for(ln=0;ln<12;ln++){				/*for each line (12)*/
			out=(int*)base+(xs*ln);			/*out set to line*/

			for(bt=0;bt<8;bt++){					/*each scanline of letter(8bits)*/
				ftlnbt=ftdat[ltr][ln];				/*get ftlnbt flag bit for line*/

				if(ftlnbt&(0x80>>bt)){
					if(cast->invclr){
						*out=((~(*out))&0xffffff)|0xff000000;
					}
					else *out=*ftclr;

				}
				out++;
			}

		}
	}
}

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int sx, int sy,
	ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *outbuf, ImBuf *usebuf) {
	int *in1, *out;
	char *pstr;
	char numstr[50];
	char prntstr[1023];
	int h,m,s,f,i;
	int frpsec=cast->frpsec;
	int totpix=sx*sy;
	in1= (int *)ibuf1->rect;
	out= (int *)outbuf->rect;

	cast->color[3]=255;
	h=m=s=0;
	sprintf(prntstr,"");
/*quick copy of image to output image*/
	for(i=0;i<totpix;i++)out[i]=in1[i];


/*frame and time stamp*/
	i=0;
	if(cast->tstamp){
		i++;
		f=(int)cfra%frpsec;
		s=(int)cfra/frpsec;
		if(s){
			m=s/60;
			s%=60;
			if(m){
				h=m/60;
				m%=m;
			}

		}
		if(frpsec<100)sprintf(prntstr,"%02d:%02d:%02d:%02d",h,m,s,f);
		else sprintf(prntstr,"%02d:%02d:%02d:%03d",h,m,s,f);


	}
	if(cast->fstamp){
		i++;
		sprintf(numstr,"%012d",(int)cfra);
		pstr=(char*)numstr+(strlen(numstr)-cast->digits);
		sprintf(prntstr,"%s[%s]",prntstr,pstr);
	}


	if(i){
		i=sx-(strlen(prntstr)*8);

		if(cast->flx>i)cast->flx=i;
		if(cast->fly>sy-12)cast->fly=sy-12;
		drawstr(prntstr, out,cast->flx, cast->fly, sx,sy, cast);
	}


/*stamp name*/
	sprintf(prntstr,"image: %s",(strlen(ibuf1->name))?ibuf1->name:"name not known");
	i=sx-(strlen(prntstr)*8);
	if(cast->nlx>i)cast->nlx=i;
	if(cast->nly>sy-12)cast->nly=sy-12;
	if(cast->nstamp) drawstr(prntstr, out, cast->nlx, cast->nly, sx,sy, cast);



/*print input text*/
	if(cast->texstamp){
		pstr=(char*)cast->intex;
		i=sx-(strlen(pstr)*8);
		if(cast->tlx>i)cast->tlx=i;
		if(cast->tly>sy-12)cast->tly=sy-12;

		drawstr(pstr,out,cast->tlx, cast->tly,sx,sy,cast);
	}
}

