/***************************************************************************
                          iris.c  -  Simple iris transition
                             -------------------
    begin                : Wed Feb 9 2000
    copyright            : (C) 2000 by Stefan Gartner
    email                : Stefan.Gartner@fhs-hagenberg.ac.at
 ***************************************************************************/

/***************************************************************************
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include "math.h"
#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "Iris";

/* structure for buttons,
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{ LABEL,   "Input: 2 Strips", 0.0, 0.0, 0.0, ""},
	{ TOG|INT, "In",              0.0, 0.0, 1.0, "Iris In"}
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */

typedef struct Cast {
   int dummy;
   int in;
} Cast;

/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void)
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but)
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int x, int y, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
   char *src1, *src2, *dest;
   float r, d;
   int sizeX, sizeY, centerX, centerY;

   if (!ibuf1 || !ibuf2 || ibuf2==ibuf1) return;

   sizeX = x;
   sizeY = y;
   centerX= (sizeX+1)/2;
   centerY= (sizeY+1)/2;
   r = (hypot(sizeX,sizeY)/2.0)*fabs(!cast->in-facf0);
   src1 = (char *) ibuf1->rect;
   src2 = (char *) ibuf2->rect;
   dest = (char *) out->rect;
   y= sizeY;
   while (y--) {
      x = sizeX;
      while (x--) {
         d=hypot(fabs(x-centerX),fabs(y-centerY));
         if (d>=r) {
            dest[0]= src2[0];
            dest[1]= src2[1];
            dest[2]= src2[2];
            dest[3]= src2[3];
         } else {
            dest[0]=src1[0];
            dest[1]=src1[1];
            dest[2]=src1[2];
            dest[3]=src1[3];
         }
         dest+=4;
         src1+=4;
         src2+=4;
      }
   }
}



