#include <math.h>
#include "plugin.h"

char name[24]= "BlendSaber";

/* 
Description: This plugin takes a strip as input and adds
a lightsaber-like aura of the specified color around the edge
of the objects in the image.
Author: Ian "qwe" Gowen (ian.gowen@gmail.RemoveThisUnlessYouAreASpammer.com)
License: GPL
Version: 0.4.1
*/

/* 
   NEW IN 0.4.1

   -- Fixed some stupid bugs, wishing I hadn't released 0.4 yet
   -- Simplified the interface, took out color discrimination(does anyone care?)
   -- Flickering is now achieved through the sequence IPO
   -- Refactored some code, made stuff better ;)

   NEW IN 0.4

  -- New gaussian blur algorithm, now the glow doesn't fade off around the
     edges of the image.


   NEW IN 0.3

  -- The plugin can now discriminate between objects, allowing the plugin to be used
  within a 3D scene(to a certain extent: don't use motion blur!)
  
  -- UI enhancements: there are now color selectors rather than three NUM buttons

   


 NEW IN 0.2

  -- Flickering!
  


 KNOWN BUGS / TODO

 -- Fix the kludgy #define nonsense(yes, it's been 3 versions and I still haven't fixed this... sigh)
 
*/

#define COL (15<<9)
#define CHA 32
#define POS(X,Y,XO) (((X)+(Y)*(XO))*4)

/* structure for buttons,
* butcode name default min max 0
*/

VarStruct varstr[]= {
{ LABEL, "BlendSaber", 0.0, 0.0, 0.0, "In: 1 strip"},
{ COL|CHA, "color", 0.0, 0.0, 255.0, "Color"},
{ NUM|INT, "Expand", 0.0, 0.0, 255.0, "Artificially add pixels around edges"},
{ NUM|FLO, "Blur Aura", 10.0, 0.0, 20.0, "Amount of blur on aura"},
{ NUM|FLO, "Blur Core", 0.7, 0.0, 20.0, "Amount of blur on core"},
{ NUM|INT, "Blur Quality", 3.0, 1.0, 5.0, "Accuracy of blur applied"},
{ LABEL, "By Ian Gowen", 0.0, 0.0, 0.0, "In: 1 strip" },
{ TOG|INT, "Flicker", 0.0, 0.0, 1.0, "Flicker aura"},
};

/* The cast struct is for input in the main doit function
Varstr and Cast must have the same variables in the same order */

#define red color[0]
#define green color[1]
#define blue color[2]

typedef struct Cast {
int dummy; /* because of the 'label' button */
char color[3];
int glow;
float blur;
float core_blur;
int quality;
int idiot; /* copyright label*/
int flicker;
} Cast;

/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int,
ImBuf *, ImBuf *, ImBuf *, ImBuf *);

int plugin_seq_getversion(void) {

	return B_PLUGIN_VERSION;

}
void plugin_but_changed(int but) {

}

void plugin_init() {
}

void plugin_getinfo(PluginInfo *info) {
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;
	info->varstr= varstr;
	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}



/* Glow Functions */

#define GlowR 0
#define GlowG 1
#define GlowB 2
#define GlowA 3

/*	Adds two bitmaps and puts the results into a third map. */
/*	C must have been previously allocated but it may be A or B. */
/*	We clamp values to 255 to prevent weirdness */
/*=============================== */
void RVAddBitmaps (unsigned char* a, unsigned char* b, char* c, int width, int height)
{
	int	x,y,index;

	for (y=0;y<height;y++){
		for (x=0;x<width;x++){
			index=(x+y*width)*4;
			c[index+GlowR]=MIN2(255,a[index+GlowR]+b[index+GlowR]);
			c[index+GlowG]=MIN2(255,a[index+GlowG]+b[index+GlowG]);
			c[index+GlowB]=MIN2(255,a[index+GlowB]+b[index+GlowB]);
			c[index+GlowA]=MIN2(255,a[index+GlowA]+b[index+GlowA]);
		}
	}
}

/*	For each pixel whose total luminance exceeds the threshold, */
/*	Multiply it's value by BOOST and add it to the output map */
void RVIsolateHighlights (unsigned char* in, unsigned char* out, int width, int height, int threshold, float boost, float clamp)
{
	int x,y,index;
	int	intensity;


	for(y=0;y< height;y++) {
		for (x=0;x< width;x++) {
	 	   index= (x+y*width)*4;

		   /*	Isolate the intensity */
		   intensity=(in[index+GlowR]+in[index+GlowG]+in[index+GlowB]-threshold);
		   if (intensity>0){
			out[index+GlowR]=MIN2(255*clamp, (in[index+GlowR]*boost*intensity)/255);
			out[index+GlowG]=MIN2(255*clamp, (in[index+GlowG]*boost*intensity)/255);
			out[index+GlowB]=MIN2(255*clamp, (in[index+GlowB]*boost*intensity)/255);
			}
			else{
				out[index+GlowR]=0;
				out[index+GlowG]=0;
				out[index+GlowB]=0;
			}
		}
	}
}

int gaussianBlur(char* in, char* out, int xo, int yo, float blur, int q) {
	int quality;
	float r, g, b,k, total, *filter;
	int i,x,y,p,p2,h;
	float t = 0;
	char* temp; 

	if (blur <= 0) return 0;
	quality = q*blur;
	filter = malloc((sizeof(float)*quality*2)+1);
	h = quality;
	temp = malloc(xo*yo*4);
	k = -1.0/(2.0*3.14159*blur*blur);

	for (i = -quality; i <= quality; i++) {
		filter[i+quality] =(float)exp(k*(i*i)); 
		t += filter[i+quality];
	}
	total = 0;
	for (i = -quality; i <= quality; i++) {
		filter[i+quality] /= t;
		total+=filter[i+quality];
	}
	/* horizontal pass */
	for (x = 0; x < xo; x++) {
		for (y = 0; y < yo; y++) {
			p = POS(x,y,xo);
			r = g = b = 0;
			for (i = -quality; i <= quality; i++) {
				if (x+i >= xo) {
					p2 = POS(xo-1, y, xo);
					r += in[p2]*filter[i+h];
					g += in[p2+1]*filter[i+h];
					b += in[p2+2]*filter[i+h];

				} else if (x+i <= 0) {
					p2 = POS(1, y, xo);
					r += in[p2]*filter[i+h];
					g += in[p2+1]*filter[i+h];
					b += in[p2+2]*filter[i+h];
				} else {
					p2 = POS(x+i, y, xo);
					r += in[p2]*filter[i+h];
					g += in[p2+1]*filter[i+h];
					b += in[p2+2]*filter[i+h];

				}
			}
			temp[p]   = r;
			temp[p+1] = g;
			temp[p+2] = b;
		}
	}
	/* vertical pass */
	for (x = 0; x < xo; x++) {
		for (y = 0; y < yo; y++) {
			p = POS(x,y,xo);
			r = g = b = 0;
			for (i = -quality; i <= quality; i++) {
				if (y+i >= yo) {
					p2 = POS(x, yo-1, xo);
					r += temp[p2]*filter[i+h];
					g += temp[p2+1]*filter[i+h];
					b += temp[p2+2]*filter[i+h];

				} else if (y+i <= 0) {
					p2 = POS(x, 0, xo);
					r += temp[p2]*filter[i+h];
					g += temp[p2+1]*filter[i+h];
					b += temp[p2+2]*filter[i+h];

				} else {
					p2 = POS(x, y+i, xo);
					r += temp[p2]*filter[i+h];
					g += temp[p2+1]*filter[i+h];
					b += temp[p2+2]*filter[i+h];
				}

			}
			out[p] = r;
			out[p+1] = g;
			out[p+2] = b;
		}
	}
	/* Take out the trash */
	free(temp);
	free(filter);

	return 1;
}

void fill(unsigned char* out, int xo, int x, int y, int r, int g, int b) {
	int p = POS(x,y,xo);
	out[p] = r;
	out[p+1] = g;
	out[p+2] = b;
}

void expandPixels(char* in, unsigned char* out, int xo, int yo, int a, int t, char r, char g, char b) {
	int x,y,p,i,j;
	for (x = 0; x < xo; x++) {
		for (y = 0; y < yo; y++) {
			p = POS(x,y,xo);
			if (in[p] > t || in[p+1] > t || in[p+2] > t) {
				out[p] = r;
				out[p+1] = g;
				out[p+2] = b;
				for (i = 1; i < a; i++) {
					for (j = 1; j < a; j++) {
						if (x+i < xo && y+j < yo) {
							fill(out, xo, x+i, y+j, r, g, b);
						}
					
						if (x-i >= 0 && y+j < yo) {
							fill(out, xo, x-i, y+j, r, g, b);
						}
						if (x+i < xo && y-j >= 0) {
							fill(out, xo, x+i, y-j, r, g, b);
						}
						if (x-i >= 0 && y-j >= 0) {
							fill(out, xo, x-i, y-j, r, g, b);
						}
					}
				}
			}
		}
	}
}


void plugin_seq_doit(Cast *cast, float facf0, float facf1, int xo, int yo,
	ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *outbuf, ImBuf *use) {
	char *in1, *out;		/* input and output buffers */
	unsigned char * aura, *aura2;
	int blur;			/* i is the counter for a for loop within the main
					   pixel loop. p is the actual position in the buffer. */

	in1 =  (char *)ibuf1->rect;	
	out =  (char *)outbuf->rect;

	/* Note to paprmh:
	   
	   Nothing personal, but I don't like using this code for initial color values, since it will
	   override whatever the user enters on the first render.
	
	if (!cast->dummy) {
		cast->dummy = 1;
		cast->green = 255;
	}
	
	*/
	
	aura = malloc(xo*yo*4);
	aura2 = malloc(xo*yo*4);
	if (cast->flicker) 
		blur = facf0*cast->blur;
	else blur = cast->blur;
	expandPixels(in1, aura, xo, yo, cast->glow, 1, cast->red, cast->green, cast->blue);
	RVIsolateHighlights(aura, aura, xo, yo, 0, 1.5, 1);
	gaussianBlur((char *)aura, (char *)aura2, xo, yo, blur*2, cast->quality);
	gaussianBlur((char *)aura, (char *)aura, xo, yo, blur, cast->quality);
	RVAddBitmaps(aura, aura2, out, xo, yo);
	RVAddBitmaps((unsigned char *)in1, (unsigned char *)out, out, xo, yo);
	gaussianBlur(out, out, xo, yo, cast->core_blur, cast->quality);
	free(aura);
	free(aura2);
}

