/*
 * LSD Plugin 0.1
 * change colors over time. nice to look at :)
 * Copyright (c) 1999, Stefan Gartner
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "LSD";

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{ LABEL,		"Input: 1 strip", 0.0, 0.0, 0.0, ""}, 
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int dummy;			/* because of the 'label' button */
} Cast;

/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);


/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int sx, int sy, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
   int x, y, sizeX, sizeY;
   float lsdR, lsdG, lsdB;
   char *rectIn, *rectOut;
   sizeX=ibuf1->x;
   sizeY=ibuf1->y;
   if (ibuf1) {
      rectIn = (char *) ibuf1->rect;
      rectOut = (char *) out->rect;
      y=sizeY;
      while(y--) {
         x=sizeX;
         /* make sure facf0 is within [0,1] */
         facf0 = facf0 < 0.0 ? 0.0 : (facf0 > 1.0 ? 1.0: facf0);
         while (x--) {
            if (facf0 <= .5) {
               lsdR = (facf0*2);
            } else {
               lsdR = ((1- facf0)*2);
            }
            if (facf0 <= .25) {
               lsdG = (facf0*4);
            } else {
               lsdG = ((1- facf0)*4);
            }
            if ((facf0 <= 1.0/3.0) || (facf0 >=2.0/3.0)) {
               lsdB = (facf0*3);
            } else {
               lsdB = ((1- facf0)*3);
            }
            rectOut[0] = (255.0*lsdR - rectIn[0])/2.0+255.0/2.0;
            rectOut[1] = (255.0*lsdG - rectIn[1])/2.0+255.0/2.0;
            rectOut[2] = (255.0*lsdB - rectIn[2])/2.0+255.0/2.0;
            rectIn+=4;
            rectOut+=4;
         }         
      }  
   }
}




