/* 
 * Copyright (c) 1999, Kiernan Holland
 * 
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "make/mix color";

/* structure for buttons, 
 *  butcode      name           default  min  max  0
 */

VarStruct varstr[]= {
	{TOG|INT,   "Enable Mixer",         0.0,    0.0, 1.0, "Toggles Mixer. faster!"},
	{NUMSLI|FLO,	"Mix ",			1.0,	0.0, 1.0, "Image/RGB Mix"},
	{NUMSLI|FLO,	"Red ",			0.5,	0.0, 1.0, "Red Value"},
	{NUMSLI|FLO,	"Green ",		0.5,	0.0, 1.0, "Green Value"},
	{NUMSLI|FLO,	"Blue ",		0.5,	0.0, 1.0, "Blue Value"}
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int mixerTOGGLE;
	float mix; 
	float red;
	float green;
	float blue;
} Cast;

/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

/* ************************************************************
	Make Color / Mix Color
	
	This plugin allows one to create a color or mix a color 
	with an existing image. 

   ************************************************************ */


void plugin_seq_doit(Cast *cast, float facf0, float facf1, int sx, int sy, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{

	int a;
	char *rectc;
	char *rectIN;
	float ANTImix, PROmix;
	

	ANTImix = (1.0 - cast->mix);
	PROmix = (cast->mix);

	if(ibuf1) {
		a= ibuf1->x*ibuf1->y;
		rectc= (char *)out->rect;
		rectIN= (char *)ibuf1->rect;

		if (cast->mixerTOGGLE) {
				while(a--) {
				rectc[0] = (char)  ((255 * ((cast->red) * 
				   (ANTImix))) + ((PROmix) * (rectIN[3])));
				rectc[1] = (char)  ((255 * ((cast->green) * 
                                   (ANTImix))) + ((PROmix) * (rectIN[2])));
				rectc[2] = (char)  ((255 * ((cast->blue) * 
                                   (ANTImix))) + ((PROmix) * (rectIN[1])));
				rectc[3] = 255;
				rectc+= 4;
				rectIN+= 4;
				}
			} else { 
				while(a--) {
				rectc[0] = (char)  (255 * (cast->red));
				rectc[1] = (char)  (255 * (cast->green));
				rectc[2] = (char)  (255 * (cast->blue));
				rectc[3] = 255;
				rectc+= 4;
				}
			}
	}
}

