/* 
 *    Made by Joeri Kassenaar. 
 * 
 */

#include "plugin.h"

/* ******************** GLOBAL VARIABLES ***************** */


char name[24]= "Robocop";	

/* structure for buttons, 
 *  butcode      name           default  min  max    info
 */

VarStruct varstr[]= {
	{ LABEL,		"Input: 1 strip",  0.0, 0.0, 0.0, ""},
	{ NUM|FLO,	"Thickness",     0.0,	 2.0, 12.0, 
	   "thickness of lines"}, 
	{ NUM|FLO,	"Red",		0.6,	 0.0, 2.0, "red"}, 
	{ NUM|FLO,	"Green",	0.9,	 0.0, 2.0, "green"}, 
	{ NUM|FLO,	"Blue",		0.6,	 0.0, 2.0, "blue"}, 
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */ 

typedef struct Cast {
	int dummy;			/* because of the 'label' button */
    float dist, rf, gf, bf;
} Cast;


/* cfra: the current frame */

float cfra;

void plugin_seq_doit(Cast *, float, float, int, int, ImBuf *, ImBuf *, ImBuf *, ImBuf *);

/* ******************** Fixed functions ***************** */

int plugin_seq_getversion(void) 
{
	return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but) 
{
}

void plugin_init()
{
}

void plugin_getinfo(PluginInfo *info)
{
	info->name= name;
	info->nvars= sizeof(varstr)/sizeof(VarStruct);
	info->cfra= &cfra;

	info->varstr= varstr;

	info->init= plugin_init;
	info->seq_doit= (SeqDoit) plugin_seq_doit;
	info->callback= plugin_but_changed;
}

void plugin_seq_doit(Cast *cast, float facf0, float facf1, int x, int y, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *ibufo, ImBuf *use)
{
	float f, rp, gp, bp, rn, gn, bn;
	int   i, xo, mid1, mid2, mid3, even;
	char *fac, *in1, *in2, *out;	
	
	xo= x;
	fac=  (char *)use->rect;
	in1=  (char *)ibuf1->rect;
	in2=  (char *)ibuf2->rect;
	out=  (char *)ibufo->rect;


	f= (cast->rf + cast->gf + cast->bf) / 3.0;
    rn= (cast->rf -.2) / f; rp= (cast->rf +.2) / f;
    gn= (cast->gf -.2) / f; gp= (cast->gf +.2) / f;
    bn= (cast->bf -.2) / f; bp= (cast->bf +.2) / f;
	
	while(y--) {
		x= xo;
		if (y & 2) even=1; else even=0;
		
		if (cast->dist > 0.0) {
			
			f= (float) (y / cast->dist);
			i= (int) f;
			f= f-i;
			if (f < .5) even=1; else even=0;
		}
	
		while(x--) {
		   
		    if (even){
				mid1=  rn * in1[0]; if (mid1 > 255) mid1=255;
				mid2=  bn * in1[1]; if (mid2 > 255) mid2=255;
				mid3=  gn * in1[2]; if (mid2 > 255) mid2=255;
			}else{
				mid1=  in1[0] * rp; if (mid1 > 255) mid1=255;
				mid2=  in1[1] * bp; if (mid2 > 255) mid2=255;
				mid3=  in1[2] * gp; if (mid2 > 255) mid2=255;
			}
			mid1 &= 255; mid2 &= 255; mid3 &= 255;
		
			out[0]= 0;
			out[1]= mid1;	/* R */
			out[2]= mid2;	/* G */
			out[3]= mid3;	/* B */
			
			fac +=4; in1 +=4; in2 +=4;
			out +=4;
		}		
	}

}	


