#include <plugin.h>

#define COLORREF unsigned long
double cx, cy;
double deg, sc;
COLORREF outcol;

/* Degrees handling */
#define DEG2RAD(deg) ((deg) * (0.017453292519943295769236907684886))

/* colour commands */
#define RED(c)   ((c) & 0xFFL)
#define GREEN(c) (((c) & 0xFF00L) >> 8)
#define BLUE(c)  (((c) & 0xFF0000L) >> 16)
#ifndef RGB
#define RGB(r,g,b) ((r) | (g) << 8 | (b) << 16)
#endif /* !RGB */

#define PLUGIN_NAME "Spin"

/* structure for buttons,
 *  butcode      name           default  min  max  tooltip
 */

#define NUM_PARAM 14
VarStruct varstr[NUM_PARAM] = {
  {LABEL     , "IN: 1 or 2", 0.0f, 0.0f, 0.0f, ""},
  {FLO|NUM   , "Degrees:", 360.0f, -1080.0f, 1080.0f, 
	"Number of degrees to rotate NB: +ve is CW, -ve is CCW"},
  {FLO|NUM   , "Scale:", 1.0f, 0.0f, 10.0f, "Zoom in/out on picture"},
  {INT|TOG   , "Animate", 1.0f, 0.0f, 1.0f, 
	"Multiply Degree and Scale by IPO value"},
  {INT|TOG   , "Crossfade", 0.0f, 0.0f, 1.0f, "Use second strip"},
  {INT|TOG   , "Spiral", 1.0f, 0.0f, 1.0f, "Multiply Degree by radius"},
  {LABEL     , "Outside Colour", 0.0f, 0.0f, 0.0f, ""},
  {FLO|NUMSLI, "R", 0.5f, 0.0f, 1.0f, "Outside colour to use if style = 0"},
  {FLO|NUMSLI, "G", 0.5f, 0.0f, 1.0f, "Outside colour to use if style = 0"},
  {FLO|NUMSLI, "B", 0.5f, 0.0f, 1.0f, "Outside colour to use if style = 0"},
  {INT|NUM   , "Outside Style:", 1.0f, 0.0f, 3.0f, 
	"0: solid colour 1: rectangular extend 2: radial extend 3: wrap"},
  {INT|NUM   , "CX", 0.0f, -1024.0f, 1024.0f, "Centre offset"},
  {INT|NUM   , "CY", 0.0f, -1024.0f, 1024.0f, "Centre offset"},
  {INT|TOG   , "Interpolate", 1.0f, 0.0f, 1.0f, 
	"Interpolate (anti-alias) pixels"},
};

/* The cast struct is for input in the main doit function
   Varstr and Cast must have the same variables in the same order */

typedef struct {
  int   dummy;
  float deg;
  float scale;
  int   anim;
  int   crossfade;
  int   spiral;
  int   dummy2;
  float r;
  float g;
  float b;
  int   out;
  int   cx;
  int   cy;
  int   inter;
} Cast;

float cfra; /* current frame */

void plugin_seq_doit(Cast *, float, float, int, int, 
   ImBuf *, ImBuf *, ImBuf *, ImBuf *);

COLORREF dowork(int x, int y, int sx, int sy, Cast *param, COLORREF *recti)
{
  double x1, y1, r, t;
  int tol, tor, tot, tob;
  double dx, dy;
  int n;
  /* used for interpolation */
  int c1, c2, c3, c4;
  int r1, r2, r3, r4;
  int g1, g2, g3, g4;
  int b1, b2, b3, b4;
  double f1, f2, f3, f4;
  int rt, gt, bt;

  x1 = (double)x - cx;
  y1 = (double)y - cy;

  /* Convert to Pol */
  r = sqrt(x1 * x1 + y1 * y1);
  t = atan2(y1, x1);

  /* rotate pixel */
  if (param->spiral)
    t += r * deg;
  else
    t += deg;
  /* scale pixel */
  r /= sc;

  /* Convert to Rect Cords */
  x1 = r * cos(t);  
  y1 = r * sin(t);

  x1 += cx;
  y1 += cy;
  /* (x1, y1) is now rotated point */
  tol = (x1 < 0);
  tor = (x1 > sx - 1);
  tot = (y1 > sy - 1);
  tob = (y1 < 0);
  if (tol || tor || tot || tob)
  {
    switch (param->out)
    {
    case 0: /*colour*/
      return outcol;
      break; /*habit*/
    case 1: /*rectangular*/
      /* performed after switch */
      break;
    case 2: /*radial*/
      if (!(tot || tob))
      {
        /* off to the side only */
        if (tol)
          dx = (cx - x1) / cx;
        else
          dx = (x1 - cx) / (sx - cx);
        x1 = (x1 - cx) / dx + cx;
        y1 = (y1 - cy) / dx + cy;
      }
      else if (!(tol || tor))
      {
        /* above or below only */
        if (tob)
          dy = (cy - y1) / cy;
        else
          dy = (y1 - cy) / (sy - cy);
        x1 = (x1 - cx) / dy + cx;
        y1 = (y1 - cy) / dy + cy;
      }
      else
      {
        /* off to a corner */
        if (tol)
          dx = (cx - x1) / cx;
        else
          dx = (x1 - cx) / (sx - cx);
        if (tob)
          dy = (cy - y1) / cy;
        else
          dy = (y1 - cy) / (sy - cy);
        if (dy > dx) dx = dy; /* use larger value */
        x1 = (x1 - cx) / dx + cx;
        y1 = (y1 - cy) / dx + cy;
      }
      break;
    case 3: /*wrap*/
      while (x1 < 0) x1 += sx;
      while (x1 >= sx) x1 -= sx;
      while (y1 < 0) y1 += sy;
      while (y1 >= sy) y1 -= sy;
      break;
    }
  }
  /* ensure that pixel within picture */
  if (x1 < 0) x1 = 0;
  if (x1 > sx - 1) x1 = sx - 1;
  if (y1 < 0) y1 = 0;
  if (y1 > sy - 1) y1 = sy - 1;
  /* (x1, y1) is now destmapped pixel */
  if (param->inter)
  {
    n = (int)x1 + sx * (int)y1;
    x1 -= (double)(int)x1;
    y1 -= (double)(int)y1;
    tol = (x1 < 0.01);
    tob = (y1 < 0.01);
    if (tol && tob)
    {
      return recti[n];
    }
    else if (tol)
    {
      c1 = recti[n];
      c2 = recti[n + sx];
      f1 = (1 - y1);
      f2 = y1;
      r1 = RED(c1);
      r2 = RED(c2);
      g1 = GREEN(c1);
      g2 = GREEN(c2);
      b1 = BLUE(c1);
      b2 = BLUE(c2);
      rt = (int)(r1 * f1 + r2 * f2);
      gt = (int)(g1 * f1 + g2 * f2);
      bt = (int)(b1 * f1 + b2 * f2);
      return RGB(rt, gt, bt);
    }
    else if (tob)
    {
      c1 = recti[n];
      c2 = recti[n + 1];
      f1 = (1 - x1);
      f2 = x1;
      r1 = RED(c1);
      r2 = RED(c2);
      g1 = GREEN(c1);
      g2 = GREEN(c2);
      b1 = BLUE(c1);
      b2 = BLUE(c2);
      rt = (int)(r1 * f1 + r2 * f2);
      gt = (int)(g1 * f1 + g2 * f2);
      bt = (int)(b1 * f1 + b2 * f2);
      return RGB(rt, gt, bt);
    }
    else
    {
      c1 = recti[n];
      c2 = recti[n + 1];
      c3 = recti[n + sx];
      c4 = recti[n + sx + 1];
      f1 = (1 - x1) * (1 - y1);
      f2 = x1 * (1 - y1);
      f3 = (1 - x1) * y1;
      f4 = x1 * y1;
      r1 = RED(c1);
      r2 = RED(c2);
      r3 = RED(c3);
      r4 = RED(c4);
      g1 = GREEN(c1);
      g2 = GREEN(c2);
      g3 = GREEN(c3);
      g4 = GREEN(c4);
      b1 = BLUE(c1);
      b2 = BLUE(c2);
      b3 = BLUE(c3);
      b4 = BLUE(c4);
      rt = (int)(r1 * f1 + r2 * f2 + r3 * f3 + r4 * f4);
      gt = (int)(g1 * f1 + g2 * f2 + g3 * f3 + g4 * f4);
      bt = (int)(b1 * f1 + b2 * f2 + b3 * f3 + b4 * f4);
      return RGB(rt, gt, bt);
    }
  }
  else
  {
    n = (int)x1 + sx * (int)y1;
    return recti[n];
  }
}
/* ******************** Plugin functions ***************** */

int plugin_seq_getversion(void)
{
  return B_PLUGIN_VERSION;
}

void plugin_but_changed(int but)
{
}

void plugin_init(void)
{
}

void plugin_getinfo(PluginInfo *info)
{
  info->name = PLUGIN_NAME;

  info->nvars = NUM_PARAM;
  info->varstr = varstr;

  info->cfra = &cfra;

  info->init = plugin_init;
  info->seq_doit = (SeqDoit)plugin_seq_doit;
  info->callback = plugin_but_changed;
}

void plugin_seq_doit(Cast *param, float facf0, float facf1, int sx, 
	int sy, ImBuf *ibuf1, ImBuf *ibuf2, ImBuf *out, ImBuf *use)
{
  int x, y;
  COLORREF *recto;
  COLORREF *recti, *recti2, o1, o2;
  double d1, d2, s1, s2;
  /* used for fade */
  int r1, g1, b1;
  int r2, g2, b2;
  int rt, gt, bt;

  cx = (double)(sx / 2 + param->cx);
  cy = (double)(sy / 2 + param->cy);

  if (param->anim)
  {
    deg = d1 = DEG2RAD((double)(facf0 * param->deg));
          d2 = DEG2RAD((double)((facf0 - 1) * param->deg));
    sc = s1 = pow(param->scale, facf0);
         s2 = pow(1 / param->scale, 1 - facf0);
  }
  else
  {
    deg = d1 = DEG2RAD((double)param->deg);
          d2 = DEG2RAD(-(double)param->deg);
    sc = s1 = param->scale;
         s2 = 1 / param->scale;
  }
  if (param->spiral)
  {
    deg /= (sx / 2);
    d1 /= (sx / 2);
    d2 /= (sx / 2);
  }
  rt = (int)(param->r * 255.0);
  gt = (int)(param->g * 255.0);
  bt = (int)(param->b * 255.0);
  outcol =  RGB(rt, gt, bt);

  if (param->crossfade)
  {
    if(ibuf2 && ibuf1)
    {
      recto  = (COLORREF *)out->rect;
      recti  = (COLORREF *)ibuf1->rect;
      recti2 = (COLORREF *)ibuf2->rect;
      x = y = 0;
      while (y < sy)
      {
        deg = d1;
        sc = s1;
        o1 = dowork(x, y, sx, sy, param, recti);
        deg = d2;
        sc = s2;
        o2 = dowork(x, y, sx, sy, param, recti2);
        r1 = RED(o1);
        g1 = GREEN(o1);
        b1 = BLUE(o1);
        r2 = RED(o2);
        g2 = GREEN(o2);
        b2 = BLUE(o2);
        rt = (int)(r1 + ((r2 - r1) * facf0));
        gt = (int)(g1 + ((g2 - g1) * facf0));
        bt = (int)(b1 + ((b2 - b1) * facf0));
        *recto++ = RGB(rt, gt, bt);
        /* keep track of pointer */
        /* this method is faster than nested for loops */
        if (++x >= sx)
        {
          x = 0;
          ++y;
        }
      }
    }
    else
      printf ("Not linked to 2 strips!\n");
  }
  else
  {
    if(ibuf1)
    {
      recto = (COLORREF *)out->rect;
      recti = (COLORREF *)ibuf1->rect;
      x = y = 0;
      while (y < sy)
      {
        *recto++ = dowork(x, y, sx, sy, param, recti);
        /* keep track of pointer */
        /* this method is faster than nested for loops */
        if (++x >= sx)
        {
          x = 0;
          ++y;
        }
      }
    }
    else
      /* i don't know this can happen, but check anyway */
      printf ("Not linked to a strip!\n");
  }
}
